/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.server.capabilities;

import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.server.DeepNamedValueScanner;
import com.liferay.portal.server.capabilities.ServerCapabilities;
import javax.servlet.ServletContext;

public class JBossServerCapabilities
implements ServerCapabilities {
    private boolean _supportsHotDeploy;

    @Override
    public void determine(ServletContext servletContext) throws Exception {
        this.determineSupportsHotDeploy(servletContext);
    }

    @Override
    public boolean isSupportsHotDeploy() {
        return this._supportsHotDeploy;
    }

    protected void determineSupportsHotDeploy(ServletContext servletContext) throws Exception {
        if (ServerDetector.isJBoss5()) {
            this._supportsHotDeploy = true;
        } else {
            DeepNamedValueScanner deepNamedValueScanner = new DeepNamedValueScanner("scanEnabled", true);
            deepNamedValueScanner.setExcludedClassNames("ChainedInterceptorFactory", "TagAttributeInfo", ".jandex.", ".vfs.");
            deepNamedValueScanner.setExcludedNames("serialversion");
            deepNamedValueScanner.setIncludedClassNames("org.apache.", "org.jboss.");
            deepNamedValueScanner.setVisitArrays(true);
            deepNamedValueScanner.setVisitMaps(true);
            deepNamedValueScanner.scan(servletContext);
            Boolean scanEnabledValue = (Boolean)deepNamedValueScanner.getMatchedValue();
            this._supportsHotDeploy = scanEnabledValue == null ? false : scanEnabledValue;
        }
    }
}

