/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicatePasswordPolicyException;
import com.liferay.portal.PasswordPolicyNameException;
import com.liferay.portal.RequiredPasswordPolicyException;
import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.PasswordPolicyRel;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.PasswordPolicyLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.util.Date;
import java.util.List;

public class PasswordPolicyLocalServiceImpl
extends PasswordPolicyLocalServiceBaseImpl {
    public PasswordPolicy addPasswordPolicy(long userId, boolean defaultPolicy, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge) throws PortalException, SystemException {
        return this.addPasswordPolicy(userId, defaultPolicy, name, description, changeable, changeRequired, minAge, checkSyntax, allowDictionaryWords, minAlphanumeric, minLength, minLowerCase, minNumbers, minSymbols, minUpperCase, null, history, historyCount, expireable, maxAge, warningTime, graceLimit, lockout, maxFailure, lockoutDuration, resetFailureCount, resetTicketMaxAge, new ServiceContext());
    }

    public PasswordPolicy addPasswordPolicy(long userId, boolean defaultPolicy, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, String regex, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), name);
        long passwordPolicyId = this.counterLocalService.increment();
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.create(passwordPolicyId);
        passwordPolicy.setUuid(serviceContext.getUuid());
        passwordPolicy.setCompanyId(user.getCompanyId());
        passwordPolicy.setUserId(userId);
        passwordPolicy.setUserName(user.getFullName());
        passwordPolicy.setCreateDate(serviceContext.getCreateDate(now));
        passwordPolicy.setModifiedDate(serviceContext.getModifiedDate(now));
        passwordPolicy.setDefaultPolicy(defaultPolicy);
        passwordPolicy.setName(name);
        passwordPolicy.setDescription(description);
        passwordPolicy.setChangeable(changeable);
        passwordPolicy.setChangeRequired(changeRequired);
        passwordPolicy.setMinAge(minAge);
        passwordPolicy.setCheckSyntax(checkSyntax);
        passwordPolicy.setAllowDictionaryWords(allowDictionaryWords);
        passwordPolicy.setMinAlphanumeric(minAlphanumeric);
        passwordPolicy.setMinLength(minLength);
        passwordPolicy.setMinLowerCase(minLowerCase);
        passwordPolicy.setMinNumbers(minNumbers);
        passwordPolicy.setMinSymbols(minSymbols);
        passwordPolicy.setMinUpperCase(minUpperCase);
        passwordPolicy.setRegex(regex);
        passwordPolicy.setHistory(history);
        passwordPolicy.setHistoryCount(historyCount);
        passwordPolicy.setExpireable(expireable);
        passwordPolicy.setMaxAge(maxAge);
        passwordPolicy.setWarningTime(warningTime);
        passwordPolicy.setGraceLimit(graceLimit);
        passwordPolicy.setLockout(lockout);
        passwordPolicy.setMaxFailure(maxFailure);
        passwordPolicy.setLockoutDuration(lockoutDuration);
        passwordPolicy.setRequireUnlock(lockoutDuration == 0L);
        passwordPolicy.setResetFailureCount(resetFailureCount);
        passwordPolicy.setResetTicketMaxAge(resetTicketMaxAge);
        passwordPolicy.setExpandoBridgeAttributes(serviceContext);
        this.passwordPolicyPersistence.update((BaseModel)passwordPolicy);
        if (!user.isDefaultUser()) {
            this.resourceLocalService.addResources(user.getCompanyId(), 0L, userId, PasswordPolicy.class.getName(), passwordPolicy.getPasswordPolicyId(), false, false, false);
        }
        return passwordPolicy;
    }

    public void checkDefaultPasswordPolicy(long companyId) throws PortalException, SystemException {
        String defaultPasswordPolicyName = PropsValues.PASSWORDS_DEFAULT_POLICY_NAME;
        PasswordPolicy defaultPasswordPolicy = this.passwordPolicyPersistence.fetchByC_N(companyId, defaultPasswordPolicyName);
        if (defaultPasswordPolicy == null) {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            this.addPasswordPolicy(defaultUserId, true, defaultPasswordPolicyName, defaultPasswordPolicyName, PropsValues.PASSWORDS_DEFAULT_POLICY_CHANGEABLE, PropsValues.PASSWORDS_DEFAULT_POLICY_CHANGE_REQUIRED, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_AGE, PropsValues.PASSWORDS_DEFAULT_POLICY_CHECK_SYNTAX, PropsValues.PASSWORDS_DEFAULT_POLICY_ALLOW_DICTIONARY_WORDS, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_ALPHANUMERIC, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_LENGTH, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_LOWERCASE, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_NUMBERS, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_SYMBOLS, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_UPPERCASE, PropsValues.PASSWORDS_DEFAULT_POLICY_REGEX, PropsValues.PASSWORDS_DEFAULT_POLICY_HISTORY, PropsValues.PASSWORDS_DEFAULT_POLICY_HISTORY_COUNT, PropsValues.PASSWORDS_DEFAULT_POLICY_EXPIREABLE, PropsValues.PASSWORDS_DEFAULT_POLICY_MAX_AGE, PropsValues.PASSWORDS_DEFAULT_POLICY_WARNING_TIME, PropsValues.PASSWORDS_DEFAULT_POLICY_GRACE_LIMIT, PropsValues.PASSWORDS_DEFAULT_POLICY_LOCKOUT, PropsValues.PASSWORDS_DEFAULT_POLICY_MAX_FAILURE, PropsValues.PASSWORDS_DEFAULT_POLICY_LOCKOUT_DURATION, PropsValues.PASSWORDS_DEFAULT_POLICY_RESET_FAILURE_COUNT, PropsValues.PASSWORDS_DEFAULT_POLICY_RESET_TICKET_MAX_AGE, new ServiceContext());
        }
    }

    public void deleteNondefaultPasswordPolicies(long companyId) throws PortalException, SystemException {
        List passwordPolicies = this.passwordPolicyPersistence.findByCompanyId(companyId);
        for (PasswordPolicy passwordPolicy : passwordPolicies) {
            if (passwordPolicy.isDefaultPolicy()) continue;
            this.passwordPolicyLocalService.deletePasswordPolicy(passwordPolicy);
        }
    }

    @Override
    public PasswordPolicy deletePasswordPolicy(long passwordPolicyId) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyId);
        return this.passwordPolicyLocalService.deletePasswordPolicy(passwordPolicy);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public PasswordPolicy deletePasswordPolicy(PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        if (passwordPolicy.isDefaultPolicy() && !CompanyThreadLocal.isDeleteInProcess()) {
            throw new RequiredPasswordPolicyException();
        }
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicy.getPasswordPolicyId());
        this.resourceLocalService.deleteResource(passwordPolicy.getCompanyId(), PasswordPolicy.class.getName(), 4, passwordPolicy.getPasswordPolicyId());
        return (PasswordPolicy)this.passwordPolicyPersistence.remove((BaseModel)passwordPolicy);
    }

    public PasswordPolicy fetchPasswordPolicy(long companyId, String name) throws SystemException {
        return this.passwordPolicyPersistence.fetchByC_N(companyId, name);
    }

    public PasswordPolicy getDefaultPasswordPolicy(long companyId) throws PortalException, SystemException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(companyId)) {
            return null;
        }
        return this.passwordPolicyPersistence.findByC_DP(companyId, true);
    }

    public PasswordPolicy getPasswordPolicy(long companyId, long organizationId, long locationId) throws PortalException, SystemException {
        return this.getPasswordPolicy(companyId, new long[]{organizationId, locationId});
    }

    public PasswordPolicy getPasswordPolicy(long companyId, long[] organizationIds) throws PortalException, SystemException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(companyId)) {
            return null;
        }
        if (ArrayUtil.isEmpty((long[])organizationIds)) {
            return this.getDefaultPasswordPolicy(companyId);
        }
        long classNameId = this.classNameLocalService.getClassNameId(Organization.class.getName());
        PasswordPolicyRel passwordPolicyRel = null;
        int i2 = 0;
        while (i2 < organizationIds.length) {
            long organizationId = organizationIds[i2];
            passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, organizationId);
            if (passwordPolicyRel != null) {
                return this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyRel.getPasswordPolicyId());
            }
            ++i2;
        }
        return this.getDefaultPasswordPolicy(companyId);
    }

    @ThreadLocalCachable
    public PasswordPolicy getPasswordPolicyByUserId(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
            return null;
        }
        long classNameId = this.classNameLocalService.getClassNameId(User.class.getName());
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, userId);
        if (passwordPolicyRel != null) {
            return this.getPasswordPolicy(passwordPolicyRel.getPasswordPolicyId());
        }
        List organizations = this.userPersistence.getOrganizations(userId);
        if (organizations.isEmpty()) {
            return this.passwordPolicyPersistence.findByC_DP(user.getCompanyId(), true);
        }
        long[] organizationIds = new long[organizations.size()];
        int i2 = 0;
        while (i2 < organizationIds.length) {
            Organization organization = (Organization)organizations.get(i2);
            organizationIds[i2] = organization.getOrganizationId();
            ++i2;
        }
        return this.getPasswordPolicy(user.getCompanyId(), organizationIds);
    }

    public List<PasswordPolicy> search(long companyId, String name, int start, int end, OrderByComparator obc) throws SystemException {
        return this.passwordPolicyFinder.findByC_N(companyId, name, start, end, obc);
    }

    public int searchCount(long companyId, String name) throws SystemException {
        return this.passwordPolicyFinder.countByC_N(companyId, name);
    }

    public PasswordPolicy updatePasswordPolicy(long passwordPolicyId, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge) throws PortalException, SystemException {
        return this.updatePasswordPolicy(passwordPolicyId, name, description, changeable, changeRequired, minAge, checkSyntax, allowDictionaryWords, minAlphanumeric, minLength, minLowerCase, minNumbers, minSymbols, minUpperCase, null, history, historyCount, expireable, maxAge, warningTime, graceLimit, lockout, maxFailure, lockoutDuration, resetFailureCount, resetTicketMaxAge, new ServiceContext());
    }

    public PasswordPolicy updatePasswordPolicy(long passwordPolicyId, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, String regex, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge, ServiceContext serviceContext) throws PortalException, SystemException {
        Date now = new Date();
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyId);
        if (!passwordPolicy.getDefaultPolicy()) {
            this.validate(passwordPolicyId, passwordPolicy.getCompanyId(), name);
            passwordPolicy.setName(name);
        }
        passwordPolicy.setModifiedDate(serviceContext.getModifiedDate(now));
        passwordPolicy.setDescription(description);
        passwordPolicy.setChangeable(changeable);
        passwordPolicy.setChangeRequired(changeRequired);
        passwordPolicy.setMinAge(minAge);
        passwordPolicy.setCheckSyntax(checkSyntax);
        passwordPolicy.setAllowDictionaryWords(allowDictionaryWords);
        passwordPolicy.setMinAlphanumeric(minAlphanumeric);
        passwordPolicy.setMinLength(minLength);
        passwordPolicy.setMinLowerCase(minLowerCase);
        passwordPolicy.setMinNumbers(minNumbers);
        passwordPolicy.setMinSymbols(minSymbols);
        passwordPolicy.setMinUpperCase(minUpperCase);
        passwordPolicy.setRegex(regex);
        passwordPolicy.setHistory(history);
        passwordPolicy.setHistoryCount(historyCount);
        passwordPolicy.setExpireable(expireable);
        passwordPolicy.setMaxAge(maxAge);
        passwordPolicy.setWarningTime(warningTime);
        passwordPolicy.setGraceLimit(graceLimit);
        passwordPolicy.setLockout(lockout);
        passwordPolicy.setMaxFailure(maxFailure);
        passwordPolicy.setLockoutDuration(lockoutDuration);
        passwordPolicy.setRequireUnlock(lockoutDuration == 0L);
        passwordPolicy.setResetFailureCount(resetFailureCount);
        passwordPolicy.setResetTicketMaxAge(resetTicketMaxAge);
        passwordPolicy.setExpandoBridgeAttributes(serviceContext);
        this.passwordPolicyPersistence.update((BaseModel)passwordPolicy);
        return passwordPolicy;
    }

    protected void validate(long passwordPolicyId, long companyId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new PasswordPolicyNameException();
        }
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.fetchByC_N(companyId, name);
        if (passwordPolicy != null && passwordPolicy.getPasswordPolicyId() != passwordPolicyId) {
            throw new DuplicatePasswordPolicyException("{passwordPolicyId=" + passwordPolicyId + "}");
        }
    }
}

