/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchPasswordPolicyRelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.PasswordPolicyRel;
import com.liferay.portal.service.base.PasswordPolicyRelLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.List;

public class PasswordPolicyRelLocalServiceImpl
extends PasswordPolicyRelLocalServiceBaseImpl {
    public PasswordPolicyRel addPasswordPolicyRel(long passwordPolicyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null) {
            if (passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
                return null;
            }
            this.passwordPolicyRelPersistence.remove((BaseModel)passwordPolicyRel);
        }
        long passwordPolicyRelId = this.counterLocalService.increment();
        passwordPolicyRel = this.passwordPolicyRelPersistence.create(passwordPolicyRelId);
        passwordPolicyRel.setPasswordPolicyId(passwordPolicyId);
        passwordPolicyRel.setClassNameId(classNameId);
        passwordPolicyRel.setClassPK(classPK);
        this.passwordPolicyRelPersistence.update((BaseModel)passwordPolicyRel);
        return passwordPolicyRel;
    }

    public void addPasswordPolicyRels(long passwordPolicyId, String className, long[] classPKs) throws SystemException {
        int i2 = 0;
        while (i2 < classPKs.length) {
            this.addPasswordPolicyRel(passwordPolicyId, className, classPKs[i2]);
            ++i2;
        }
    }

    public void deletePasswordPolicyRel(long passwordPolicyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
            this.passwordPolicyRelPersistence.remove((BaseModel)passwordPolicyRel);
        }
    }

    public void deletePasswordPolicyRel(String className, long classPK) throws SystemException {
        try {
            long classNameId = PortalUtil.getClassNameId((String)className);
            PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.findByC_C(classNameId, classPK);
            this.deletePasswordPolicyRel(passwordPolicyRel);
        }
        catch (NoSuchPasswordPolicyRelException noSuchPasswordPolicyRelException) {}
    }

    public void deletePasswordPolicyRels(long passwordPolicyId) throws SystemException {
        List passwordPolicyRels = this.passwordPolicyRelPersistence.findByPasswordPolicyId(passwordPolicyId);
        for (PasswordPolicyRel passwordPolicyRel : passwordPolicyRels) {
            this.deletePasswordPolicyRel(passwordPolicyRel);
        }
    }

    public void deletePasswordPolicyRels(long passwordPolicyId, String className, long[] classPKs) throws SystemException {
        int i2 = 0;
        while (i2 < classPKs.length) {
            this.deletePasswordPolicyRel(passwordPolicyId, className, classPKs[i2]);
            ++i2;
        }
    }

    public PasswordPolicyRel fetchPasswordPolicyRel(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
    }

    public PasswordPolicyRel getPasswordPolicyRel(long passwordPolicyId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
            return passwordPolicyRel;
        }
        StringBundler sb = new StringBundler(8);
        sb.append("No PasswordPolicyRel exists with the key {");
        sb.append("passwordPolicyId=");
        sb.append(passwordPolicyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchPasswordPolicyRelException(sb.toString());
    }

    public PasswordPolicyRel getPasswordPolicyRel(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.passwordPolicyRelPersistence.findByC_C(classNameId, classPK);
    }

    public boolean hasPasswordPolicyRel(long passwordPolicyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        return passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId;
    }
}

