/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.UserTracker;
import com.liferay.portal.model.UserTrackerPath;
import com.liferay.portal.service.base.UserTrackerLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.util.Date;
import java.util.List;

public class UserTrackerLocalServiceImpl
extends UserTrackerLocalServiceBaseImpl {
    public UserTracker addUserTracker(long companyId, long userId, Date modifiedDate, String sessionId, String remoteAddr, String remoteHost, String userAgent, List<UserTrackerPath> userTrackerPaths) throws SystemException {
        if (PropsValues.SESSION_TRACKER_PERSISTENCE_ENABLED) {
            long userTrackerId = this.counterLocalService.increment(UserTracker.class.getName());
            UserTracker userTracker = this.userTrackerPersistence.create(userTrackerId);
            userTracker.setCompanyId(companyId);
            userTracker.setUserId(userId);
            userTracker.setModifiedDate(modifiedDate);
            userTracker.setSessionId(sessionId);
            userTracker.setRemoteAddr(remoteAddr);
            userTracker.setRemoteHost(remoteHost);
            userTracker.setUserAgent(userAgent);
            this.userTrackerPersistence.update((BaseModel)userTracker);
            for (UserTrackerPath userTrackerPath : userTrackerPaths) {
                long pathId = this.counterLocalService.increment(UserTrackerPath.class.getName());
                userTrackerPath.setUserTrackerPathId(pathId);
                userTrackerPath.setUserTrackerId(userTrackerId);
                this.userTrackerPathPersistence.update((BaseModel)userTrackerPath);
            }
            return userTracker;
        }
        return null;
    }

    @Override
    public UserTracker deleteUserTracker(long userTrackerId) throws PortalException, SystemException {
        UserTracker userTracker = this.userTrackerPersistence.findByPrimaryKey(userTrackerId);
        return this.deleteUserTracker(userTracker);
    }

    @Override
    public UserTracker deleteUserTracker(UserTracker userTracker) throws SystemException {
        this.userTrackerPathPersistence.removeByUserTrackerId(userTracker.getUserTrackerId());
        return (UserTracker)this.userTrackerPersistence.remove((BaseModel)userTracker);
    }

    public List<UserTracker> getUserTrackers(long companyId, int start, int end) throws SystemException {
        return this.userTrackerPersistence.findByCompanyId(companyId, start, end);
    }
}

