/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.UserPermission;
import com.liferay.portal.util.PortalUtil;

public class UserPermissionImpl
implements UserPermission {
    private static Log _log = LogFactoryUtil.getLog(UserPermissionImpl.class);

    public void check(PermissionChecker permissionChecker, long userId, long organizationId, long locationId, String actionId) throws PrincipalException {
        this.check(permissionChecker, userId, new long[]{organizationId, locationId}, actionId);
    }

    public void check(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, userId, organizationIds, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long userId, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, userId, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long userId, long organizationId, long locationId, String actionId) {
        return this.contains(permissionChecker, userId, new long[]{organizationId, locationId}, actionId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) {
        if ((actionId.equals("DELETE") || actionId.equals("IMPERSONATE") || actionId.equals("PERMISSIONS") || actionId.equals("UPDATE")) && PortalUtil.isOmniadmin((long)userId) && !permissionChecker.isOmniadmin()) {
            return false;
        }
        try {
            User user = null;
            if (userId != -1L) {
                user = UserLocalServiceUtil.getUserById((long)userId);
                Contact contact = user.getContact();
                if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), User.class.getName(), userId, contact.getUserId(), actionId)) return true;
                if (permissionChecker.getUserId() == userId) {
                    return true;
                }
            }
            if (permissionChecker.hasPermission(0L, User.class.getName(), userId, actionId)) {
                return true;
            }
            if (user == null) {
                return false;
            }
            if (organizationIds == null) {
                organizationIds = user.getOrganizationIds();
            }
            long[] lArray = organizationIds;
            int n = organizationIds.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                long organizationId = lArray[n2];
                if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"MANAGE_USERS")) {
                    if (permissionChecker.getUserId() == user.getUserId()) {
                        return true;
                    }
                    Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                    Group organizationGroup = organization.getGroup();
                    if (!UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)user.getUserId(), (long)organizationGroup.getGroupId(), (String)"Organization Owner", (boolean)true)) {
                        if (!UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)user.getUserId(), (long)organizationGroup.getGroupId(), (String)"Organization Administrator", (boolean)true)) return true;
                        if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)permissionChecker.getUserId(), (long)organizationGroup.getGroupId(), (String)"Organization Owner", (boolean)true)) return true;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, long userId, String actionId) {
        return this.contains(permissionChecker, userId, null, actionId);
    }
}

