/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.RoleImpl;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.persistence.RoleFinder;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RoleFinderImpl
extends BasePersistenceImpl<Role>
implements RoleFinder {
    public static final String COUNT_BY_ORGANIZATION = String.valueOf(RoleFinder.class.getName()) + ".countByOrganization";
    public static final String COUNT_BY_ORGANIZATION_SITE = String.valueOf(RoleFinder.class.getName()) + ".countByOrganizationSite";
    public static final String COUNT_BY_SITE = String.valueOf(RoleFinder.class.getName()) + ".countBySite";
    public static final String COUNT_BY_USER = String.valueOf(RoleFinder.class.getName()) + ".countByUser";
    public static final String COUNT_BY_USER_GROUP = String.valueOf(RoleFinder.class.getName()) + ".countByUserGroup";
    public static final String COUNT_BY_USER_GROUP_SITE = String.valueOf(RoleFinder.class.getName()) + ".countByUserGroupSite";
    public static final String COUNT_BY_U_G_R = String.valueOf(RoleFinder.class.getName()) + ".countByU_G_R";
    public static final String COUNT_BY_C_N_D_T = String.valueOf(RoleFinder.class.getName()) + ".countByC_N_D_T";
    public static final String FIND_BY_SYSTEM = String.valueOf(RoleFinder.class.getName()) + ".findBySystem";
    public static final String FIND_BY_USER_GROUP_GROUP_ROLE = String.valueOf(RoleFinder.class.getName()) + ".findByUserGroupGroupRole";
    public static final String FIND_BY_USER_GROUP_ROLE = String.valueOf(RoleFinder.class.getName()) + ".findByUserGroupRole";
    public static final String FIND_BY_C_N = String.valueOf(RoleFinder.class.getName()) + ".findByC_N";
    public static final String FIND_BY_U_G = String.valueOf(RoleFinder.class.getName()) + ".findByU_G";
    public static final String FIND_BY_R_N_A = String.valueOf(RoleFinder.class.getName()) + ".findByR_N_A";
    public static final String FIND_BY_C_N_D_T = String.valueOf(RoleFinder.class.getName()) + ".findByC_N_D_T";
    public static final String FIND_BY_C_N_S_P = String.valueOf(RoleFinder.class.getName()) + ".findByC_N_S_P";
    public static final String FIND_BY_C_N_S_P_A = String.valueOf(RoleFinder.class.getName()) + ".findByC_N_S_P_A";
    public static final String JOIN_BY_USERS_ROLES = String.valueOf(RoleFinder.class.getName()) + ".joinByUsersRoles";
    private String _countByR_U;

    public int countByR_U(long roleId, long userId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(this.getCountByR_U_SQL());
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i2 = 0;
            while (i2 < 6) {
                qPos.add(roleId);
                qPos.add(userId);
                ++i2;
            }
            int n = q.list().size();
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByU_G_R(long userId, long groupId, long roleId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_U_G_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(roleId);
            qPos.add(groupId);
            qPos.add(userId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_N_D_T(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        String[] names = CustomSQLUtil.keywords((String)name);
        String[] descriptions = CustomSQLUtil.keywords((String)description);
        return this.countByC_N_D_T(companyId, names, descriptions, types, params, andOperator);
    }

    public int countByC_N_D_T(long companyId, String[] names, String[] descriptions, Integer[] types, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        names = CustomSQLUtil.keywords((String[])names, (boolean)true);
        descriptions = CustomSQLUtil.keywords((String[])descriptions, (boolean)true);
        if (types == null) {
            types = new Integer[]{};
        }
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_N_D_T);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Role_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Role_.description)", (String)"LIKE", (boolean)true, (String[])descriptions);
            sql = StringUtil.replace((String)sql, (String)"[$TYPE$]", (String)this.getTypes(types));
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            qPos.add(types);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByKeywords(long companyId, String keywords, Integer[] types) throws SystemException {
        return this.countByKeywords(companyId, keywords, types, new LinkedHashMap<String, Object>());
    }

    public int countByKeywords(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params) throws SystemException {
        String[] names = null;
        String[] descriptions = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
            descriptions = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.countByC_N_D_T(companyId, names, descriptions, types, params, andOperator);
    }

    public List<Role> findBySystem(long companyId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SYSTEM);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByUserGroupGroupRole(long userId, long groupId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_USER_GROUP_GROUP_ROLE);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(groupId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByUserGroupRole(long userId, long groupId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_USER_GROUP_ROLE);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(groupId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Role findByC_N(long companyId, String name) throws NoSuchRoleException, SystemException {
        name = StringUtil.lowerCase((String)name);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(name);
            List roles = q.list();
            if (!roles.isEmpty()) {
                Role role = (Role)roles.get(0);
                return role;
            }
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("No Role exists with the key {companyId=");
        sb.append(companyId);
        sb.append(", name=");
        sb.append(name);
        sb.append("}");
        throw new NoSuchRoleException(sb.toString());
    }

    public List<Role> findByU_G(long userId, List<Group> groups) throws SystemException {
        long[] groupIds = new long[groups.size()];
        int i2 = 0;
        while (i2 < groups.size()) {
            Group group = groups.get(i2);
            groupIds[i2] = group.getGroupId();
            ++i2;
        }
        return this.findByU_G(userId, groupIds);
    }

    public List<Role> findByU_G(long userId, long groupId) throws SystemException {
        return this.findByU_G(userId, new long[]{groupId});
    }

    public List<Role> findByU_G(long userId, long[] groupIds) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_U_G);
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(groupIds, "Groups_Roles"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(groupIds);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByR_N_A(long resourceBlockId, String className, String actionId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_R_N_A);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(resourceBlockId);
            qPos.add(className);
            ResourceAction resourceAction = ResourceActionLocalServiceUtil.getResourceAction((String)className, (String)actionId);
            qPos.add(resourceAction.getBitwiseValue());
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByC_N_D_T(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        String[] names = CustomSQLUtil.keywords((String)name);
        String[] descriptions = CustomSQLUtil.keywords((String)description);
        return this.findByC_N_D_T(companyId, names, descriptions, types, params, andOperator, start, end, obc);
    }

    public List<Role> findByC_N_D_T(long companyId, String[] names, String[] descriptions, Integer[] types, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        names = CustomSQLUtil.keywords((String[])names, (boolean)true);
        descriptions = CustomSQLUtil.keywords((String[])descriptions, (boolean)true);
        if (types == null) {
            types = new Integer[]{};
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N_D_T);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Role_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Role_.description)", (String)"LIKE", (boolean)true, (String[])descriptions);
            sql = StringUtil.replace((String)sql, (String)"[$TYPE$]", (String)this.getTypes(types));
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            qPos.add(types);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Map<String, List<String>> findByC_N_S_P(long companyId, String name, int scope, String primKey) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N_S_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("roleName", Type.STRING);
            q.addScalar("actionId", Type.STRING);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(scope);
            qPos.add(primKey);
            HashMap<String, List<String>> roleMap = new HashMap<String, List<String>>();
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                String roleName = (String)array[0];
                String actionId = (String)array[1];
                ArrayList<String> roleList = (ArrayList<String>)roleMap.get(roleName);
                if (roleList == null) {
                    roleList = new ArrayList<String>();
                }
                roleList.add(actionId);
                roleMap.put(roleName, roleList);
            }
            HashMap<String, List<String>> hashMap = roleMap;
            return hashMap;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByC_N_S_P_A(long companyId, String name, int scope, String primKey, String actionId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N_S_P_A);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(scope);
            qPos.add(primKey);
            ResourceAction resourceAction = ResourceActionLocalServiceUtil.getResourceAction((String)name, (String)actionId);
            qPos.add(resourceAction.getBitwiseValue());
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByKeywords(long companyId, String keywords, Integer[] types, int start, int end, OrderByComparator obc) throws SystemException {
        return this.findByKeywords(companyId, keywords, types, new LinkedHashMap<String, Object>(), start, end, obc);
    }

    public List<Role> findByKeywords(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        String[] names = null;
        String[] descriptions = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
            descriptions = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.findByC_N_D_T(companyId, names, descriptions, types, params, andOperator, start, end, obc);
    }

    protected String getCountByR_U_SQL() {
        if (this._countByR_U == null) {
            StringBundler sb = new StringBundler(13);
            sb.append("(");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_SITE));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_SITE));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USER));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USER_GROUP));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USER_GROUP_SITE));
            sb.append(")");
            this._countByR_U = sb.toString();
        }
        return this._countByR_U;
    }

    protected String getGroupIds(long[] groupIds, String table) {
        if (groupIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(groupIds.length * 3 - 1);
        int i2 = 0;
        while (i2 < groupIds.length) {
            sb.append(table);
            sb.append(".groupId = ?");
            if (i2 + 1 < groupIds.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("usersRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ROLES);
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getTypes(Integer[] types) {
        if (types.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(types.length * 2);
        sb.append(" AND (");
        int i2 = 0;
        while (i2 < types.length) {
            sb.append("Role_.type_ = ?");
            if (i2 + 1 < types.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getWhere(key));
        }
        return sb.toString();
    }

    protected String getWhere(String key) {
        String join = "";
        if (key.equals("usersRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ROLES);
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5, join.length()).concat(" AND ") : "";
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String valueString;
            Object value = entry.getValue();
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull((Long)valueLong)) continue;
                qPos.add(valueLong);
                continue;
            }
            if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
            qPos.add(valueString);
        }
    }
}

