/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.servlet.filters.aggregate.BaseAggregateContext;
import java.io.IOException;

public class FileAggregateContext
extends BaseAggregateContext {
    private static Log _log = LogFactoryUtil.getLog(FileAggregateContext.class);

    public FileAggregateContext(String docrootPath, String resourcePath) {
        int pos = resourcePath.lastIndexOf("/");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos + 1);
        }
        this.pushPath(docrootPath);
        this.pushPath(resourcePath);
    }

    @Override
    public String getContent(String path) {
        try {
            this.pushPath(path);
            String fullPath = this.getFullPath("");
            this.popPath();
            return FileUtil.read((String)fullPath);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            return null;
        }
    }

    @Override
    public String getResourcePath(String path) {
        String docrootPath = this.shiftPath();
        String fullPath = this.getFullPath("");
        this.unshiftPath(docrootPath);
        return fullPath.concat(path);
    }
}

