/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.dao.orm.hibernate.DB2Dialect;
import com.liferay.portal.dao.orm.hibernate.SQLServer2005Dialect;
import com.liferay.portal.dao.orm.hibernate.SQLServer2008Dialect;
import com.liferay.portal.dao.orm.hibernate.SybaseASE157Dialect;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.hibernate.dialect.DB2400Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.resolver.DialectFactory;

public class DialectDetector {
    private static Log _log = LogFactoryUtil.getLog(DialectDetector.class);
    private static Map<String, Dialect> _dialects = new ConcurrentHashMap<String, Dialect>();

    public static Dialect getDialect(DataSource dataSource) {
        int dbMajorVersion;
        String dbName;
        Connection connection;
        Object dialect;
        String dialectKey;
        block13: {
            dialectKey = null;
            dialect = null;
            connection = null;
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dbName = databaseMetaData.getDatabaseProductName();
            dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            dialectKey = dbName.concat(":").concat(String.valueOf(dbMajorVersion));
            dialect = _dialects.get(dialectKey);
            if (dialect == null) break block13;
            DB2400Dialect dB2400Dialect = dialect;
            DataAccess.cleanUp((Connection)connection);
            return dB2400Dialect;
        }
        try {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Determine dialect for " + dbName + " " + dbMajorVersion));
                }
                if (dbName.startsWith("HSQL") && _log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(6);
                    sb.append("Liferay is configured to use Hypersonic as ");
                    sb.append("its database. Do NOT use Hypersonic in ");
                    sb.append("production. Hypersonic is an embedded ");
                    sb.append("database useful for development and demo'ing ");
                    sb.append("purposes. The database settings can be ");
                    sb.append("changed in portal-ext.properties.");
                    _log.warn((Object)sb.toString());
                }
                dialect = dbName.equals("ASE") && dbMajorVersion == 15 ? new SybaseASE157Dialect() : (dbName.startsWith("DB2") && dbMajorVersion >= 9 ? new DB2Dialect() : (dbName.startsWith("Microsoft") && dbMajorVersion == 9 ? new SQLServer2005Dialect() : (dbName.startsWith("Microsoft") && dbMajorVersion == 10 ? new SQLServer2008Dialect() : (dbName.startsWith("Oracle") && dbMajorVersion >= 10 ? new Oracle10gDialect() : DialectFactory.buildDialect((Properties)new Properties(), (Connection)connection)))));
            }
            catch (Exception e2) {
                String msg = GetterUtil.getString((String)e2.getMessage());
                if (msg.contains("explicitly set for database: DB2")) {
                    dialect = new DB2400Dialect();
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"DB2400Dialect was dynamically chosen as the Hibernate dialect for DB2. This can be overriden in portal.properties");
                    }
                } else {
                    _log.error((Object)e2, (Throwable)e2);
                }
                DataAccess.cleanUp((Connection)connection);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)connection);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)connection);
        if (dialect == null) {
            throw new RuntimeException("No dialect found");
        }
        if (dialectKey != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Found dialect " + dialect.getClass().getName()));
            }
            _dialects.put(dialectKey, (Dialect)dialect);
        }
        return dialect;
    }
}

