/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.servicebuilder;

import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.db.IndexMetadataFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ArrayUtil_IW;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.StringUtil_IW;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.Validator_IW;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.model.CacheField;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.servicebuilder.Entity;
import com.liferay.portal.tools.servicebuilder.EntityColumn;
import com.liferay.portal.tools.servicebuilder.EntityFinder;
import com.liferay.portal.tools.servicebuilder.EntityMapping;
import com.liferay.portal.tools.servicebuilder.EntityOrder;
import com.liferay.portal.tools.sourceformatter.JavaSourceProcessor;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.xml.XMLFormatter;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.log.Logger;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;

public class ServiceBuilder {
    public static final String AUTHOR = "Brian Wing Shun Chan";
    private static final int _SESSION_TYPE_LOCAL = 1;
    private static final int _SESSION_TYPE_REMOTE = 0;
    private static final String _SQL_CREATE_TABLE = "create table ";
    private static final String _TPL_ROOT = "com/liferay/portal/tools/servicebuilder/dependencies/";
    private static Pattern _getterPattern = Pattern.compile("public .* get.*" + Pattern.quote("(") + "|public boolean is.*" + Pattern.quote("("));
    private static Pattern _setterPattern = Pattern.compile("public void set.*" + Pattern.quote("("));
    private String _apiDir;
    private String _author;
    private boolean _autoNamespaceTables;
    private Set<String> _badAliasNames;
    private Set<String> _badColumnNames;
    private Set<String> _badTableNames;
    private String _beanLocatorUtil;
    private String _beanLocatorUtilShortName;
    private boolean _build;
    private long _buildNumber;
    private boolean _buildNumberIncrement;
    private List<Entity> _ejbList;
    private Map<String, EntityMapping> _entityMappings;
    private Map<String, Entity> _entityPool = new HashMap<String, Entity>();
    private String _hbmFileName;
    private String _implDir;
    private Map<String, JavaClass> _javaClasses = new HashMap<String, JavaClass>();
    private String _modelHintsFileName;
    private String _ormFileName;
    private String _outputPath;
    private String _packagePath;
    private String _pluginName;
    private String _portletName = "";
    private String _portletPackageName = "";
    private String _portletShortName = "";
    private String _propsUtil;
    private String _remotingFileName;
    private String _serviceOutputPath;
    private String _springBaseFileName;
    private String _springClusterFileName;
    private String _springDynamicDataSourceFileName;
    private String _springFileName;
    private String _springHibernateFileName;
    private String _springInfrastructureFileName;
    private String _springShardDataSourceFileName;
    private String _sqlDir;
    private String _sqlFileName;
    private String _sqlIndexesFileName;
    private String _sqlIndexesPropertiesFileName;
    private String _sqlSequencesFileName;
    private String _targetEntityName;
    private String _testDir;
    private String _testOutputPath;
    private String _tplActionableDynamicQuery = "com/liferay/portal/tools/servicebuilder/dependencies/actionable_dynamic_query.ftl";
    private String _tplBadAliasNames = this._getTplProperty("bad_alias_names", this._tplBadAliasNames);
    private String _tplBadColumnNames = this._getTplProperty("bad_column_names", this._tplBadColumnNames);
    private String _tplBadTableNames = this._getTplProperty("bad_table_names", this._tplBadTableNames);
    private String _tplBlobModel = this._getTplProperty("blob_model", this._tplBlobModel);
    private String _tplEjbPk = this._getTplProperty("ejb_pk", this._tplEjbPk);
    private String _tplException = this._getTplProperty("exception", this._tplException);
    private String _tplExportActionableDynamicQuery = "com/liferay/portal/tools/servicebuilder/dependencies/export_actionable_dynamic_query.ftl";
    private String _tplExtendedModel = this._getTplProperty("extended_model", this._tplExtendedModel);
    private String _tplExtendedModelBaseImpl = this._getTplProperty("extended_model_base_impl", this._tplExtendedModelBaseImpl);
    private String _tplExtendedModelImpl = this._getTplProperty("extended_model_impl", this._tplExtendedModelImpl);
    private String _tplFinder = this._getTplProperty("finder", this._tplFinder);
    private String _tplFinderUtil = this._getTplProperty("finder_util", this._tplFinderUtil);
    private String _tplHbmXml = this._getTplProperty("hbm_xml", this._tplHbmXml);
    private String _tplJsonJs = "com/liferay/portal/tools/servicebuilder/dependencies/json_js.ftl";
    private String _tplJsonJsMethod = "com/liferay/portal/tools/servicebuilder/dependencies/json_js_method.ftl";
    private String _tplModel = "com/liferay/portal/tools/servicebuilder/dependencies/model.ftl";
    private String _tplModelCache = "com/liferay/portal/tools/servicebuilder/dependencies/model_cache.ftl";
    private String _tplModelClp = "com/liferay/portal/tools/servicebuilder/dependencies/model_clp.ftl";
    private String _tplModelHintsXml = "com/liferay/portal/tools/servicebuilder/dependencies/model_hints_xml.ftl";
    private String _tplModelImpl = "com/liferay/portal/tools/servicebuilder/dependencies/model_impl.ftl";
    private String _tplModelSoap = "com/liferay/portal/tools/servicebuilder/dependencies/model_soap.ftl";
    private String _tplModelWrapper = "com/liferay/portal/tools/servicebuilder/dependencies/model_wrapper.ftl";
    private String _tplOrmXml = this._getTplProperty("orm_xml", this._tplOrmXml);
    private String _tplPersistence = "com/liferay/portal/tools/servicebuilder/dependencies/persistence.ftl";
    private String _tplPersistenceImpl = "com/liferay/portal/tools/servicebuilder/dependencies/persistence_impl.ftl";
    private String _tplPersistenceTest = "com/liferay/portal/tools/servicebuilder/dependencies/persistence_test.ftl";
    private String _tplPersistenceUtil = "com/liferay/portal/tools/servicebuilder/dependencies/persistence_util.ftl";
    private String _tplProps = "com/liferay/portal/tools/servicebuilder/dependencies/props.ftl";
    private String _tplRemotingXml = "com/liferay/portal/tools/servicebuilder/dependencies/remoting_xml.ftl";
    private String _tplService = "com/liferay/portal/tools/servicebuilder/dependencies/service.ftl";
    private String _tplServiceBaseImpl = "com/liferay/portal/tools/servicebuilder/dependencies/service_base_impl.ftl";
    private String _tplServiceClp = "com/liferay/portal/tools/servicebuilder/dependencies/service_clp.ftl";
    private String _tplServiceClpInvoker = "com/liferay/portal/tools/servicebuilder/dependencies/service_clp_invoker.ftl";
    private String _tplServiceClpMessageListener = "com/liferay/portal/tools/servicebuilder/dependencies/service_clp_message_listener.ftl";
    private String _tplServiceClpSerializer = "com/liferay/portal/tools/servicebuilder/dependencies/service_clp_serializer.ftl";
    private String _tplServiceHttp = "com/liferay/portal/tools/servicebuilder/dependencies/service_http.ftl";
    private String _tplServiceImpl = "com/liferay/portal/tools/servicebuilder/dependencies/service_impl.ftl";
    private String _tplServiceSoap = "com/liferay/portal/tools/servicebuilder/dependencies/service_soap.ftl";
    private String _tplServiceUtil = "com/liferay/portal/tools/servicebuilder/dependencies/service_util.ftl";
    private String _tplServiceWrapper = "com/liferay/portal/tools/servicebuilder/dependencies/service_wrapper.ftl";
    private String _tplSpringBaseXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_base_xml.ftl";
    private String _tplSpringClusterXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_cluster_xml.ftl";
    private String _tplSpringHibernateXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_hibernate_xml.ftl";
    private String _tplSpringInfrastructureXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_infrastructure_xml.ftl";
    private String _tplSpringShardDataSourceXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_shard_data_source_xml.ftl";
    private String _tplSpringXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_xml.ftl";

    public static String getContent(String fileName) throws Exception {
        Document document = ServiceBuilder._getContentDocument(fileName);
        Element rootElement = document.getRootElement();
        Element authorElement = null;
        Element namespaceElement = null;
        TreeMap<String, Element> entityElements = new TreeMap<String, Element>();
        TreeMap<String, Element> exceptionElements = new TreeMap<String, Element>();
        for (Element element : rootElement.elements()) {
            String elementName = element.getName();
            if (elementName.equals("author")) {
                element.detach();
                if (authorElement != null) {
                    throw new IllegalArgumentException("There can only be one author element");
                }
                authorElement = element;
                continue;
            }
            if (elementName.equals("namespace")) {
                element.detach();
                if (namespaceElement != null) {
                    throw new IllegalArgumentException("There can only be one namespace element");
                }
                namespaceElement = element;
                continue;
            }
            if (elementName.equals("entity")) {
                element.detach();
                String name = element.attributeValue("name");
                entityElements.put(StringUtil.toLowerCase((String)name), element);
                continue;
            }
            if (!elementName.equals("exceptions")) continue;
            element.detach();
            for (Element exceptionElement : element.elements("exception")) {
                exceptionElement.detach();
                exceptionElements.put(exceptionElement.getText(), exceptionElement);
            }
        }
        if (authorElement != null) {
            rootElement.add(authorElement);
        }
        if (namespaceElement == null) {
            throw new IllegalArgumentException("The namespace element is required");
        }
        rootElement.add(namespaceElement);
        ServiceBuilder._addElements(rootElement, entityElements);
        if (!exceptionElements.isEmpty()) {
            Element exceptionsElement = rootElement.addElement("exceptions");
            ServiceBuilder._addElements(exceptionsElement, exceptionElements);
        }
        return document.asXML();
    }

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        InitUtil.initWithSpring(true);
        String fileName = arguments.get("service.input.file");
        String hbmFileName = arguments.get("service.hbm.file");
        String ormFileName = arguments.get("service.orm.file");
        String modelHintsFileName = arguments.get("service.model.hints.file");
        String springFileName = arguments.get("service.spring.file");
        String springBaseFileName = arguments.get("service.spring.base.file");
        String springClusterFileName = arguments.get("service.spring.cluster.file");
        String springDynamicDataSourceFileName = arguments.get("service.spring.dynamic.data.source.file");
        String springHibernateFileName = arguments.get("service.spring.hibernate.file");
        String springInfrastructureFileName = arguments.get("service.spring.infrastructure.file");
        String springShardDataSourceFileName = arguments.get("service.spring.shard.data.source.file");
        String apiDir = arguments.get("service.api.dir");
        String implDir = arguments.get("service.impl.dir");
        String remotingFileName = arguments.get("service.remoting.file");
        String sqlDir = arguments.get("service.sql.dir");
        String sqlFileName = arguments.get("service.sql.file");
        String sqlIndexesFileName = arguments.get("service.sql.indexes.file");
        String sqlIndexesPropertiesFileName = arguments.get("service.sql.indexes.properties.file");
        String sqlSequencesFileName = arguments.get("service.sql.sequences.file");
        boolean autoNamespaceTables = GetterUtil.getBoolean((String)arguments.get("service.auto.namespace.tables"));
        String beanLocatorUtil = arguments.get("service.bean.locator.util");
        String propsUtil = arguments.get("service.props.util");
        String pluginName = arguments.get("service.plugin.name");
        String targetEntityName = arguments.get("service.target.entity.name");
        String testDir = arguments.get("service.test.dir");
        long buildNumber = GetterUtil.getLong((String)arguments.get("service.build.number"), (long)1L);
        boolean buildNumberIncrement = GetterUtil.getBoolean((String)arguments.get("service.build.number.increment"), (boolean)true);
        try {
            new ServiceBuilder(fileName, hbmFileName, ormFileName, modelHintsFileName, springFileName, springBaseFileName, springClusterFileName, springDynamicDataSourceFileName, springHibernateFileName, springInfrastructureFileName, springShardDataSourceFileName, apiDir, implDir, remotingFileName, sqlDir, sqlFileName, sqlIndexesFileName, sqlIndexesPropertiesFileName, sqlSequencesFileName, autoNamespaceTables, beanLocatorUtil, propsUtil, pluginName, targetEntityName, testDir, true, buildNumber, buildNumberIncrement);
        }
        catch (RuntimeException re) {
            System.out.println("Please set these required arguments. Sample values are:\n\n\tservice.input.file=${service.file}\n\tservice.hbm.file=${basedir}/src/META-INF/portal-hbm.xml\n\tservice.orm.file=${basedir}/src/META-INF/portal-orm.xml\n\tservice.model.hints.file=${basedir}/src/META-INF/portal-model-hints.xml\n\tservice.spring.file=${basedir}/src/META-INF/portal-spring.xml\n\tservice.api.dir=${basedir}/../portal-service/src\n\tservice.impl.dir=${basedir}/src\n\tservice.remoting.file=${basedir}/../portal-web/docroot/WEB-INF/remoting-servlet.xml\n\tservice.sql.dir=${basedir}/../sql\n\tservice.sql.file=portal-tables.sql\n\tservice.sql.indexes.file=indexes.sql\n\tservice.sql.indexes.properties.file=indexes.properties\n\tservice.sql.sequences.file=sequences.sql\n\tservice.bean.locator.util=com.liferay.portal.kernel.bean.PortalBeanLocatorUtil\n\tservice.props.util=com.liferay.portal.util.PropsUtil\n\tservice.target.entity.name=${service.target.entity.name}\n\tservice.test.dir=${basedir}/test/integration\n\tservice.build.number=1\n\tservice.build.number.increment=true\n\nYou can also customize the generated code by overriding the default templates with these optional system properties:\n\n\t-Dservice.tpl.bad_alias_names=com/liferay/portal/tools/servicebuilder/dependencies/bad_alias_names.txt\n\t-Dservice.tpl.bad_column_names=com/liferay/portal/tools/servicebuilder/dependencies/bad_column_names.txt\n\t-Dservice.tpl.bad_json_types=com/liferay/portal/tools/servicebuilder/dependencies/bad_json_types.txt\n\t-Dservice.tpl.bad_table_names=com/liferay/portal/tools/servicebuilder/dependencies/bad_table_names.txt\n\t-Dservice.tpl.base_mode_impl=com/liferay/portal/tools/servicebuilder/dependencies/base_mode_impl.ftl\n\t-Dservice.tpl.blob_model=com/liferay/portal/tools/servicebuilder/dependencies/blob_model.ftl\n\t-Dservice.tpl.copyright.txt=copyright.txt\n\t-Dservice.tpl.ejb_pk=com/liferay/portal/tools/servicebuilder/dependencies/ejb_pk.ftl\n\t-Dservice.tpl.exception=com/liferay/portal/tools/servicebuilder/dependencies/exception.ftl\n\t-Dservice.tpl.export_actionable_dynamic_query=com/liferay/portal/tools/servicebuilder/dependencies/export_actionable_dynamic_query.ftl\n\t-Dservice.tpl.extended_model=com/liferay/portal/tools/servicebuilder/dependencies/extended_model.ftl\n\t-Dservice.tpl.extended_model_base_impl=com/liferay/portal/tools/servicebuilder/dependencies/extended_model_base_impl.ftl\n\t-Dservice.tpl.extended_model_impl=com/liferay/portal/tools/servicebuilder/dependencies/extended_model_impl.ftl\n\t-Dservice.tpl.finder=com/liferay/portal/tools/servicebuilder/dependencies/finder.ftl\n\t-Dservice.tpl.finder_util=com/liferay/portal/tools/servicebuilder/dependencies/finder_util.ftl\n\t-Dservice.tpl.hbm_xml=com/liferay/portal/tools/servicebuilder/dependencies/hbm_xml.ftl\n\t-Dservice.tpl.orm_xml=com/liferay/portal/tools/servicebuilder/dependencies/orm_xml.ftl\n\t-Dservice.tpl.json_js=com/liferay/portal/tools/servicebuilder/dependencies/json_js.ftl\n\t-Dservice.tpl.json_js_method=com/liferay/portal/tools/servicebuilder/dependencies/json_js_method.ftl\n\t-Dservice.tpl.model=com/liferay/portal/tools/servicebuilder/dependencies/model.ftl\n\t-Dservice.tpl.model_cache=com/liferay/portal/tools/servicebuilder/dependencies/model_cache.ftl\n\t-Dservice.tpl.model_hints_xml=com/liferay/portal/tools/servicebuilder/dependencies/model_hints_xml.ftl\n\t-Dservice.tpl.model_impl=com/liferay/portal/tools/servicebuilder/dependencies/model_impl.ftl\n\t-Dservice.tpl.model_soap=com/liferay/portal/tools/servicebuilder/dependencies/model_soap.ftl\n\t-Dservice.tpl.model_wrapper=com/liferay/portal/tools/servicebuilder/dependencies/model_wrapper.ftl\n\t-Dservice.tpl.persistence=com/liferay/portal/tools/servicebuilder/dependencies/persistence.ftl\n\t-Dservice.tpl.persistence_impl=com/liferay/portal/tools/servicebuilder/dependencies/persistence_impl.ftl\n\t-Dservice.tpl.persistence_util=com/liferay/portal/tools/servicebuilder/dependencies/persistence_util.ftl\n\t-Dservice.tpl.props=com/liferay/portal/tools/servicebuilder/dependencies/props.ftl\n\t-Dservice.tpl.remoting_xml=com/liferay/portal/tools/servicebuilder/dependencies/remoting_xml.ftl\n\t-Dservice.tpl.service=com/liferay/portal/tools/servicebuilder/dependencies/service.ftl\n\t-Dservice.tpl.service_base_impl=com/liferay/portal/tools/servicebuilder/dependencies/service_base_impl.ftl\n\t-Dservice.tpl.service_clp=com/liferay/portal/tools/servicebuilder/dependencies/service_clp.ftl\n\t-Dservice.tpl.service_clp_invoker=com/liferay/portal/tools/servicebuilder/dependencies/service_clp_invoker.ftl\n\t-Dservice.tpl.service_clp_message_listener=com/liferay/portal/tools/servicebuilder/dependencies/service_clp_message_listener.ftl\n\t-Dservice.tpl.service_clp_serializer=com/liferay/portal/tools/servicebuilder/dependencies/service_clp_serializer.ftl\n\t-Dservice.tpl.service_http=com/liferay/portal/tools/servicebuilder/dependencies/service_http.ftl\n\t-Dservice.tpl.service_impl=com/liferay/portal/tools/servicebuilder/dependencies/service_impl.ftl\n\t-Dservice.tpl.service_soap=com/liferay/portal/tools/servicebuilder/dependencies/service_soap.ftl\n\t-Dservice.tpl.service_util=com/liferay/portal/tools/servicebuilder/dependencies/service_util.ftl\n\t-Dservice.tpl.service_wrapper=com/liferay/portal/tools/servicebuilder/dependencies/service_wrapper.ftl\n\t-Dservice.tpl.spring_base_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_base_xml.ftl\n\t-Dservice.tpl.spring_hibernate_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_hibernate_xml.ftl\n\t-Dservice.tpl.spring_infrastructure_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_infrastructure_xml.ftl\n\t-Dservice.tpl.spring_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_xml.ftl\n\t-Dservice.tpl.spring_xml_session=com/liferay/portal/tools/servicebuilder/dependencies/spring_xml_session.ftl");
            throw re;
        }
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        Introspector.flushCaches();
    }

    public static String toHumanName(String name) {
        if (name == null) {
            return null;
        }
        String humanName = TextFormatter.format((String)name, (int)7);
        if (humanName.equals("id")) {
            humanName = "ID";
        } else if (humanName.equals("ids")) {
            humanName = "IDs";
        }
        if (humanName.endsWith(" id")) {
            humanName = String.valueOf(humanName.substring(0, humanName.length() - 3)) + " ID";
        } else if (humanName.endsWith(" ids")) {
            humanName = String.valueOf(humanName.substring(0, humanName.length() - 4)) + " IDs";
        }
        if (humanName.contains(" id ")) {
            humanName = StringUtil.replace((String)humanName, (String)" id ", (String)" ID ");
        } else if (humanName.contains(" ids ")) {
            humanName = StringUtil.replace((String)humanName, (String)" ids ", (String)" IDs ");
        }
        return humanName;
    }

    public static void writeFile(File file, String content) throws IOException {
        ServiceBuilder.writeFile(file, content, AUTHOR);
    }

    public static void writeFile(File file, String content, String author) throws IOException {
        ServiceBuilder.writeFile(file, content, author, null);
    }

    public static void writeFile(File file, String content, String author, Map<String, Object> jalopySettings) throws IOException {
        String packagePath = ServiceBuilder._getPackagePath(file);
        String className = file.getName();
        className = className.substring(0, className.length() - 5);
        content = JavaSourceProcessor.stripJavaImports(content, packagePath, className);
        File tempFile = new File("ServiceBuilder.temp");
        FileUtil.write((File)tempFile, (String)content);
        StringBuffer sb = new StringBuffer();
        Jalopy jalopy = new Jalopy();
        jalopy.setFileFormat(FileFormat.UNIX);
        jalopy.setInput(tempFile);
        jalopy.setOutput(sb);
        File jalopyXmlFile = new File("tools/jalopy.xml");
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../tools/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("misc/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../misc/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../../misc/jalopy.xml");
        }
        try {
            Jalopy.setConvention((File)jalopyXmlFile);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (jalopySettings == null) {
            jalopySettings = new HashMap<String, Object>();
        }
        Environment env = Environment.getInstance();
        author = GetterUtil.getString((String)((String)jalopySettings.get("author")), (String)author);
        env.set("author", (Object)author);
        env.set("fileName", (Object)file.getName());
        Convention convention = Convention.getInstance();
        String classMask = "/**\n * @author $author$\n*/";
        convention.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, env.interpolate(classMask));
        convention.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, env.interpolate(classMask));
        jalopy.format();
        String newContent = sb.toString();
        newContent = newContent.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        ServiceBuilder.writeFileRaw(file, newContent);
        tempFile.deleteOnExit();
    }

    public static void writeFileRaw(File file, String content) throws IOException {
        if (!file.exists() || !FileUtil.isSameContent((File)file, (String)content)) {
            FileUtil.write((File)file, (String)content);
            System.out.println("Writing " + file);
        }
    }

    public ServiceBuilder(String fileName, String hbmFileName, String ormFileName, String modelHintsFileName, String springFileName, String springBaseFileName, String springClusterFileName, String springDynamicDataSourceFileName, String springHibernateFileName, String springInfrastructureFileName, String springShardDataSourceFileName, String apiDir, String implDir, String remotingFileName, String sqlDir, String sqlFileName, String sqlIndexesFileName, String sqlIndexesPropertiesFileName, String sqlSequencesFileName, boolean autoNamespaceTables, String beanLocatorUtil, String propsUtil, String pluginName, String targetEntityName, String testDir) {
        this(fileName, hbmFileName, ormFileName, modelHintsFileName, springFileName, springBaseFileName, springClusterFileName, springDynamicDataSourceFileName, springHibernateFileName, springInfrastructureFileName, springShardDataSourceFileName, apiDir, implDir, remotingFileName, sqlDir, sqlFileName, sqlIndexesFileName, sqlIndexesPropertiesFileName, sqlSequencesFileName, autoNamespaceTables, beanLocatorUtil, propsUtil, pluginName, targetEntityName, testDir, true, 1L, true);
    }

    public ServiceBuilder(String fileName, String hbmFileName, String ormFileName, String modelHintsFileName, String springFileName, String springBaseFileName, String springClusterFileName, String springDynamicDataSourceFileName, String springHibernateFileName, String springInfrastructureFileName, String springShardDataSourceFileName, String apiDir, String implDir, String remotingFileName, String sqlDir, String sqlFileName, String sqlIndexesFileName, String sqlIndexesPropertiesFileName, String sqlSequencesFileName, boolean autoNamespaceTables, String beanLocatorUtil, String propsUtil, String pluginName, String targetEntityName, String testDir, boolean build, long buildNumber, boolean buildNumberIncrement) {
        this._tplJsonJs = this._getTplProperty("json_js", this._tplJsonJs);
        this._tplJsonJsMethod = this._getTplProperty("json_js_method", this._tplJsonJsMethod);
        this._tplModel = this._getTplProperty("model", this._tplModel);
        this._tplModelCache = this._getTplProperty("model_cache", this._tplModelCache);
        this._tplModelClp = this._getTplProperty("model", this._tplModelClp);
        this._tplModelHintsXml = this._getTplProperty("model_hints_xml", this._tplModelHintsXml);
        this._tplModelImpl = this._getTplProperty("model_impl", this._tplModelImpl);
        this._tplModelSoap = this._getTplProperty("model_soap", this._tplModelSoap);
        this._tplModelWrapper = this._getTplProperty("model_wrapper", this._tplModelWrapper);
        this._tplPersistence = this._getTplProperty("persistence", this._tplPersistence);
        this._tplPersistenceImpl = this._getTplProperty("persistence_impl", this._tplPersistenceImpl);
        this._tplPersistenceUtil = this._getTplProperty("persistence_util", this._tplPersistenceUtil);
        this._tplProps = this._getTplProperty("props", this._tplProps);
        this._tplRemotingXml = this._getTplProperty("remoting_xml", this._tplRemotingXml);
        this._tplService = this._getTplProperty("service", this._tplService);
        this._tplServiceBaseImpl = this._getTplProperty("service_base_impl", this._tplServiceBaseImpl);
        this._tplServiceClp = this._getTplProperty("service_clp", this._tplServiceClp);
        this._tplServiceClpInvoker = this._getTplProperty("service_clp_invoker", this._tplServiceClpInvoker);
        this._tplServiceClpMessageListener = this._getTplProperty("service_clp_message_listener", this._tplServiceClpMessageListener);
        this._tplServiceClpSerializer = this._getTplProperty("service_clp_serializer", this._tplServiceClpSerializer);
        this._tplServiceHttp = this._getTplProperty("service_http", this._tplServiceHttp);
        this._tplServiceImpl = this._getTplProperty("service_impl", this._tplServiceImpl);
        this._tplServiceSoap = this._getTplProperty("service_soap", this._tplServiceSoap);
        this._tplServiceUtil = this._getTplProperty("service_util", this._tplServiceUtil);
        this._tplServiceWrapper = this._getTplProperty("service_wrapper", this._tplServiceWrapper);
        this._tplSpringBaseXml = this._getTplProperty("spring_base_xml", this._tplSpringBaseXml);
        this._tplSpringClusterXml = this._getTplProperty("spring_cluster_xml", this._tplSpringClusterXml);
        this._tplSpringHibernateXml = this._getTplProperty("spring_hibernate_xml", this._tplSpringHibernateXml);
        this._tplSpringInfrastructureXml = this._getTplProperty("spring_infrastructure_xml", this._tplSpringInfrastructureXml);
        this._tplSpringShardDataSourceXml = this._getTplProperty("spring_shard_data_source_xml", this._tplSpringShardDataSourceXml);
        this._tplSpringXml = this._getTplProperty("spring_xml", this._tplSpringXml);
        try {
            this._badTableNames = this._readLines(this._tplBadTableNames);
            this._badAliasNames = this._readLines(this._tplBadAliasNames);
            this._badColumnNames = this._readLines(this._tplBadColumnNames);
            this._hbmFileName = hbmFileName;
            this._ormFileName = ormFileName;
            this._modelHintsFileName = modelHintsFileName;
            this._springFileName = springFileName;
            this._springBaseFileName = springBaseFileName;
            this._springClusterFileName = springClusterFileName;
            this._springDynamicDataSourceFileName = springDynamicDataSourceFileName;
            this._springHibernateFileName = springHibernateFileName;
            this._springInfrastructureFileName = springInfrastructureFileName;
            this._springShardDataSourceFileName = springShardDataSourceFileName;
            this._apiDir = apiDir;
            this._implDir = implDir;
            this._remotingFileName = remotingFileName;
            this._sqlDir = sqlDir;
            this._sqlFileName = sqlFileName;
            this._sqlIndexesFileName = sqlIndexesFileName;
            this._sqlIndexesPropertiesFileName = sqlIndexesPropertiesFileName;
            this._sqlSequencesFileName = sqlSequencesFileName;
            this._autoNamespaceTables = autoNamespaceTables;
            this._beanLocatorUtil = beanLocatorUtil;
            this._beanLocatorUtilShortName = this._beanLocatorUtil.substring(this._beanLocatorUtil.lastIndexOf(".") + 1);
            this._propsUtil = propsUtil;
            this._pluginName = GetterUtil.getString((String)pluginName);
            this._targetEntityName = targetEntityName;
            this._testDir = testDir;
            this._build = build;
            this._buildNumber = buildNumber;
            this._buildNumberIncrement = buildNumberIncrement;
            String content = ServiceBuilder.getContent(fileName);
            Document document = UnsecureSAXReaderUtil.read((String)content, (boolean)true);
            Element rootElement = document.getRootElement();
            String packagePath = rootElement.attributeValue("package-path");
            if (Validator.isNull((String)packagePath)) {
                throw new IllegalArgumentException("The package-path attribute is required");
            }
            this._outputPath = String.valueOf(this._implDir) + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/");
            this._serviceOutputPath = String.valueOf(this._apiDir) + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/");
            if (Validator.isNotNull((String)this._testDir)) {
                this._testOutputPath = String.valueOf(this._testDir) + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/");
            }
            this._packagePath = packagePath;
            this._autoNamespaceTables = GetterUtil.getBoolean((String)rootElement.attributeValue("auto-namespace-tables"), (boolean)this._autoNamespaceTables);
            Element authorElement = rootElement.element("author");
            this._author = authorElement != null ? authorElement.getText() : AUTHOR;
            Element portletElement = rootElement.element("portlet");
            Element namespaceElement = rootElement.element("namespace");
            if (portletElement != null) {
                this._portletName = portletElement.attributeValue("name");
                this._portletShortName = portletElement.attributeValue("short-name");
                this._portletPackageName = TextFormatter.format((String)this._portletName, (int)1);
                this._outputPath = String.valueOf(this._outputPath) + "/" + this._portletPackageName;
                this._serviceOutputPath = String.valueOf(this._serviceOutputPath) + "/" + this._portletPackageName;
                this._testOutputPath = String.valueOf(this._testOutputPath) + "/" + this._portletPackageName;
                this._packagePath = String.valueOf(this._packagePath) + "." + this._portletPackageName;
            } else {
                this._portletShortName = namespaceElement.getText();
            }
            this._portletShortName = this._portletShortName.trim();
            char[] cArray = this._portletShortName.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c2 = cArray[n2];
                if (!Validator.isChar((char)c2) && c2 != '_') {
                    throw new RuntimeException("The namespace element must be a valid keyword");
                }
                ++n2;
            }
            this._ejbList = new ArrayList<Entity>();
            this._entityMappings = new HashMap<String, EntityMapping>();
            List entityElements = rootElement.elements("entity");
            for (Element entityElement : entityElements) {
                this._parseEntity(entityElement);
            }
            ArrayList<String> exceptionList = new ArrayList<String>();
            Element exceptionsElement = rootElement.element("exceptions");
            if (exceptionsElement != null) {
                List exceptionElements = exceptionsElement.elements("exception");
                for (Element exceptionElement : exceptionElements) {
                    exceptionList.add(exceptionElement.getText());
                }
            }
            if (build) {
                int x = 0;
                while (x < this._ejbList.size()) {
                    Entity entity = this._ejbList.get(x);
                    if (this._isTargetEntity(entity)) {
                        System.out.println("Building " + entity.getName());
                        if (entity.hasActionableDynamicQuery()) {
                            this._createActionableDynamicQuery(entity);
                            if (entity.isStagedModel()) {
                                this._createExportActionableDynamicQuery(entity);
                            }
                        }
                        if (entity.hasColumns()) {
                            this._createHbm(entity);
                            this._createHbmUtil(entity);
                            this._createPersistenceImpl(entity);
                            this._createPersistence(entity);
                            this._createPersistenceUtil(entity);
                            if (Validator.isNotNull((String)this._testDir)) {
                                this._createPersistenceTest(entity);
                            }
                            this._createModelImpl(entity);
                            this._createExtendedModelBaseImpl(entity);
                            this._createExtendedModelImpl(entity);
                            entity.setTransients(this._getTransients(entity, false));
                            entity.setParentTransients(this._getTransients(entity, true));
                            this._createModel(entity);
                            this._createExtendedModel(entity);
                            this._createModelCache(entity);
                            this._createModelClp(entity);
                            this._createModelWrapper(entity);
                            this._createModelSoap(entity);
                            this._createBlobModels(entity);
                            this._createPool(entity);
                            if (entity.getPKList().size() > 1) {
                                this._createEJBPK(entity);
                            }
                        }
                        this._createFinder(entity);
                        this._createFinderUtil(entity);
                        if (entity.hasLocalService()) {
                            this._createServiceImpl(entity, 1);
                            this._createServiceBaseImpl(entity, 1);
                            this._createService(entity, 1);
                            this._createServiceFactory(entity, 1);
                            this._createServiceUtil(entity, 1);
                            this._createServiceClp(entity, 1);
                            this._createServiceClpInvoker(entity, 1);
                            this._createServiceWrapper(entity, 1);
                        }
                        if (entity.hasRemoteService()) {
                            this._createServiceImpl(entity, 0);
                            this._createServiceBaseImpl(entity, 0);
                            this._createService(entity, 0);
                            this._createServiceFactory(entity, 0);
                            this._createServiceUtil(entity, 0);
                            this._createServiceClp(entity, 0);
                            this._createServiceClpInvoker(entity, 0);
                            this._createServiceWrapper(entity, 0);
                            if (Validator.isNotNull((String)this._remotingFileName)) {
                                this._createServiceHttp(entity);
                            }
                            this._createServiceJson(entity);
                            if (entity.hasColumns()) {
                                this._createServiceJsonSerializer(entity);
                            }
                            this._createServiceSoap(entity);
                        }
                    } else if (entity.hasColumns()) {
                        entity.setTransients(this._getTransients(entity, false));
                        entity.setParentTransients(this._getTransients(entity, true));
                    }
                    ++x;
                }
                this._createHbmXml();
                this._createOrmXml();
                this._createModelHintsXml();
                this._createSpringXml();
                this._createExceptions(exceptionList);
                this._createServiceClpMessageListener();
                this._createServiceClpSerializer(exceptionList);
                if (Validator.isNotNull((String)this._remotingFileName)) {
                    this._createRemotingXml();
                }
                this._createSQLIndexes();
                this._createSQLTables();
                this._createSQLSequences();
                this._createProps();
                this._createSpringBaseXml();
                this._createSpringClusterXml();
                this._createSpringDynamicDataSourceXml();
                this._createSpringHibernateXml();
                this._createSpringInfrastructureXml();
                this._createSpringShardDataSourceXml();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.getMessage());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public String annotationToString(Annotation annotation) {
        StringBundler sb = new StringBundler();
        sb.append("@");
        Type type = annotation.getType();
        sb.append(type.getValue());
        Map namedParameters = annotation.getNamedParameterMap();
        if (namedParameters.isEmpty()) {
            return sb.toString();
        }
        sb.append("(");
        for (Map.Entry entry : namedParameters.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append("=");
            Object value = entry.getValue();
            if (value instanceof List) {
                List stringValues = (List)entry.getValue();
                sb.append("{");
                for (String stringValue : stringValues) {
                    sb.append(stringValue);
                    sb.append(", ");
                }
                if (!stringValues.isEmpty()) {
                    sb.setIndex(sb.index() - 1);
                }
                sb.append("}");
            } else {
                sb.append(value);
            }
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        return sb.toString();
    }

    public String getClassName(Type type) {
        int dimensions = type.getDimensions();
        String name = type.getValue();
        if (dimensions == 0) {
            return name;
        }
        StringBundler sb = new StringBundler();
        int i2 = 0;
        while (i2 < dimensions) {
            sb.append("[");
            ++i2;
        }
        if (name.equals("boolean")) {
            return sb.append("Z").toString();
        }
        if (name.equals("byte")) {
            return sb.append("B").toString();
        }
        if (name.equals("char")) {
            return sb.append("C").toString();
        }
        if (name.equals("double")) {
            return sb.append("D").toString();
        }
        if (name.equals("float")) {
            return sb.append("F").toString();
        }
        if (name.equals("int")) {
            return sb.append("I").toString();
        }
        if (name.equals("long")) {
            return sb.append("J").toString();
        }
        if (name.equals("short")) {
            return sb.append("S").toString();
        }
        return sb.append("L").append(name).append(";").toString();
    }

    public String getCreateMappingTableSQL(EntityMapping entityMapping) throws IOException {
        String createMappingTableSQL = this._getCreateMappingTableSQL(entityMapping);
        createMappingTableSQL = StringUtil.replace((String)createMappingTableSQL, (String)"\n", (String)"");
        createMappingTableSQL = StringUtil.replace((String)createMappingTableSQL, (String)"\t", (String)"");
        createMappingTableSQL = createMappingTableSQL.substring(0, createMappingTableSQL.length() - 1);
        return createMappingTableSQL;
    }

    public String getCreateTableSQL(Entity entity) {
        String createTableSQL = this._getCreateTableSQL(entity);
        createTableSQL = StringUtil.replace((String)createTableSQL, (String)"\n", (String)"");
        createTableSQL = StringUtil.replace((String)createTableSQL, (String)"\t", (String)"");
        createTableSQL = createTableSQL.substring(0, createTableSQL.length() - 1);
        return createTableSQL;
    }

    public String getDimensions(int dims) {
        String dimensions = "";
        int i2 = 0;
        while (i2 < dims) {
            dimensions = String.valueOf(dimensions) + "[]";
            ++i2;
        }
        return dimensions;
    }

    public String getDimensions(String dims) {
        return this.getDimensions(GetterUtil.getInteger((String)dims));
    }

    public Entity getEntity(String name) throws IOException {
        Entity entity = this._entityPool.get(name);
        if (entity != null) {
            return entity;
        }
        int pos = name.lastIndexOf(".");
        if (pos == -1) {
            pos = this._ejbList.indexOf(new Entity(name));
            if (pos == -1) {
                throw new RuntimeException("Cannot find " + name + " in " + ListUtil.toString(this._ejbList, Entity.NAME_ACCESSOR));
            }
            entity = this._ejbList.get(pos);
            this._entityPool.put(name, entity);
            return entity;
        }
        String refPackage = name.substring(0, pos);
        String refEntity = name.substring(pos + 1);
        if (refPackage.equals(this._packagePath)) {
            pos = this._ejbList.indexOf(new Entity(refEntity));
            if (pos == -1) {
                throw new RuntimeException("Cannot find " + refEntity + " in " + ListUtil.toString(this._ejbList, Entity.NAME_ACCESSOR));
            }
            entity = this._ejbList.get(pos);
            this._entityPool.put(name, entity);
            return entity;
        }
        String refPackageDir = StringUtil.replace((String)refPackage, (String)".", (String)"/");
        String refFileName = String.valueOf(this._implDir) + "/" + refPackageDir + "/service.xml";
        File refFile = new File(refFileName);
        boolean useTempFile = false;
        if (!refFile.exists()) {
            refFileName = Time.getTimestamp();
            refFile = new File(refFileName);
            ClassLoader classLoader = this.getClass().getClassLoader();
            FileUtil.write((String)refFileName, (String)StringUtil.read((ClassLoader)classLoader, (String)(String.valueOf(refPackageDir) + "/service.xml")));
            useTempFile = true;
        }
        ServiceBuilder serviceBuilder = new ServiceBuilder(refFileName, this._hbmFileName, this._ormFileName, this._modelHintsFileName, this._springFileName, this._springBaseFileName, this._springClusterFileName, this._springDynamicDataSourceFileName, this._springHibernateFileName, this._springInfrastructureFileName, this._springShardDataSourceFileName, this._apiDir, this._implDir, this._remotingFileName, this._sqlDir, this._sqlFileName, this._sqlIndexesFileName, this._sqlIndexesPropertiesFileName, this._sqlSequencesFileName, this._autoNamespaceTables, this._beanLocatorUtil, this._propsUtil, this._pluginName, this._targetEntityName, this._testDir, false, this._buildNumber, this._buildNumberIncrement);
        entity = serviceBuilder.getEntity(refEntity);
        entity.setPortalReference(useTempFile);
        this._entityPool.put(name, entity);
        if (useTempFile) {
            refFile.deleteOnExit();
        }
        return entity;
    }

    public Entity getEntityByGenericsName(String genericsName) {
        try {
            String name = genericsName;
            if (name.startsWith("<")) {
                name = name.substring(1, name.length() - 1);
            }
            name = StringUtil.replace((String)name, (String)".model.", (String)".");
            return this.getEntity(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Entity getEntityByParameterTypeValue(String parameterTypeValue) {
        try {
            String name = parameterTypeValue;
            name = StringUtil.replace((String)name, (String)".model.", (String)".");
            return this.getEntity(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public EntityMapping getEntityMapping(String mappingTable) {
        return this._entityMappings.get(mappingTable);
    }

    public String getGeneratorClass(String idType) {
        if (Validator.isNull((String)idType)) {
            idType = "assigned";
        }
        return idType;
    }

    public String getJavadocComment(JavaClass javaClass) {
        return this._formatComment(javaClass.getComment(), javaClass.getTags(), "");
    }

    public String getJavadocComment(JavaMethod javaMethod) {
        return this._formatComment(javaMethod.getComment(), javaMethod.getTags(), "\t");
    }

    public String getListActualTypeArguments(Type type) {
        Type[] types;
        if (type.getValue().equals("java.util.List") && (types = type.getActualTypeArguments()) != null) {
            return this.getTypeGenericsName(types[0]);
        }
        return this.getTypeGenericsName(type);
    }

    public String getLiteralClass(Type type) {
        StringBundler sb = new StringBundler(type.getDimensions() + 2);
        sb.append(type.getValue());
        int i2 = 0;
        while (i2 < type.getDimensions()) {
            sb.append("[]");
            ++i2;
        }
        sb.append(".class");
        return sb.toString();
    }

    public List<EntityColumn> getMappingEntities(String mappingTable) throws IOException {
        ArrayList<EntityColumn> mappingEntitiesPKList = new ArrayList<EntityColumn>();
        EntityMapping entityMapping = this._entityMappings.get(mappingTable);
        int i2 = 0;
        while (i2 < 2) {
            Entity entity = this.getEntity(entityMapping.getEntity(i2));
            if (entity == null) {
                return null;
            }
            mappingEntitiesPKList.addAll(entity.getPKList());
            ++i2;
        }
        return mappingEntitiesPKList;
    }

    public String getNoSuchEntityException(Entity entity) {
        String noSuchEntityException = entity.getName();
        if (Validator.isNull((String)entity.getPortletShortName()) || noSuchEntityException.startsWith(entity.getPortletShortName()) && !noSuchEntityException.equals(entity.getPortletShortName())) {
            noSuchEntityException = noSuchEntityException.substring(entity.getPortletShortName().length());
        }
        noSuchEntityException = "NoSuch" + noSuchEntityException;
        return noSuchEntityException;
    }

    public String getParameterType(JavaParameter parameter) {
        Type returnType = parameter.getType();
        return this.getTypeGenericsName(returnType);
    }

    public String getPrimitiveObj(String type) {
        if (type.equals("boolean")) {
            return "Boolean";
        }
        if (type.equals("double")) {
            return "Double";
        }
        if (type.equals("float")) {
            return "Float";
        }
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("long")) {
            return "Long";
        }
        if (type.equals("short")) {
            return "Short";
        }
        return type;
    }

    public String getPrimitiveObjValue(String colType) {
        if (colType.equals("Boolean")) {
            return ".booleanValue()";
        }
        if (colType.equals("Double")) {
            return ".doubleValue()";
        }
        if (colType.equals("Float")) {
            return ".floatValue()";
        }
        if (colType.equals("Integer")) {
            return ".intValue()";
        }
        if (colType.equals("Long")) {
            return ".longValue()";
        }
        if (colType.equals("Short")) {
            return ".shortValue()";
        }
        return "";
    }

    public String getReturnType(JavaMethod method) {
        Type returnType = method.getReturns();
        return this.getTypeGenericsName(returnType);
    }

    public List<String> getServiceBaseExceptions(List<JavaMethod> methods, String methodName, List<String> args, List<String> exceptions) {
        boolean foundMethod = false;
        for (JavaMethod method : methods) {
            JavaParameter[] parameters = method.getParameters();
            if (method.getName().equals(methodName) && parameters.length == args.size()) {
                int i2 = 0;
                while (i2 < parameters.length) {
                    JavaParameter parameter = parameters[i2];
                    String arg = args.get(i2);
                    if (this.getParameterType(parameter).equals(arg)) {
                        Type[] methodExceptions;
                        exceptions = ListUtil.copy(exceptions);
                        Type[] typeArray = methodExceptions = method.getExceptions();
                        int n = methodExceptions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Type methodException = typeArray[n2];
                            String exception = methodException.getValue();
                            if (exception.equals(PortalException.class.getName())) {
                                exception = "PortalException";
                            }
                            if (exception.equals(SystemException.class.getName())) {
                                exception = "SystemException";
                            }
                            if (!exceptions.contains(exception)) {
                                exceptions.add(exception);
                            }
                            ++n2;
                        }
                        Collections.sort(exceptions);
                        foundMethod = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (foundMethod) break;
        }
        if (!exceptions.isEmpty()) {
            return exceptions;
        }
        return Collections.emptyList();
    }

    public String getSqlType(String type) {
        if (type.equals("boolean") || type.equals("Boolean")) {
            return "BOOLEAN";
        }
        if (type.equals("double") || type.equals("Double")) {
            return "DOUBLE";
        }
        if (type.equals("float") || type.equals("Float")) {
            return "FLOAT";
        }
        if (type.equals("int") || type.equals("Integer")) {
            return "INTEGER";
        }
        if (type.equals("long") || type.equals("Long")) {
            return "BIGINT";
        }
        if (type.equals("short") || type.equals("Short")) {
            return "INTEGER";
        }
        if (type.equals("Date")) {
            return "TIMESTAMP";
        }
        return null;
    }

    public String getSqlType(String model, String field, String type) {
        if (type.equals("boolean") || type.equals("Boolean")) {
            return "BOOLEAN";
        }
        if (type.equals("double") || type.equals("Double")) {
            return "DOUBLE";
        }
        if (type.equals("float") || type.equals("Float")) {
            return "FLOAT";
        }
        if (type.equals("int") || type.equals("Integer")) {
            return "INTEGER";
        }
        if (type.equals("long") || type.equals("Long")) {
            return "BIGINT";
        }
        if (type.equals("short") || type.equals("Short")) {
            return "INTEGER";
        }
        if (type.equals("Blob")) {
            return "BLOB";
        }
        if (type.equals("Date")) {
            return "TIMESTAMP";
        }
        if (type.equals("String")) {
            int maxLength;
            Map hints = ModelHintsUtil.getHints((String)model, (String)field);
            if (hints != null && (maxLength = GetterUtil.getInteger((String)((String)hints.get("max-length")))) == 2000000) {
                return "CLOB";
            }
            return "VARCHAR";
        }
        return null;
    }

    public String getTypeGenericsName(Type type) {
        StringBundler sb = new StringBundler();
        sb.append(type.getValue());
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments != null) {
            sb.append("<");
            int i2 = 0;
            while (i2 < actualTypeArguments.length) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(this.getTypeGenericsName(actualTypeArguments[i2]));
                ++i2;
            }
            sb.append(">");
        }
        sb.append(this.getDimensions(type.getDimensions()));
        return sb.toString();
    }

    public String getVariableName(JavaField field) {
        String fieldName = field.getName();
        if (fieldName.length() > 0 && fieldName.charAt(0) == '_') {
            fieldName = fieldName.substring(1);
        }
        return fieldName;
    }

    public boolean hasEntityByGenericsName(String genericsName) {
        if (Validator.isNull((String)genericsName)) {
            return false;
        }
        if (!genericsName.contains(".model.")) {
            return false;
        }
        return this.getEntityByGenericsName(genericsName) != null;
    }

    public boolean hasEntityByParameterTypeValue(String parameterTypeValue) {
        if (Validator.isNull((String)parameterTypeValue)) {
            return false;
        }
        if (!parameterTypeValue.contains(".model.")) {
            return false;
        }
        return this.getEntityByParameterTypeValue(parameterTypeValue) != null;
    }

    public boolean isBasePersistenceMethod(JavaMethod method) {
        String methodName = method.getName();
        if (methodName.equals("clearCache") || methodName.equals("findWithDynamicQuery")) {
            return true;
        }
        if (methodName.equals("findByPrimaryKey") || methodName.equals("fetchByPrimaryKey") || methodName.equals("remove")) {
            JavaParameter[] parameters = method.getParameters();
            if (parameters.length == 1 && parameters[0].getName().equals("primaryKey")) {
                return true;
            }
            if (methodName.equals("remove")) {
                Type[] methodExceptions;
                Type[] typeArray = methodExceptions = method.getExceptions();
                int n = methodExceptions.length;
                int n2 = 0;
                while (n2 < n) {
                    Type methodException = typeArray[n2];
                    String exception = methodException.getValue();
                    if (exception.contains("NoSuch")) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isCustomMethod(JavaMethod method) {
        String methodName = method.getName();
        if (methodName.equals("afterPropertiesSet") || methodName.equals("destroy") || methodName.equals("equals") || methodName.equals("getClass") || methodName.equals("hashCode") || methodName.equals("notify") || methodName.equals("notifyAll") || methodName.equals("toString") || methodName.equals("wait")) {
            return false;
        }
        if (methodName.equals("getPermissionChecker")) {
            return false;
        }
        if (methodName.equals("getUser") && method.getParameters().length == 0) {
            return false;
        }
        if (methodName.equals("getUserId") && method.getParameters().length == 0) {
            return false;
        }
        if (methodName.endsWith("Finder") && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            return false;
        }
        if (methodName.endsWith("Persistence") && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            return false;
        }
        return !methodName.endsWith("Service") || !methodName.startsWith("get") && !methodName.startsWith("set");
    }

    public boolean isDuplicateMethod(JavaMethod method, Map<String, Object> tempMap) {
        StringBundler sb = new StringBundler();
        sb.append("isDuplicateMethod ");
        sb.append(this.getTypeGenericsName(method.getReturns()));
        sb.append(" ");
        sb.append(method.getName());
        sb.append("(");
        JavaParameter[] parameters = method.getParameters();
        int i2 = 0;
        while (i2 < parameters.length) {
            JavaParameter javaParameter = parameters[i2];
            sb.append(this.getTypeGenericsName(javaParameter.getType()));
            if (i2 + 1 != parameters.length) {
                sb.append(",");
            }
            ++i2;
        }
        sb.append(")");
        String key = sb.toString();
        return tempMap.put(key, key) != null;
    }

    public boolean isHBMCamelCasePropertyAccessor(String propertyName) {
        if (propertyName.length() < 3) {
            return false;
        }
        char[] chars = propertyName.toCharArray();
        char c0 = chars[0];
        char c1 = chars[1];
        char c2 = chars[2];
        return Character.isLowerCase(c0) && Character.isUpperCase(c1) && Character.isLowerCase(c2);
    }

    public boolean isReadOnlyMethod(JavaMethod method, List<String> txRequiredList, String[] prefixes) {
        String methodName = method.getName();
        if (this.isTxRequiredMethod(method, txRequiredList)) {
            return false;
        }
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (methodName.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isServiceReadOnlyMethod(JavaMethod method, List<String> txRequiredList) {
        return this.isReadOnlyMethod(method, txRequiredList, PropsValues.SERVICE_BUILDER_SERVICE_READ_ONLY_PREFIXES);
    }

    public boolean isSoapMethod(JavaMethod method) {
        JavaParameter[] parameters;
        Type returnType = method.getReturns();
        String returnTypeGenericsName = this.getTypeGenericsName(returnType);
        String returnValueName = returnType.getValue();
        if (returnTypeGenericsName.contains("com.liferay.portal.kernel.search.") || returnTypeGenericsName.contains("com.liferay.portal.model.Theme") || returnTypeGenericsName.contains("com.liferay.portlet.social.model.SocialActivityDefinition") || returnTypeGenericsName.equals("java.util.List<java.lang.Object>") || returnValueName.equals("com.liferay.portal.model.Lock") || returnValueName.equals("com.liferay.portlet.messageboards.model.MBMessageDisplay") || returnValueName.startsWith("java.io") || returnValueName.equals("java.util.Map") || returnValueName.equals("java.util.Properties") || returnValueName.startsWith("javax")) {
            return false;
        }
        if (!returnTypeGenericsName.contains("com.liferay.portal.kernel.repository.model.FileEntry") && !returnTypeGenericsName.contains("com.liferay.portal.kernel.repository.model.Folder") && returnTypeGenericsName.contains("com.liferay.portal.kernel.repository.")) {
            return false;
        }
        JavaParameter[] javaParameterArray = parameters = method.getParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            JavaParameter javaParameter = javaParameterArray[n2];
            Type type = javaParameter.getType();
            String parameterTypeName = String.valueOf(type.getValue()) + this._getDimensions(type);
            if (parameterTypeName.equals("com.liferay.portal.kernel.util.UnicodeProperties") || parameterTypeName.equals("com.liferay.portal.theme.ThemeDisplay") || parameterTypeName.equals("com.liferay.portlet.PortletPreferencesImpl") || parameterTypeName.equals("com.liferay.portlet.dynamicdatamapping.storage.Fields") || parameterTypeName.startsWith("java.io") || parameterTypeName.startsWith("java.util.LinkedHashMap") || parameterTypeName.startsWith("java.util.Map") && !this._isStringLocaleMap(javaParameter) || parameterTypeName.startsWith("java.util.Properties") || parameterTypeName.startsWith("javax")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isTxRequiredMethod(JavaMethod method, List<String> txRequiredList) {
        if (txRequiredList == null) {
            return false;
        }
        return txRequiredList.contains(method.getName());
    }

    private static void _addElements(Element element, Map<String, Element> elements) {
        for (Map.Entry<String, Element> entry : elements.entrySet()) {
            Element childElement = entry.getValue();
            element.add(childElement);
        }
    }

    private static Document _getContentDocument(String fileName) throws Exception {
        String content = FileUtil.read((File)new File(fileName));
        Document document = UnsecureSAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        for (Element element : rootElement.elements()) {
            String elementName = element.getName();
            if (!elementName.equals("service-builder-import")) continue;
            element.detach();
            String dirName = fileName.substring(0, fileName.lastIndexOf("/") + 1);
            String serviceBuilderImportFileName = element.attributeValue("file");
            Document serviceBuilderImportDocument = ServiceBuilder._getContentDocument(String.valueOf(dirName) + serviceBuilderImportFileName);
            Element serviceBuilderImportRootElement = serviceBuilderImportDocument.getRootElement();
            for (Element serviceBuilderImportElement : serviceBuilderImportRootElement.elements()) {
                serviceBuilderImportElement.detach();
                rootElement.add(serviceBuilderImportElement);
            }
        }
        return document;
    }

    private static String _getPackagePath(File file) {
        String fileName = StringUtil.replace((String)file.toString(), (String)"\\", (String)"/");
        int x = fileName.indexOf("src/");
        if (x == -1) {
            x = fileName.indexOf("test/");
        }
        int y = fileName.lastIndexOf("/");
        fileName = fileName.substring(x + 4, y);
        return StringUtil.replace((String)fileName, (String)"/", (String)".");
    }

    private void _createActionableDynamicQuery(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplActionableDynamicQuery, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/persistence/" + entity.getName() + "ActionableDynamicQuery.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createBlobModels(Entity entity) throws Exception {
        ArrayList<EntityColumn> blobList = new ArrayList<EntityColumn>(entity.getBlobList());
        Iterator itr = blobList.iterator();
        while (itr.hasNext()) {
            EntityColumn col = (EntityColumn)itr.next();
            if (col.isLazy()) continue;
            itr.remove();
        }
        if (blobList.isEmpty()) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        for (EntityColumn col : blobList) {
            context.put("column", col);
            String content = this._processTemplate(this._tplBlobModel, context);
            File blobModelFile = new File(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + col.getMethodName() + "BlobModel.java");
            ServiceBuilder.writeFile(blobModelFile, content, this._author);
        }
    }

    private void _createEJBPK(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplEjbPk, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/persistence/" + entity.getPKClassName() + ".java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createExceptions(List<String> exceptions) throws Exception {
        int i2 = 0;
        while (i2 < this._ejbList.size()) {
            Entity entity = this._ejbList.get(i2);
            if (this._isTargetEntity(entity) && entity.hasColumns()) {
                exceptions.add(this.getNoSuchEntityException(entity));
            }
            ++i2;
        }
        for (String exception : exceptions) {
            String content;
            File exceptionFile = new File(String.valueOf(this._serviceOutputPath) + "/" + exception + "Exception.java");
            if (!exceptionFile.exists()) {
                Map<String, Object> context = this._getContext();
                context.put("exception", exception);
                String content2 = this._processTemplate(this._tplException, context);
                if (exception.startsWith("NoSuch")) {
                    content2 = StringUtil.replace((String)content2, (String)"PortalException", (String)"NoSuchModelException");
                    content2 = StringUtil.replace((String)content2, (String)"kernel.exception.NoSuchModelException", (String)"NoSuchModelException");
                }
                content2 = StringUtil.replace((String)content2, (String)"\r\n", (String)"\n");
                FileUtil.write((File)exceptionFile, (String)content2);
            }
            if (exception.startsWith("NoSuch") && !(content = FileUtil.read((File)exceptionFile)).contains("NoSuchModelException")) {
                content = StringUtil.replace((String)content, (String)"PortalException", (String)"NoSuchModelException");
                content = StringUtil.replace((String)content, (String)"kernel.exception.NoSuchModelException", (String)"NoSuchModelException");
                FileUtil.write((File)exceptionFile, (String)content);
            }
            if (this._serviceOutputPath.equals(this._outputPath) || !(exceptionFile = new File(String.valueOf(this._outputPath) + "/" + exception + "Exception.java")).exists()) continue;
            System.out.println("Relocating " + exceptionFile);
            exceptionFile.delete();
        }
    }

    private void _createExportActionableDynamicQuery(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplExportActionableDynamicQuery, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/persistence/" + entity.getName() + "ExportActionableDynamicQuery.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createExtendedModel(Entity entity) throws Exception {
        JavaClass modelImplJavaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "Impl.java");
        List methods = ListUtil.fromArray((Object[])this._getMethods(modelImplJavaClass));
        Iterator itr = methods.iterator();
        while (itr.hasNext()) {
            JavaMethod method = (JavaMethod)itr.next();
            String methodName = method.getName();
            if (!methodName.equals("getStagedModelType")) continue;
            itr.remove();
        }
        JavaClass modelJavaClass = this._getJavaClass(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + "Model.java");
        JavaMethod[] javaMethodArray = this._getMethods(modelJavaClass);
        int n = javaMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod method = javaMethodArray[n2];
            methods.remove(method);
            ++n2;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods.toArray(new Object[methods.size()]));
        String content = this._processTemplate(this._tplExtendedModel, context);
        File modelFile = new File(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + ".java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (modelFile = new File(String.valueOf(this._outputPath) + "/model/" + entity.getName() + ".java")).exists()) {
            System.out.println("Relocating " + modelFile);
            modelFile.delete();
        }
    }

    private void _createExtendedModelBaseImpl(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplExtendedModelBaseImpl, context);
        File modelFile = new File(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "BaseImpl.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createExtendedModelImpl(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplExtendedModelImpl, context);
        File modelFile = new File(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "Impl.java");
        if (modelFile.exists()) {
            content = FileUtil.read((File)modelFile);
            content = content.replaceAll("extends\\s+" + entity.getName() + "ModelImpl\\s+implements\\s+" + entity.getName(), "extends " + entity.getName() + "BaseImpl");
            ServiceBuilder.writeFileRaw(modelFile, content);
        } else {
            ServiceBuilder.writeFile(modelFile, content, this._author);
        }
    }

    private void _createFinder(Entity entity) throws Exception {
        if (!entity.hasFinderClass()) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "FinderImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplFinder, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/persistence/" + entity.getName() + "Finder.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "Finder.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createFinderUtil(Entity entity) throws Exception {
        if (!entity.hasFinderClass()) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "FinderImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplFinderUtil, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/persistence/" + entity.getName() + "FinderUtil.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "FinderUtil.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createHbm(Entity entity) {
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "HBM.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createHbmUtil(Entity entity) {
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "HBMUtil.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createHbmXml() throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplHbmXml, context);
        int lastImportStart = content.lastIndexOf("<import class=");
        int lastImportEnd = content.indexOf("/>", lastImportStart) + 3;
        String imports = content.substring(0, lastImportEnd);
        content = content.substring(lastImportEnd + 1);
        File xmlFile = new File(this._hbmFileName);
        if (!xmlFile.exists()) {
            String xml = "<?xml version=\"1.0\"?>\n<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\" \"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">\n\n<hibernate-mapping default-lazy=\"false\" auto-import=\"false\">\n</hibernate-mapping>";
            FileUtil.write((File)xmlFile, (String)xml);
        }
        String oldContent = FileUtil.read((File)xmlFile);
        String newContent = this._fixHbmXml(oldContent);
        int firstImport = newContent.indexOf("<import class=\"" + this._packagePath + ".model.");
        int lastImport = newContent.lastIndexOf("<import class=\"" + this._packagePath + ".model.");
        if (firstImport == -1) {
            int x = newContent.indexOf("<class");
            if (x != -1) {
                newContent = String.valueOf(newContent.substring(0, x)) + imports + newContent.substring(x);
            } else {
                content = String.valueOf(imports) + content;
            }
        } else {
            firstImport = newContent.indexOf("<import", firstImport) - 1;
            lastImport = newContent.indexOf("/>", lastImport) + 3;
            newContent = String.valueOf(newContent.substring(0, firstImport)) + imports + newContent.substring(lastImport);
        }
        int firstClass = newContent.indexOf("<class name=\"" + this._packagePath + ".model.");
        int lastClass = newContent.lastIndexOf("<class name=\"" + this._packagePath + ".model.");
        if (firstClass == -1) {
            int x = newContent.indexOf("</hibernate-mapping>");
            if (x != -1) {
                newContent = String.valueOf(newContent.substring(0, x)) + content + newContent.substring(x);
            }
        } else {
            firstClass = newContent.lastIndexOf("<class", firstClass) - 1;
            lastClass = newContent.indexOf("</class>", lastClass) + 9;
            newContent = String.valueOf(newContent.substring(0, firstClass)) + content + newContent.substring(lastClass);
        }
        if (!oldContent.equals(newContent = this._formatXml(newContent))) {
            FileUtil.write((File)xmlFile, (String)newContent);
        }
    }

    private void _createModel(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplModel, context);
        File modelFile = new File(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + "Model.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (modelFile = new File(String.valueOf(this._outputPath) + "/model/" + entity.getName() + "Model.java")).exists()) {
            System.out.println("Relocating " + modelFile);
            modelFile.delete();
        }
    }

    private void _createModelCache(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "Impl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("cacheFields", this._getCacheFields(javaClass));
        String content = this._processTemplate(this._tplModelCache, context);
        File modelFile = new File(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "CacheModel.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createModelClp(Entity entity) throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "Impl.java");
        HashMap<String, JavaMethod> methods = new HashMap<String, JavaMethod>();
        JavaMethod[] javaMethodArray = javaClass.getMethods();
        int n = javaMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod method = javaMethodArray[n2];
            methods.put(method.getDeclarationSignature(false), method);
            ++n2;
        }
        Type superClass = javaClass.getSuperClass();
        String superClassValue = superClass.getValue();
        while (!superClassValue.endsWith("BaseModelImpl")) {
            int pos = superClassValue.lastIndexOf(".");
            if (pos > 0) {
                superClassValue = superClassValue.substring(pos + 1);
            }
            javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/model/impl/" + superClassValue + ".java");
            JavaMethod[] javaMethodArray2 = this._getMethods(javaClass);
            int n3 = javaMethodArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                JavaMethod method = javaMethodArray2[n4];
                methods.remove(method.getDeclarationSignature(false));
                ++n4;
            }
            superClass = javaClass.getSuperClass();
            superClassValue = superClass.getValue();
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods.values());
        String content = this._processTemplate(this._tplModelClp, context);
        File modelFile = new File(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + "Clp.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createModelHintsXml() throws Exception {
        String oldContent;
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplModelHintsXml, context);
        File xmlFile = new File(this._modelHintsFileName);
        if (!xmlFile.exists()) {
            String xml = "<?xml version=\"1.0\"?>\n\n<model-hints>\n</model-hints>";
            FileUtil.write((File)xmlFile, (String)xml);
        }
        String newContent = oldContent = FileUtil.read((File)xmlFile);
        int firstModel = newContent.indexOf("<model name=\"" + this._packagePath + ".model.");
        int lastModel = newContent.lastIndexOf("<model name=\"" + this._packagePath + ".model.");
        if (firstModel == -1) {
            int x = newContent.indexOf("</model-hints>");
            newContent = String.valueOf(newContent.substring(0, x)) + content + newContent.substring(x);
        } else {
            firstModel = newContent.lastIndexOf("<model", firstModel) - 1;
            lastModel = newContent.indexOf("</model>", lastModel) + 9;
            newContent = String.valueOf(newContent.substring(0, firstModel)) + content + newContent.substring(lastModel);
        }
        newContent = this._formatXml(newContent);
        if (!oldContent.equals(newContent)) {
            FileUtil.write((File)xmlFile, (String)newContent);
        }
    }

    private void _createModelImpl(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "Impl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("cacheFields", this._getCacheFields(javaClass));
        String content = this._processTemplate(this._tplModelImpl, context);
        File modelFile = new File(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "ModelImpl.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createModelSoap(Entity entity) throws Exception {
        File modelFile = null;
        if (!this._serviceOutputPath.equals(this._outputPath) && (modelFile = new File(String.valueOf(this._outputPath) + "/model/" + entity.getName() + "Soap.java")).exists()) {
            System.out.println("Relocating " + modelFile);
            modelFile.delete();
        }
        modelFile = new File(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + "Soap.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplModelSoap, context);
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createModelWrapper(Entity entity) throws Exception {
        JavaClass modelJavaClass = this._getJavaClass(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + "Model.java");
        Object[] methods = this._getMethods(modelJavaClass);
        JavaClass extendedModelBaseImplJavaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "BaseImpl.java");
        methods = ArrayUtil.append((Object[])methods, (Object[])this._getMethods(extendedModelBaseImplJavaClass));
        JavaClass extendedModelJavaClass = this._getJavaClass(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + ".java");
        methods = ArrayUtil.append((Object[])methods, (Object[])this._getMethods(extendedModelJavaClass));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods);
        String content = this._processTemplate(this._tplModelWrapper, context);
        File modelFile = new File(String.valueOf(this._serviceOutputPath) + "/model/" + entity.getName() + "Wrapper.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createOrmXml() throws Exception {
        String oldContent;
        File xmlFile;
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplOrmXml, context);
        String mappedClasses = "";
        int lastMappedClassStart = content.lastIndexOf("<mapped-superclass");
        if (lastMappedClassStart != -1) {
            int lastMappedClassEnd = content.indexOf("</mapped-superclass>", lastMappedClassStart) + 20;
            mappedClasses = content.substring(0, lastMappedClassEnd);
            content = content.substring(lastMappedClassEnd + 1);
        }
        if (!(xmlFile = new File(this._ormFileName)).exists()) {
            String xml = "<?xml version=\"1.0\"?>\n<entity-mappings version=\"1.0\" xmlns=\"http://java.sun.com/xml/ns/persistence/orm\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence/orm http://java.sun.com/xml/ns/persistence/orm_1_0.xsd\"\n>\n<persistence-unit-metadata>\n\t<xml-mapping-metadata-complete />\n\t<persistence-unit-defaults>\n\t\t<access>PROPERTY</access>\n\t</persistence-unit-defaults>\n</persistence-unit-metadata>\n</entity-mappings>";
            FileUtil.write((File)xmlFile, (String)xml);
        }
        String newContent = oldContent = FileUtil.read((File)xmlFile);
        int firstMappedClass = newContent.indexOf("<mapped-superclass class=\"" + this._packagePath + ".model.");
        int lastMappedClass = newContent.lastIndexOf("<mapped-superclass class=\"" + this._packagePath + ".model.");
        if (firstMappedClass == -1) {
            int x = newContent.indexOf("<entity class=");
            if (x != -1) {
                newContent = String.valueOf(newContent.substring(0, x)) + mappedClasses + newContent.substring(x);
            } else {
                content = String.valueOf(mappedClasses) + content;
            }
        } else {
            firstMappedClass = newContent.indexOf("<mapped-superclass", firstMappedClass) - 1;
            lastMappedClass = newContent.indexOf("</mapped-superclass>", lastMappedClass) + 20;
            newContent = String.valueOf(newContent.substring(0, firstMappedClass)) + mappedClasses + newContent.substring(lastMappedClass);
        }
        int firstEntity = newContent.indexOf("<entity class=\"" + this._packagePath + ".model.impl.");
        int lastEntity = newContent.lastIndexOf("<entity class=\"" + this._packagePath + ".model.impl.");
        if (firstEntity == -1) {
            int x = newContent.indexOf("</entity-mappings>");
            if (x != -1) {
                newContent = String.valueOf(newContent.substring(0, x)) + content + newContent.substring(x);
            }
        } else {
            firstEntity = newContent.lastIndexOf("<entity", firstEntity) - 1;
            lastEntity = newContent.indexOf("</entity>", lastEntity) + 9;
            newContent = String.valueOf(newContent.substring(0, firstEntity)) + content + newContent.substring(lastEntity);
        }
        newContent = this._formatXml(newContent);
        if (!oldContent.equals(newContent = StringUtil.replace((String)newContent, (String[])new String[]{"<attributes></attributes>", "<attributes/>"}, (String[])new String[]{"<attributes />", "<attributes />"}))) {
            FileUtil.write((File)xmlFile, (String)newContent);
        }
    }

    private void _createPersistence(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "PersistenceImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplPersistence, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/persistence/" + entity.getName() + "Persistence.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "Persistence.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createPersistenceImpl(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("referenceList", this._mergeReferenceList(entity.getReferenceList()));
        Logger.selectLoggerLibrary((int)0);
        String content = this._processTemplate(this._tplPersistenceImpl, context);
        Logger.selectLoggerLibrary((int)-1);
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "PersistenceImpl.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createPersistenceTest(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplPersistenceTest, context);
        File ejbFile = new File(String.valueOf(this._testOutputPath) + "/service/persistence/" + entity.getName() + "PersistenceTest.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createPersistenceUtil(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "PersistenceImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplPersistenceUtil, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/persistence/" + entity.getName() + "Util.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "Util.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createPool(Entity entity) {
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/persistence/" + entity.getName() + "Pool.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createProps() throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        File propsFile = new File(String.valueOf(this._implDir) + "/service.properties");
        long buildNumber = 1L;
        long buildDate = System.currentTimeMillis();
        if (propsFile.exists()) {
            Properties properties = PropertiesUtil.load((String)FileUtil.read((File)propsFile));
            if (!this._buildNumberIncrement) {
                buildDate = GetterUtil.getLong((String)properties.getProperty("build.date"));
                buildNumber = GetterUtil.getLong((String)properties.getProperty("build.number"));
            } else {
                buildNumber = GetterUtil.getLong((String)properties.getProperty("build.number")) + 1L;
            }
        }
        if (!this._buildNumberIncrement && buildNumber < this._buildNumber) {
            buildNumber = this._buildNumber;
            buildDate = System.currentTimeMillis();
        }
        Map<String, Object> context = this._getContext();
        context.put("buildNumber", buildNumber);
        context.put("currentTimeMillis", buildDate);
        String content = this._processTemplate(this._tplProps, context);
        FileUtil.write((File)propsFile, (String)content, (boolean)true);
    }

    private void _createRemotingXml() throws Exception {
        String content;
        StringBundler sb = new StringBundler();
        Document document = UnsecureSAXReaderUtil.read((File)new File(this._springFileName));
        Element rootElement = document.getRootElement();
        List beanElements = rootElement.elements("bean");
        for (Element beanElement : beanElements) {
            String serviceName;
            String beanId = beanElement.attributeValue("id");
            if (!beanId.endsWith("Service") || beanId.endsWith("LocalService")) continue;
            String entityName = beanId;
            entityName = StringUtil.replaceLast((String)entityName, (String)".service.", (String)".");
            int pos = entityName.lastIndexOf("Service");
            entityName = entityName.substring(0, pos);
            Entity entity = this.getEntity(entityName);
            String serviceMapping = serviceName = beanId;
            serviceMapping = StringUtil.replaceLast((String)serviceMapping, (String)".service.", (String)".service.spring.");
            serviceMapping = StringUtil.replace((String)serviceMapping, (String)".", (String)"_");
            Map<String, Object> context = this._getContext();
            context.put("entity", entity);
            context.put("serviceName", serviceName);
            context.put("serviceMapping", serviceMapping);
            sb.append(this._processTemplate(this._tplRemotingXml, context));
        }
        File outputFile = new File(this._remotingFileName);
        if (!outputFile.exists()) {
            return;
        }
        String newContent = content = FileUtil.read((File)outputFile);
        int x = content.indexOf("<bean ");
        int y = content.lastIndexOf("</bean>") + 8;
        if (x != -1) {
            newContent = String.valueOf(content.substring(0, x - 1)) + sb.toString() + content.substring(y);
        } else {
            x = content.indexOf("</beans>");
            if (x != -1) {
                newContent = String.valueOf(content.substring(0, x)) + sb.toString() + content.substring(x);
            } else {
                x = content.indexOf("<beans/>");
                y = x + 8;
                newContent = String.valueOf(content.substring(0, x)) + "<beans>" + sb.toString() + "</beans>" + content.substring(y);
            }
        }
        newContent = this._formatXml(newContent);
        if (!content.equals(newContent)) {
            FileUtil.write((File)outputFile, (String)newContent);
            System.out.println(outputFile.toString());
        }
    }

    private void _createService(Entity entity, int sessionType) throws Exception {
        HashSet<String> imports = new HashSet<String>();
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/impl/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceImpl.java");
        JavaSource javaSource = javaClass.getSource();
        imports.addAll(Arrays.asList(javaSource.getImports()));
        Object[] methods = this._getMethods(javaClass);
        Type superClass = javaClass.getSuperClass();
        String superClassValue = superClass.getValue();
        if (superClassValue.endsWith(String.valueOf(entity.getName()) + this._getSessionTypeName(sessionType) + "ServiceBaseImpl")) {
            JavaClass parentJavaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/base/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceBaseImpl.java");
            JavaSource parentJavaSource = parentJavaClass.getSource();
            imports.addAll(Arrays.asList(parentJavaSource.getImports()));
            methods = (JavaMethod[])ArrayUtil.append((Object[])parentJavaClass.getMethods(), (Object[])methods);
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("imports", imports);
        context.put("methods", methods);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplService, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(String.valueOf(this._outputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceBaseImpl(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/impl/" + entity.getName() + (sessionType != 0 ? "Local" : "") + "ServiceImpl.java");
        JavaMethod[] methods = this._getMethods(javaClass);
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context.put("referenceList", this._mergeReferenceList(entity.getReferenceList()));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceBaseImpl, context);
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/base/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceBaseImpl.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceClp(Entity entity, int sessionType) throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._serviceOutputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceClp, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceClp.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceClpInvoker(Entity entity, int sessionType) throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/impl/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceImpl.java");
        Object[] methods = this._getMethods(javaClass);
        Type superClass = javaClass.getSuperClass();
        String superClassValue = superClass.getValue();
        if (superClassValue.endsWith(String.valueOf(entity.getName()) + this._getSessionTypeName(sessionType) + "ServiceBaseImpl")) {
            JavaClass parentJavaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/base/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceBaseImpl.java");
            methods = (JavaMethod[])ArrayUtil.append((Object[])parentJavaClass.getMethods(), (Object[])methods);
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceClpInvoker, context);
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/base/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceClpInvoker.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceClpMessageListener() throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplServiceClpMessageListener, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/messaging/ClpMessageListener.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceClpSerializer(List<String> exceptions) throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        context.put("exceptions", exceptions);
        String content = this._processTemplate(this._tplServiceClpSerializer, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/ClpSerializer.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceFactory(Entity entity, int sessionType) {
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceFactory.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
        if ((ejbFile = new File(String.valueOf(this._outputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceFactory.java")).exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceHttp(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/impl/" + entity.getName() + "ServiceImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("hasHttpMethods", new Boolean(this._hasHttpMethods(javaClass)));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceHttp, context);
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/http/" + entity.getName() + "ServiceHttp.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceImpl(Entity entity, int sessionType) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        String content = this._processTemplate(this._tplServiceImpl, context);
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/impl/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceImpl.java");
        if (!ejbFile.exists()) {
            ServiceBuilder.writeFile(ejbFile, content, this._author);
        }
    }

    private void _createServiceJson(Entity entity) {
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/http/" + entity.getName() + "ServiceJSON.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceJsonSerializer(Entity entity) {
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/http/" + entity.getName() + "JSONSerializer.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(String.valueOf(this._outputPath) + "/service/http/" + entity.getName() + "JSONSerializer.java")).exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceSoap(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._outputPath) + "/service/impl/" + entity.getName() + "ServiceImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceSoap, context);
        File ejbFile = new File(String.valueOf(this._outputPath) + "/service/http/" + entity.getName() + "ServiceSoap.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceUtil(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._serviceOutputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceUtil, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceUtil.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(String.valueOf(this._outputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceUtil.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceWrapper(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(String.valueOf(this._serviceOutputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceWrapper, context);
        File ejbFile = new File(String.valueOf(this._serviceOutputPath) + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceWrapper.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createSpringBaseXml() throws Exception {
        if (Validator.isNull((String)this._springBaseFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringBaseXml);
        File ejbFile = new File(this._springBaseFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
        if (Validator.isNotNull((String)this._pluginName)) {
            FileUtil.delete((String)"docroot/WEB-INF/src/META-INF/data-source-spring.xml");
            FileUtil.delete((String)"docroot/WEB-INF/src/META-INF/misc-spring.xml");
        }
    }

    private void _createSpringClusterXml() throws Exception {
        if (Validator.isNull((String)this._springClusterFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringClusterXml);
        File ejbFile = new File(this._springClusterFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
    }

    private void _createSpringDynamicDataSourceXml() throws Exception {
        if (Validator.isNull((String)this._springDynamicDataSourceFileName)) {
            return;
        }
        File ejbFile = new File(this._springDynamicDataSourceFileName);
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createSpringHibernateXml() throws Exception {
        if (Validator.isNull((String)this._springHibernateFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringHibernateXml);
        File ejbFile = new File(this._springHibernateFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
    }

    private void _createSpringInfrastructureXml() throws Exception {
        if (Validator.isNull((String)this._springInfrastructureFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringInfrastructureXml);
        File ejbFile = new File(this._springInfrastructureFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
    }

    private void _createSpringShardDataSourceXml() throws Exception {
        if (Validator.isNull((String)this._springShardDataSourceFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringShardDataSourceXml);
        File ejbFile = new File(this._springShardDataSourceFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
    }

    private void _createSpringXml() throws Exception {
        if (this._packagePath.equals("com.liferay.counter")) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplSpringXml, context);
        File xmlFile = new File(this._springFileName);
        String xml = "<?xml version=\"1.0\"?>\n\n<beans\n\tdefault-destroy-method=\"destroy\"\n\tdefault-init-method=\"afterPropertiesSet\"\n\txmlns=\"http://www.springframework.org/schema/beans\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\"\n>\n</beans>";
        if (!xmlFile.exists()) {
            FileUtil.write((File)xmlFile, (String)xml);
        }
        String oldContent = FileUtil.read((File)xmlFile);
        if (Validator.isNotNull((String)this._pluginName) && oldContent.contains("DOCTYPE beans PUBLIC")) {
            oldContent = xml;
        }
        String newContent = this._fixSpringXml(oldContent);
        int x = oldContent.indexOf("<beans");
        int y = oldContent.lastIndexOf("</beans>");
        int firstSession = newContent.indexOf("<bean id=\"" + this._packagePath + ".service.", x);
        int lastSession = newContent.lastIndexOf("<bean id=\"" + this._packagePath + ".service.", y);
        if (firstSession == -1 || firstSession > y) {
            x = newContent.indexOf("</beans>");
            newContent = String.valueOf(newContent.substring(0, x)) + content + newContent.substring(x);
        } else {
            firstSession = newContent.lastIndexOf("<bean", firstSession) - 1;
            int tempLastSession = newContent.indexOf("<bean id=\"", lastSession + 1);
            if (tempLastSession == -1) {
                tempLastSession = newContent.indexOf("</beans>", lastSession);
            }
            lastSession = tempLastSession;
            newContent = String.valueOf(newContent.substring(0, firstSession)) + content + newContent.substring(lastSession);
        }
        newContent = this._formatXml(newContent);
        if (!oldContent.equals(newContent)) {
            FileUtil.write((File)xmlFile, (String)newContent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void _createSQLIndexes() throws IOException {
        void var6_11;
        String string;
        String indexSQL;
        if (!FileUtil.exists((String)this._sqlDir)) {
            return;
        }
        File sqlFile = new File(String.valueOf(this._sqlDir) + "/" + this._sqlIndexesFileName);
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        TreeMap<String, String> indexSQLs = new TreeMap<String, String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(sqlFile));
        while ((indexSQL = unsyncBufferedReader.readLine()) != null) {
            if (!Validator.isNotNull((String)indexSQL.trim())) continue;
            int pos = indexSQL.indexOf(" on ");
            String string2 = indexSQL.substring(pos + 4);
            indexSQLs.put(string2, indexSQL);
        }
        unsyncBufferedReader.close();
        File propsFile = new File(String.valueOf(this._sqlDir) + "/" + this._sqlIndexesPropertiesFileName);
        if (!propsFile.exists()) {
            FileUtil.write((File)propsFile, (String)"");
        }
        TreeMap<String, String> indexProps = new TreeMap<String, String>();
        unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(propsFile));
        while ((string = unsyncBufferedReader.readLine()) != null) {
            if (!Validator.isNotNull((String)string.trim())) continue;
            String[] splitIndexMapping = string.split("\\=");
            indexProps.put(splitIndexMapping[1], splitIndexMapping[0]);
        }
        unsyncBufferedReader.close();
        boolean bl = false;
        while (var6_11 < this._ejbList.size()) {
            Entity entity = this._ejbList.get((int)var6_11);
            if (this._isTargetEntity(entity) && entity.isDefaultDataSource()) {
                List<EntityFinder> finderList = entity.getFinderList();
                int j = 0;
                while (j < finderList.size()) {
                    EntityFinder finder = finderList.get(j);
                    if (finder.isDBIndex()) {
                        ArrayList<String> finderColsNames = new ArrayList<String>();
                        List<EntityColumn> finderColsList = finder.getColumns();
                        int k = 0;
                        while (k < finderColsList.size()) {
                            EntityColumn col = finderColsList.get(k);
                            finderColsNames.add(col.getDBName());
                            ++k;
                        }
                        IndexMetadata indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata((boolean)finder.isUnique(), (String)entity.getTable(), (String[])finderColsNames.toArray(new String[finderColsNames.size()]));
                        indexSQLs.put(indexMetadata.getSpecification(), indexMetadata.getCreateSQL());
                        String finderName = String.valueOf(entity.getTable()) + "." + finder.getName();
                        indexProps.put(finderName, indexMetadata.getIndexName());
                    }
                    ++j;
                }
            }
            ++var6_11;
        }
        for (Map.Entry entry : this._entityMappings.entrySet()) {
            EntityMapping entityMapping = (EntityMapping)entry.getValue();
            this._getCreateMappingTableIndex(entityMapping, indexSQLs, indexProps);
        }
        StringBundler stringBundler = new StringBundler();
        String prevEntityName = null;
        for (String indexSQL2 : indexSQLs.values()) {
            int pos = indexSQL2.indexOf(" on ");
            String indexSQLSuffix = indexSQL2.substring(pos + 4);
            String entityName = indexSQLSuffix.split(" ")[0];
            if (prevEntityName != null && !prevEntityName.equals(entityName)) {
                stringBundler.append("\n");
            }
            stringBundler.append(indexSQL2);
            stringBundler.append("\n");
            prevEntityName = entityName;
        }
        if (!indexSQLs.isEmpty()) {
            stringBundler.setIndex(stringBundler.index() - 1);
        }
        FileUtil.write((File)sqlFile, (String)stringBundler.toString(), (boolean)true);
        stringBundler.setIndex(0);
        prevEntityName = null;
        for (String finderName : indexProps.keySet()) {
            String indexName = (String)indexProps.get(finderName);
            String entityName = finderName.split("\\.")[0];
            if (prevEntityName != null && !prevEntityName.equals(entityName)) {
                stringBundler.append("\n");
            }
            stringBundler.append(indexName);
            stringBundler.append("=");
            stringBundler.append(finderName);
            stringBundler.append("\n");
            prevEntityName = entityName;
        }
        if (!indexProps.isEmpty()) {
            stringBundler.setIndex(stringBundler.index() - 1);
        }
        FileUtil.write((File)propsFile, (String)stringBundler.toString(), (boolean)true);
    }

    private void _createSQLMappingTables(File sqlFile, String newCreateTableString, EntityMapping entityMapping, boolean addMissingTables) throws IOException {
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        String content = FileUtil.read((File)sqlFile);
        int x = content.indexOf(_SQL_CREATE_TABLE + entityMapping.getTable() + " (");
        int y = content.indexOf(");", x);
        if (x != -1) {
            String oldCreateTableString = content.substring(x + 1, y);
            if (!oldCreateTableString.equals(newCreateTableString)) {
                content = String.valueOf(content.substring(0, x)) + newCreateTableString + content.substring(y + 2);
                FileUtil.write((File)sqlFile, (String)content);
            }
        } else if (addMissingTables) {
            StringBundler sb = new StringBundler();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
            String line = null;
            boolean appendNewTable = true;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String tableName;
                if (appendNewTable && line.startsWith(_SQL_CREATE_TABLE) && (tableName = line.substring(x = _SQL_CREATE_TABLE.length(), y = line.indexOf(" ", x))).compareTo(entityMapping.getTable()) > 0) {
                    sb.append(newCreateTableString);
                    sb.append("\n\n");
                    appendNewTable = false;
                }
                sb.append(line);
                sb.append("\n");
            }
            if (appendNewTable) {
                sb.append("\n");
                sb.append(newCreateTableString);
            }
            unsyncBufferedReader.close();
            FileUtil.write((File)sqlFile, (String)sb.toString(), (boolean)true);
        }
    }

    private void _createSQLSequences() throws IOException {
        String sequenceSQL;
        if (!FileUtil.exists((String)this._sqlDir)) {
            return;
        }
        File sqlFile = new File(String.valueOf(this._sqlDir) + "/" + this._sqlSequencesFileName);
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        TreeSet<String> sequenceSQLs = new TreeSet<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(sqlFile));
        while ((sequenceSQL = unsyncBufferedReader.readLine()) != null) {
            if (!Validator.isNotNull((String)sequenceSQL)) continue;
            sequenceSQLs.add(sequenceSQL);
        }
        unsyncBufferedReader.close();
        int i2 = 0;
        while (i2 < this._ejbList.size()) {
            Entity entity = this._ejbList.get(i2);
            if (this._isTargetEntity(entity) && entity.isDefaultDataSource()) {
                List<EntityColumn> columnList = entity.getColumnList();
                int j = 0;
                while (j < columnList.size()) {
                    EntityColumn column = columnList.get(j);
                    if ("sequence".equals(column.getIdType())) {
                        StringBundler sb = new StringBundler();
                        String sequenceName = column.getIdParam();
                        if (sequenceName.length() > 30) {
                            sequenceName = sequenceName.substring(0, 30);
                        }
                        sb.append("create sequence ");
                        sb.append(sequenceName);
                        sb.append(";");
                        String sequenceSQL2 = sb.toString();
                        if (!sequenceSQLs.contains(sequenceSQL2)) {
                            sequenceSQLs.add(sequenceSQL2);
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        StringBundler sb = new StringBundler(sequenceSQLs.size() * 2);
        for (String sequenceSQL3 : sequenceSQLs) {
            sb.append(sequenceSQL3);
            sb.append("\n");
        }
        if (!sequenceSQLs.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        FileUtil.write((File)sqlFile, (String)sb.toString(), (boolean)true);
    }

    private void _createSQLTables() throws IOException {
        if (!FileUtil.exists((String)this._sqlDir)) {
            return;
        }
        File sqlFile = new File(String.valueOf(this._sqlDir) + "/" + this._sqlFileName);
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        int i2 = 0;
        while (i2 < this._ejbList.size()) {
            String createTableSQL;
            Entity entity = this._ejbList.get(i2);
            if (this._isTargetEntity(entity) && entity.isDefaultDataSource() && Validator.isNotNull((String)(createTableSQL = this._getCreateTableSQL(entity)))) {
                this._createSQLTables(sqlFile, createTableSQL, entity, true);
                this._updateSQLFile("update-6.1.1-6.2.0.sql", createTableSQL, entity);
            }
            ++i2;
        }
        for (Map.Entry<String, EntityMapping> entry : this._entityMappings.entrySet()) {
            EntityMapping entityMapping = entry.getValue();
            String createMappingTableSQL = this._getCreateMappingTableSQL(entityMapping);
            if (!Validator.isNotNull((String)createMappingTableSQL)) continue;
            this._createSQLMappingTables(sqlFile, createMappingTableSQL, entityMapping, true);
        }
        String content = FileUtil.read((File)sqlFile);
        FileUtil.write((File)sqlFile, (String)content.trim());
    }

    private void _createSQLTables(File sqlFile, String newCreateTableString, Entity entity, boolean addMissingTables) throws IOException {
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        String content = FileUtil.read((File)sqlFile);
        int x = content.indexOf(_SQL_CREATE_TABLE + entity.getTable() + " (");
        int y = content.indexOf(");", x);
        if (x != -1) {
            String oldCreateTableString = content.substring(x + 1, y);
            if (!oldCreateTableString.equals(newCreateTableString)) {
                content = String.valueOf(content.substring(0, x)) + newCreateTableString + content.substring(y + 2);
                FileUtil.write((File)sqlFile, (String)content);
            }
        } else if (addMissingTables) {
            StringBundler sb = new StringBundler();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
            String line = null;
            boolean appendNewTable = true;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String tableName;
                if (appendNewTable && line.startsWith(_SQL_CREATE_TABLE) && (tableName = line.substring(x = _SQL_CREATE_TABLE.length(), y = line.indexOf(" ", x))).compareTo(entity.getTable()) > 0) {
                    sb.append(newCreateTableString);
                    sb.append("\n\n");
                    appendNewTable = false;
                }
                sb.append(line);
                sb.append("\n");
            }
            if (appendNewTable) {
                sb.append("\n");
                sb.append(newCreateTableString);
            }
            unsyncBufferedReader.close();
            FileUtil.write((File)sqlFile, (String)sb.toString(), (boolean)true);
        }
    }

    private String _fixHbmXml(String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("\t<class name=\"") && !(line = StringUtil.replace((String)line, (String[])new String[]{".service.persistence.", "HBM\" table=\""}, (String[])new String[]{".model.", "\" table=\""})).contains(".model.impl.") && !line.contains("BlobModel")) {
                line = StringUtil.replace((String)line, (String[])new String[]{".model.", "\" table=\""}, (String[])new String[]{".model.impl.", "Impl\" table=\""});
            }
            sb.append(line);
            sb.append('\n');
        }
        unsyncBufferedReader.close();
        return sb.toString().trim();
    }

    private String _fixSpringXml(String content) {
        return StringUtil.replace((String)content, (String)".service.spring.", (String)".service.");
    }

    private String _formatComment(String comment, DocletTag[] tags, String indentation) {
        StringBundler sb = new StringBundler();
        if (Validator.isNull((String)comment) && tags.length <= 0) {
            return sb.toString();
        }
        sb.append(indentation);
        sb.append("/**\n");
        if (Validator.isNotNull((String)comment)) {
            comment = comment.replaceAll("(?m)^", String.valueOf(indentation) + " * ");
            sb.append(comment);
            sb.append("\n");
            if (tags.length > 0) {
                sb.append(indentation);
                sb.append(" *\n");
            }
        }
        DocletTag[] docletTagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag tag = docletTagArray[n2];
            sb.append(indentation);
            sb.append(" * @");
            sb.append(tag.getName());
            sb.append(" ");
            sb.append(tag.getValue());
            sb.append("\n");
            ++n2;
        }
        sb.append(indentation);
        sb.append(" */\n");
        return sb.toString();
    }

    private String _formatXml(String xml) throws DocumentException, IOException {
        String doctype = null;
        int x = xml.indexOf("<!DOCTYPE");
        if (x != -1) {
            int y = xml.indexOf(">", x) + 1;
            doctype = xml.substring(x, y);
            xml = String.valueOf(xml.substring(0, x)) + "\n" + xml.substring(y);
        }
        xml = StringUtil.replace((String)xml, (char)'\r', (String)"");
        xml = XMLFormatter.toString((String)xml);
        xml = StringUtil.replace((String)xml, (String)"\"/>", (String)"\" />");
        if (Validator.isNotNull((String)doctype)) {
            x = xml.indexOf("?>") + 2;
            xml = String.valueOf(xml.substring(0, x)) + "\n" + doctype + xml.substring(x);
        }
        return xml;
    }

    private JavaField[] _getCacheFields(JavaClass javaClass) {
        if (javaClass == null) {
            return new JavaField[0];
        }
        ArrayList<JavaField> javaFields = new ArrayList<JavaField>();
        JavaField[] javaFieldArray = javaClass.getFields();
        int n = javaFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] annotations;
            JavaField javaField = javaFieldArray[n2];
            Annotation[] annotationArray = annotations = javaField.getAnnotations();
            int n3 = annotations.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                Type type = annotation.getType();
                String className = type.getFullyQualifiedName();
                if (className.equals(CacheField.class.getName())) {
                    javaFields.add(javaField);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return javaFields.toArray(new JavaField[javaFields.size()]);
    }

    private Map<String, Object> _getContext() throws TemplateModelException {
        BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
        TemplateHashModel staticModels = wrapper.getStaticModels();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("hbmFileName", this._hbmFileName);
        context.put("ormFileName", this._ormFileName);
        context.put("modelHintsFileName", this._modelHintsFileName);
        context.put("springFileName", this._springFileName);
        context.put("springBaseFileName", this._springBaseFileName);
        context.put("springHibernateFileName", this._springHibernateFileName);
        context.put("springInfrastructureFileName", this._springInfrastructureFileName);
        context.put("apiDir", this._apiDir);
        context.put("implDir", this._implDir);
        context.put("sqlDir", this._sqlDir);
        context.put("sqlFileName", this._sqlFileName);
        context.put("beanLocatorUtil", this._beanLocatorUtil);
        context.put("beanLocatorUtilShortName", this._beanLocatorUtilShortName);
        context.put("propsUtil", this._propsUtil);
        context.put("portletName", this._portletName);
        context.put("portletShortName", this._portletShortName);
        context.put("portletPackageName", this._portletPackageName);
        context.put("outputPath", this._outputPath);
        context.put("serviceOutputPath", this._serviceOutputPath);
        context.put("packagePath", this._packagePath);
        context.put("pluginName", this._pluginName);
        context.put("author", this._author);
        context.put("serviceBuilder", this);
        context.put("arrayUtil", ArrayUtil_IW.getInstance());
        context.put("modelHintsUtil", ModelHintsUtil.getModelHints());
        context.put("resourceActionsUtil", ResourceActionsUtil.getResourceActions());
        context.put("stringUtil", StringUtil_IW.getInstance());
        context.put("system", staticModels.get("java.lang.System"));
        context.put("tempMap", wrapper.wrap(new HashMap()));
        context.put("textFormatter", staticModels.get(TextFormatter.class.getName()));
        context.put("validator", Validator_IW.getInstance());
        return context;
    }

    private void _getCreateMappingTableIndex(EntityMapping entityMapping, Map<String, String> indexSQLs, Map<String, String> indexProps) throws IOException {
        Entity[] entities = new Entity[2];
        int i2 = 0;
        while (i2 < entities.length) {
            entities[i2] = this.getEntity(entityMapping.getEntity(i2));
            if (entities[i2] == null) {
                return;
            }
            ++i2;
        }
        Entity[] entityArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            List<EntityColumn> pkList = entity.getPKList();
            int j = 0;
            while (j < pkList.size()) {
                EntityColumn col = pkList.get(j);
                String colDBName = col.getDBName();
                String indexSpec = String.valueOf(entityMapping.getTable()) + " (" + colDBName + ");";
                String indexHash = StringUtil.toHexString((int)indexSpec.hashCode());
                indexHash = StringUtil.toUpperCase((String)indexHash);
                String indexName = "IX_" + indexHash;
                StringBundler sb = new StringBundler();
                sb.append("create index ");
                sb.append(indexName);
                sb.append(" on ");
                sb.append(indexSpec);
                indexSQLs.put(indexSpec, sb.toString());
                String finderName = String.valueOf(entityMapping.getTable()) + "." + colDBName;
                indexProps.put(finderName, indexName);
                ++j;
            }
            ++n2;
        }
    }

    private String _getCreateMappingTableSQL(EntityMapping entityMapping) throws IOException {
        Entity[] entities = new Entity[2];
        int i2 = 0;
        while (i2 < entities.length) {
            entities[i2] = this.getEntity(entityMapping.getEntity(i2));
            if (entities[i2] == null) {
                return null;
            }
            ++i2;
        }
        Arrays.sort(entities, new Comparator<Entity>(){

            @Override
            public int compare(Entity entity1, Entity entity2) {
                String name1 = entity1.getName();
                String name2 = entity2.getName();
                return name1.compareTo(name2);
            }
        });
        StringBundler sb = new StringBundler();
        sb.append(_SQL_CREATE_TABLE);
        sb.append(entityMapping.getTable());
        sb.append(" (\n");
        Entity[] entityArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            List<EntityColumn> pkList = entity.getPKList();
            int i3 = 0;
            while (i3 < pkList.size()) {
                EntityColumn col = pkList.get(i3);
                String colName = col.getName();
                String colType = col.getType();
                sb.append("\t");
                sb.append(col.getDBName());
                sb.append(" ");
                if (StringUtil.equalsIgnoreCase((String)colType, (String)"boolean")) {
                    sb.append("BOOLEAN");
                } else if (StringUtil.equalsIgnoreCase((String)colType, (String)"double") || StringUtil.equalsIgnoreCase((String)colType, (String)"float")) {
                    sb.append("DOUBLE");
                } else if (colType.equals("int") || colType.equals("Integer") || StringUtil.equalsIgnoreCase((String)colType, (String)"short")) {
                    sb.append("INTEGER");
                } else if (StringUtil.equalsIgnoreCase((String)colType, (String)"long")) {
                    sb.append("LONG");
                } else if (colType.equals("String")) {
                    Map hints = ModelHintsUtil.getHints((String)(String.valueOf(this._packagePath) + ".model." + entity.getName()), (String)colName);
                    int maxLength = 75;
                    if (hints != null) {
                        maxLength = GetterUtil.getInteger((String)((String)hints.get("max-length")), (int)maxLength);
                    }
                    if (col.isLocalized()) {
                        maxLength = 4000;
                    }
                    if (maxLength < 4000) {
                        sb.append("VARCHAR(");
                        sb.append(maxLength);
                        sb.append(")");
                    } else if (maxLength == 4000) {
                        sb.append("STRING");
                    } else if (maxLength > 4000) {
                        sb.append("TEXT");
                    }
                } else if (colType.equals("Date")) {
                    sb.append("DATE");
                } else {
                    sb.append("invalid");
                }
                if (col.isPrimary()) {
                    sb.append(" not null");
                } else if (colType.equals("Date") || colType.equals("String")) {
                    sb.append(" null");
                }
                sb.append(",\n");
                ++i3;
            }
            ++n2;
        }
        sb.append("\tprimary key (");
        int i4 = 0;
        while (i4 < entities.length) {
            Entity entity = entities[i4];
            List<EntityColumn> pkList = entity.getPKList();
            int j = 0;
            while (j < pkList.size()) {
                EntityColumn col = pkList.get(j);
                String colDBName = col.getDBName();
                if (i4 != 0 || j != 0) {
                    sb.append(", ");
                }
                sb.append(colDBName);
                ++j;
            }
            ++i4;
        }
        sb.append(")\n");
        sb.append(");");
        return sb.toString();
    }

    private String _getCreateTableSQL(Entity entity) {
        List<EntityColumn> pkList = entity.getPKList();
        List<EntityColumn> regularColList = entity.getRegularColList();
        if (regularColList.size() == 0) {
            return null;
        }
        StringBundler sb = new StringBundler();
        sb.append(_SQL_CREATE_TABLE);
        sb.append(entity.getTable());
        sb.append(" (\n");
        int i2 = 0;
        while (i2 < regularColList.size()) {
            EntityColumn col = regularColList.get(i2);
            String colName = col.getName();
            String colType = col.getType();
            String colIdType = col.getIdType();
            sb.append("\t");
            sb.append(col.getDBName());
            sb.append(" ");
            if (StringUtil.equalsIgnoreCase((String)colType, (String)"boolean")) {
                sb.append("BOOLEAN");
            } else if (StringUtil.equalsIgnoreCase((String)colType, (String)"double") || StringUtil.equalsIgnoreCase((String)colType, (String)"float")) {
                sb.append("DOUBLE");
            } else if (colType.equals("int") || colType.equals("Integer") || StringUtil.equalsIgnoreCase((String)colType, (String)"short")) {
                sb.append("INTEGER");
            } else if (StringUtil.equalsIgnoreCase((String)colType, (String)"long")) {
                sb.append("LONG");
            } else if (colType.equals("Blob")) {
                sb.append("BLOB");
            } else if (colType.equals("Date")) {
                sb.append("DATE");
            } else if (colType.equals("String")) {
                Map hints = ModelHintsUtil.getHints((String)(String.valueOf(this._packagePath) + ".model." + entity.getName()), (String)colName);
                int maxLength = 75;
                if (hints != null) {
                    maxLength = GetterUtil.getInteger((String)((String)hints.get("max-length")), (int)maxLength);
                }
                if (col.isLocalized() && maxLength < 4000) {
                    maxLength = 4000;
                }
                if (maxLength < 4000) {
                    sb.append("VARCHAR(");
                    sb.append(maxLength);
                    sb.append(")");
                } else if (maxLength == 4000) {
                    sb.append("STRING");
                } else if (maxLength > 4000) {
                    sb.append("TEXT");
                }
            } else {
                sb.append("invalid");
            }
            if (col.isPrimary()) {
                sb.append(" not null");
                if (!entity.hasCompoundPK()) {
                    sb.append(" primary key");
                }
            } else if (colType.equals("Date") || colType.equals("String")) {
                sb.append(" null");
            }
            if (Validator.isNotNull((String)colIdType) && colIdType.equals("identity")) {
                sb.append(" IDENTITY");
            }
            if (i2 + 1 != regularColList.size() || entity.hasCompoundPK()) {
                sb.append(",");
            }
            sb.append("\n");
            ++i2;
        }
        if (entity.hasCompoundPK()) {
            sb.append("\tprimary key (");
            int j = 0;
            while (j < pkList.size()) {
                EntityColumn pk = pkList.get(j);
                sb.append(pk.getDBName());
                if (j + 1 != pkList.size()) {
                    sb.append(", ");
                }
                ++j;
            }
            sb.append(")\n");
        }
        sb.append(");");
        return sb.toString();
    }

    private String _getDimensions(Type type) {
        String dimensions = "";
        int i2 = 0;
        while (i2 < type.getDimensions()) {
            dimensions = String.valueOf(dimensions) + "[]";
            ++i2;
        }
        return dimensions;
    }

    private JavaClass _getJavaClass(String fileName) throws IOException {
        int pos = fileName.indexOf(String.valueOf(this._implDir) + "/");
        pos = pos != -1 ? (pos += this._implDir.length()) : fileName.indexOf(String.valueOf(this._apiDir) + "/") + this._apiDir.length();
        String srcFile = fileName.substring(pos + 1);
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaClass javaClass = this._javaClasses.get(className);
        if (javaClass == null) {
            ClassLibrary classLibrary = new ClassLibrary();
            classLibrary.addClassLoader(this.getClass().getClassLoader());
            JavaDocBuilder builder = new JavaDocBuilder(classLibrary);
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            builder.addSource(file);
            javaClass = builder.getClassByName(className);
            this._javaClasses.put(className, javaClass);
        }
        return javaClass;
    }

    private JavaMethod[] _getMethods(JavaClass javaClass) {
        return this._getMethods(javaClass, false);
    }

    private JavaMethod[] _getMethods(JavaClass javaClass, boolean superclasses) {
        JavaMethod[] methods;
        JavaMethod[] javaMethodArray = methods = javaClass.getMethods(superclasses);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod method = javaMethodArray[n2];
            Arrays.sort(method.getExceptions());
            ++n2;
        }
        return methods;
    }

    private String _getSessionTypeName(int sessionType) {
        if (sessionType == 1) {
            return "Local";
        }
        return "";
    }

    private String _getTplProperty(String key, String defaultValue) {
        return System.getProperty("service.tpl." + key, defaultValue);
    }

    private List<String> _getTransients(Entity entity, boolean parent) throws Exception {
        File modelFile = null;
        modelFile = parent ? new File(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "ModelImpl.java") : new File(String.valueOf(this._outputPath) + "/model/impl/" + entity.getName() + "Impl.java");
        String content = FileUtil.read((File)modelFile);
        Matcher matcher = _getterPattern.matcher(content);
        HashSet<String> getters = new HashSet<String>();
        while (!matcher.hitEnd()) {
            String property;
            boolean found = matcher.find();
            if (!found || entity.hasColumn(property = (property = matcher.group()).contains("get") ? property.substring(property.indexOf("get") + 3, property.length() - 1) : property.substring(property.indexOf("is") + 2, property.length() - 1)) || entity.hasColumn(Introspector.decapitalize(property))) continue;
            property = Introspector.decapitalize(property);
            getters.add(property);
        }
        matcher = _setterPattern.matcher(content);
        HashSet<String> setters = new HashSet<String>();
        while (!matcher.hitEnd()) {
            boolean found = matcher.find();
            if (!found) continue;
            String property = matcher.group();
            if (entity.hasColumn(property = property.substring(property.indexOf("set") + 3, property.length() - 1)) || entity.hasColumn(Introspector.decapitalize(property))) continue;
            property = Introspector.decapitalize(property);
            setters.add(property);
        }
        getters.retainAll(setters);
        ArrayList<String> transients = new ArrayList<String>(getters);
        Collections.sort(transients);
        return transients;
    }

    private boolean _hasHttpMethods(JavaClass javaClass) {
        JavaMethod[] methods;
        JavaMethod[] javaMethodArray = methods = this._getMethods(javaClass);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = javaMethodArray[n2];
            if (!javaMethod.isConstructor() && javaMethod.isPublic() && this.isCustomMethod(javaMethod)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean _isStringLocaleMap(JavaParameter javaParameter) {
        Type type = javaParameter.getType();
        Type[] actualArgumentTypes = type.getActualTypeArguments();
        if (actualArgumentTypes.length != 2) {
            return false;
        }
        return this._isTypeValue(actualArgumentTypes[0], Locale.class.getName()) && this._isTypeValue(actualArgumentTypes[1], String.class.getName());
    }

    private boolean _isTargetEntity(Entity entity) {
        if (this._targetEntityName == null || this._targetEntityName.startsWith("$")) {
            return true;
        }
        return this._targetEntityName.equals(entity.getName());
    }

    private boolean _isTypeValue(Type type, String value) {
        return value.equals(type.getValue());
    }

    private List<Entity> _mergeReferenceList(List<Entity> referenceList) {
        ArrayList<Entity> list = new ArrayList<Entity>(this._ejbList.size() + referenceList.size());
        list.addAll(this._ejbList);
        list.addAll(referenceList);
        return list;
    }

    private void _parseEntity(Element entityElement) throws Exception {
        String alias;
        Element finderElement;
        String ejbName = entityElement.attributeValue("name");
        String humanName = entityElement.attributeValue("human-name");
        String table = entityElement.attributeValue("table");
        if (Validator.isNull((String)table)) {
            table = ejbName;
            if (this._badTableNames.contains(ejbName)) {
                table = String.valueOf(table) + "_";
            }
            if (this._autoNamespaceTables) {
                table = String.valueOf(this._portletShortName) + "_" + ejbName;
            }
        }
        boolean uuid = GetterUtil.getBoolean((String)entityElement.attributeValue("uuid"));
        boolean uuidAccessor = GetterUtil.getBoolean((String)entityElement.attributeValue("uuid-accessor"));
        boolean localService = GetterUtil.getBoolean((String)entityElement.attributeValue("local-service"));
        boolean remoteService = GetterUtil.getBoolean((String)entityElement.attributeValue("remote-service"), (boolean)true);
        String persistenceClass = GetterUtil.getString((String)entityElement.attributeValue("persistence-class"), (String)(String.valueOf(this._packagePath) + ".service.persistence." + ejbName + "PersistenceImpl"));
        String finderClass = "";
        if (FileUtil.exists((String)(String.valueOf(this._outputPath) + "/service/persistence/" + ejbName + "FinderImpl.java"))) {
            finderClass = String.valueOf(this._packagePath) + ".service.persistence." + ejbName + "FinderImpl";
        }
        String dataSource = entityElement.attributeValue("data-source");
        String sessionFactory = entityElement.attributeValue("session-factory");
        String txManager = entityElement.attributeValue("tx-manager");
        boolean cacheEnabled = GetterUtil.getBoolean((String)entityElement.attributeValue("cache-enabled"), (boolean)true);
        boolean jsonEnabled = GetterUtil.getBoolean((String)entityElement.attributeValue("json-enabled"), (boolean)remoteService);
        boolean trashEnabled = GetterUtil.getBoolean((String)entityElement.attributeValue("trash-enabled"));
        boolean deprecated = GetterUtil.getBoolean((String)entityElement.attributeValue("deprecated"));
        ArrayList<EntityColumn> pkList = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> regularColList = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> blobList = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> collectionList = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> columnList = new ArrayList<EntityColumn>();
        List columnElements = entityElement.elements("column");
        boolean permissionedModel = false;
        if (uuid) {
            Element columnElement = SAXReaderUtil.createElement((String)"column");
            columnElement.addAttribute("name", "uuid");
            columnElement.addAttribute("type", "String");
            columnElements.add(0, columnElement);
        }
        for (Element columnElement : columnElements) {
            String columnDBName;
            String columnName = columnElement.attributeValue("name");
            if (columnName.equals("resourceBlockId") && !ejbName.equals("ResourceBlock")) {
                permissionedModel = true;
            }
            if (Validator.isNull((String)(columnDBName = columnElement.attributeValue("db-name")))) {
                columnDBName = columnName;
                if (this._badColumnNames.contains(columnName)) {
                    columnDBName = String.valueOf(columnDBName) + "_";
                }
            }
            String columnType = columnElement.attributeValue("type");
            boolean primary = GetterUtil.getBoolean((String)columnElement.attributeValue("primary"));
            boolean accessor = GetterUtil.getBoolean((String)columnElement.attributeValue("accessor"));
            boolean filterPrimary = GetterUtil.getBoolean((String)columnElement.attributeValue("filter-primary"));
            String collectionEntity = columnElement.attributeValue("entity");
            String mappingTable = columnElement.attributeValue("mapping-table");
            if (Validator.isNotNull((String)mappingTable)) {
                if (this._badTableNames.contains(mappingTable)) {
                    mappingTable = String.valueOf(mappingTable) + "_";
                }
                if (this._autoNamespaceTables) {
                    mappingTable = String.valueOf(this._portletShortName) + "_" + mappingTable;
                }
            }
            String idType = columnElement.attributeValue("id-type");
            String idParam = columnElement.attributeValue("id-param");
            boolean convertNull = GetterUtil.getBoolean((String)columnElement.attributeValue("convert-null"), (boolean)true);
            boolean lazy = GetterUtil.getBoolean((String)columnElement.attributeValue("lazy"), (boolean)true);
            boolean localized = GetterUtil.getBoolean((String)columnElement.attributeValue("localized"));
            boolean colJsonEnabled = GetterUtil.getBoolean((String)columnElement.attributeValue("json-enabled"), (boolean)jsonEnabled);
            boolean containerModel = GetterUtil.getBoolean((String)columnElement.attributeValue("container-model"));
            boolean parentContainerModel = GetterUtil.getBoolean((String)columnElement.attributeValue("parent-container-model"));
            EntityColumn col = new EntityColumn(columnName, columnDBName, columnType, primary, accessor, filterPrimary, collectionEntity, mappingTable, idType, idParam, convertNull, lazy, localized, colJsonEnabled, containerModel, parentContainerModel);
            if (primary) {
                pkList.add(col);
            }
            if (columnType.equals("Collection")) {
                collectionList.add(col);
            } else {
                regularColList.add(col);
                if (columnType.equals("Blob")) {
                    blobList.add(col);
                }
            }
            columnList.add(col);
            if (!Validator.isNotNull((String)collectionEntity) || !Validator.isNotNull((String)mappingTable)) continue;
            EntityMapping entityMapping = new EntityMapping(mappingTable, ejbName, collectionEntity);
            if (this._entityMappings.containsKey(mappingTable)) continue;
            this._entityMappings.put(mappingTable, entityMapping);
        }
        EntityOrder order = null;
        Element orderElement = entityElement.element("order");
        if (orderElement != null) {
            boolean asc = true;
            if (orderElement.attribute("by") != null && orderElement.attributeValue("by").equals("desc")) {
                asc = false;
            }
            ArrayList<EntityColumn> orderColsList = new ArrayList<EntityColumn>();
            order = new EntityOrder(asc, orderColsList);
            List orderColumnElements = orderElement.elements("order-column");
            for (Element orderColElement : orderColumnElements) {
                String orderColName = orderColElement.attributeValue("name");
                boolean orderColCaseSensitive = GetterUtil.getBoolean((String)orderColElement.attributeValue("case-sensitive"), (boolean)true);
                boolean orderColByAscending = asc;
                String orderColBy = GetterUtil.getString((String)orderColElement.attributeValue("order-by"));
                if (orderColBy.equals("asc")) {
                    orderColByAscending = true;
                } else if (orderColBy.equals("desc")) {
                    orderColByAscending = false;
                }
                EntityColumn col = Entity.getColumn(orderColName, columnList);
                col.setOrderColumn(true);
                col = (EntityColumn)col.clone();
                col.setCaseSensitive(orderColCaseSensitive);
                col.setOrderByAscending(orderColByAscending);
                orderColsList.add(col);
            }
        }
        ArrayList<EntityFinder> finderList = new ArrayList<EntityFinder>();
        List finderElements = entityElement.elements("finder");
        if (uuid) {
            if (columnList.contains(new EntityColumn("companyId"))) {
                finderElement = SAXReaderUtil.createElement((String)"finder");
                finderElement.addAttribute("name", "Uuid_C");
                finderElement.addAttribute("return-type", "Collection");
                Element finderColumnElement = finderElement.addElement("finder-column");
                finderColumnElement.addAttribute("name", "uuid");
                finderColumnElement = finderElement.addElement("finder-column");
                finderColumnElement.addAttribute("name", "companyId");
                finderElements.add(0, finderElement);
            }
            if (columnList.contains(new EntityColumn("groupId"))) {
                finderElement = SAXReaderUtil.createElement((String)"finder");
                if (ejbName.equals("Layout")) {
                    finderElement.addAttribute("name", "UUID_G_P");
                } else {
                    finderElement.addAttribute("name", "UUID_G");
                }
                finderElement.addAttribute("return-type", ejbName);
                finderElement.addAttribute("unique", "true");
                Element finderColumnElement = finderElement.addElement("finder-column");
                finderColumnElement.addAttribute("name", "uuid");
                finderColumnElement = finderElement.addElement("finder-column");
                finderColumnElement.addAttribute("name", "groupId");
                if (ejbName.equals("Layout")) {
                    finderColumnElement = finderElement.addElement("finder-column");
                    finderColumnElement.addAttribute("name", "privateLayout");
                }
                finderElements.add(0, finderElement);
            }
            finderElement = SAXReaderUtil.createElement((String)"finder");
            finderElement.addAttribute("name", "Uuid");
            finderElement.addAttribute("return-type", "Collection");
            Element finderColumnElement = finderElement.addElement("finder-column");
            finderColumnElement.addAttribute("name", "uuid");
            finderElements.add(0, finderElement);
        }
        if (permissionedModel) {
            finderElement = SAXReaderUtil.createElement((String)"finder");
            finderElement.addAttribute("name", "ResourceBlockId");
            finderElement.addAttribute("return-type", "Collection");
            Element finderColumnElement = finderElement.addElement("finder-column");
            finderColumnElement.addAttribute("name", "resourceBlockId");
            finderElements.add(0, finderElement);
        }
        if (this._badAliasNames.contains(StringUtil.toLowerCase((String)(alias = TextFormatter.format((String)ejbName, (int)8))))) {
            alias = String.valueOf(alias) + "_";
        }
        for (Element finderElement2 : finderElements) {
            String finderName = finderElement2.attributeValue("name");
            String finderReturn = finderElement2.attributeValue("return-type");
            boolean finderUnique = GetterUtil.getBoolean((String)finderElement2.attributeValue("unique"));
            String finderWhere = finderElement2.attributeValue("where");
            if (Validator.isNotNull((String)finderWhere)) {
                for (EntityColumn column : columnList) {
                    String name = column.getName();
                    if (!finderWhere.contains(name)) continue;
                    finderWhere = finderWhere.replaceAll(name, String.valueOf(alias) + "." + name);
                }
            }
            boolean finderDBIndex = GetterUtil.getBoolean((String)finderElement2.attributeValue("db-index"), (boolean)true);
            ArrayList<EntityColumn> finderColsList = new ArrayList<EntityColumn>();
            List finderColumnElements = finderElement2.elements("finder-column");
            for (Element finderColumnElement : finderColumnElements) {
                String finderColName = finderColumnElement.attributeValue("name");
                boolean finderColCaseSensitive = GetterUtil.getBoolean((String)finderColumnElement.attributeValue("case-sensitive"), (boolean)true);
                String finderColComparator = GetterUtil.getString((String)finderColumnElement.attributeValue("comparator"), (String)"=");
                String finderColArrayableOperator = GetterUtil.getString((String)finderColumnElement.attributeValue("arrayable-operator"));
                EntityColumn col = Entity.getColumn(finderColName, columnList);
                if (!col.isFinderPath()) {
                    col.setFinderPath(true);
                }
                col = (EntityColumn)col.clone();
                col.setCaseSensitive(finderColCaseSensitive);
                col.setComparator(finderColComparator);
                col.setArrayableOperator(finderColArrayableOperator);
                finderColsList.add(col);
            }
            finderList.add(new EntityFinder(finderName, finderReturn, finderUnique, finderWhere, finderDBIndex, finderColsList));
        }
        ArrayList<Entity> referenceList = new ArrayList<Entity>();
        if (this._build) {
            if (Validator.isNotNull((String)this._pluginName)) {
                String[] stringArray = PropsValues.RESOURCE_ACTIONS_CONFIGS;
                int finderReturn = PropsValues.RESOURCE_ACTIONS_CONFIGS.length;
                int finderName = 0;
                while (finderName < finderReturn) {
                    String config = stringArray[finderName];
                    File file = new File(String.valueOf(this._implDir) + "/" + config);
                    if (file.exists()) {
                        FileInputStream inputStream = new FileInputStream(file);
                        ResourceActionsUtil.read((String)this._pluginName, (InputStream)inputStream);
                    }
                    ++finderName;
                }
            }
            List referenceElements = entityElement.elements("reference");
            TreeSet<String> referenceSet = new TreeSet<String>();
            for (Element referenceElement : referenceElements) {
                String referencePackage = referenceElement.attributeValue("package-path");
                String referenceEntity = referenceElement.attributeValue("entity");
                referenceSet.add(String.valueOf(referencePackage) + "." + referenceEntity);
            }
            if (!this._packagePath.equals("com.liferay.counter")) {
                referenceSet.add("com.liferay.counter.Counter");
            }
            if (!this._packagePath.equals("com.liferay.portal")) {
                referenceSet.add("com.liferay.portal.Resource");
                referenceSet.add("com.liferay.portal.User");
            }
            for (String referenceName : referenceSet) {
                referenceList.add(this.getEntity(referenceName));
            }
        }
        ArrayList<String> txRequiredList = new ArrayList<String>();
        List txRequiredElements = entityElement.elements("tx-required");
        for (Element txRequiredEl : txRequiredElements) {
            String txRequired = txRequiredEl.getText();
            txRequiredList.add(txRequired);
        }
        this._ejbList.add(new Entity(this._packagePath, this._portletName, this._portletShortName, ejbName, humanName, table, alias, uuid, uuidAccessor, localService, remoteService, persistenceClass, finderClass, dataSource, sessionFactory, txManager, cacheEnabled, jsonEnabled, trashEnabled, deprecated, pkList, regularColList, blobList, collectionList, columnList, order, finderList, referenceList, txRequiredList));
    }

    private String _processTemplate(String name) throws Exception {
        return this._processTemplate(name, this._getContext());
    }

    private String _processTemplate(String name, Map<String, Object> context) throws Exception {
        return StringUtil.strip((String)FreeMarkerUtil.process(name, context), (char)'\r');
    }

    private Map<String, Object> _putDeprecatedKeys(Map<String, Object> context, JavaClass javaClass) {
        context.put("classDeprecated", false);
        DocletTag tag = javaClass.getTagByName("deprecated");
        if (tag != null) {
            context.put("classDeprecated", true);
            context.put("classDeprecatedComment", tag.getValue());
        }
        return context;
    }

    private Set<String> _readLines(String fileName) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        HashSet<String> lines = new HashSet<String>();
        StringUtil.readLines((InputStream)classLoader.getResourceAsStream(fileName), lines);
        return lines;
    }

    private void _updateSQLFile(String sqlFileName, String createTableSQL, Entity entity) throws IOException {
        File updateSQLFile = new File(String.valueOf(this._sqlDir) + "/" + sqlFileName);
        if (updateSQLFile.exists()) {
            this._createSQLTables(updateSQLFile, createTableSQL, entity, false);
        }
    }
}

