/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _TAG_LIBRARIES = new String[]{"aui", "c", "html", "jsp", "liferay-portlet", "liferay-security", "liferay-theme", "liferay-ui", "liferay-util", "portlet", "struts", "tiles"};
    private List<String> _duplicateImportClassNames = new ArrayList<String>();
    private List<String> _importClassNames = new ArrayList<String>();
    private Map<String, Integer> _importCountMap = new HashMap<String, Integer>();
    private Pattern _jspAttributeNamePattern = Pattern.compile("[a-z]+[-_a-zA-Z0-9]*");
    private Map<String, String> _jspContents = new HashMap<String, String>();
    private Pattern _jspImportPattern = Pattern.compile("(<.*\n*page.import=\".*>\n*)+", 8);
    private Pattern _jspIncludeFilePattern = Pattern.compile("/.*[.]jsp[f]?");
    private boolean _stripJSPImports = true;
    private Pattern _taglibLanguageKeyPattern = Pattern.compile("(?:confirmation|label|(?:M|m)essage|message key|names|title)=\"[^A-Z<=%\\[\\s]+\"");
    private Pattern _xssPattern = Pattern.compile("\\s+([^\\s]+)\\s*=\\s*(Bean)?ParamUtil\\.getString\\(");

    protected void addImportCounts(String content) {
        Pattern pattern = Pattern.compile("page import=\"(.+)\"");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String importName = matcher.group(1);
            int count = 0;
            if (this._importCountMap.containsKey(importName)) {
                count = this._importCountMap.get(importName);
            } else {
                int pos = importName.lastIndexOf(".");
                String importClassName = importName.substring(pos + 1);
                if (this._importClassNames.contains(importClassName)) {
                    this._duplicateImportClassNames.add(importClassName);
                } else {
                    this._importClassNames.add(importClassName);
                }
            }
            this._importCountMap.put(importName, count + 1);
        }
    }

    protected void addJSPIncludeFileNames(String fileName, Set<String> includeFileNames) {
        int y;
        String content = this._jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return;
        }
        int x = 0;
        while ((x = content.indexOf("<%@ include file=", x)) != -1 && (x = content.indexOf("\"", x)) != -1 && (y = content.indexOf("\"", x + 1)) != -1) {
            String includeFileName = content.substring(x + 1, y);
            Matcher matcher = this._jspIncludeFilePattern.matcher(includeFileName);
            if (!matcher.find()) {
                throw new RuntimeException("Invalid include " + includeFileName);
            }
            String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
            includeFileName = String.valueOf(docrootPath) + includeFileName;
            if (!(!includeFileName.endsWith("jsp") && !includeFileName.endsWith("jspf") || includeFileName.endsWith("html/common/init.jsp") || includeFileName.endsWith("html/portlet/init.jsp") || includeFileName.endsWith("html/taglib/init.jsp") || includeFileNames.contains(includeFileName))) {
                includeFileNames.add(includeFileName);
            }
            x = y;
        }
    }

    protected void addJSPReferenceFileNames(String fileName, Set<String> includeFileNames) {
        for (Map.Entry<String, String> entry : this._jspContents.entrySet()) {
            String referenceFileName = entry.getKey();
            String content = entry.getValue();
            if (!content.contains("<%@ include file=\"" + fileName) || includeFileNames.contains(referenceFileName)) continue;
            includeFileNames.add(referenceFileName);
        }
    }

    protected void addJSPUnusedImports(String fileName, List<String> importLines, List<String> unneededImports) {
        for (String importLine : importLines) {
            HashSet<String> includeFileNames = new HashSet<String>();
            includeFileNames.add(fileName);
            HashSet<String> checkedFileNames = new HashSet<String>();
            int x = importLine.indexOf("\"");
            int y = importLine.indexOf("\"", x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            if (this.isClassOrVariableRequired(fileName, className = className.substring(className.lastIndexOf(".") + 1), includeFileNames, checkedFileNames)) continue;
            unneededImports.add(importLine);
        }
    }

    protected boolean checkTaglibVulnerability(String jspContent, String vulnerability) {
        int pos1 = -1;
        do {
            if ((pos1 = jspContent.indexOf(vulnerability, pos1 + 1)) == -1) continue;
            int pos2 = jspContent.lastIndexOf(60, pos1);
            while (pos2 > 0 && jspContent.charAt(pos2 + 1) == '%') {
                pos2 = jspContent.lastIndexOf(60, pos2 - 1);
            }
            String tagContent = jspContent.substring(pos2, pos1);
            if (tagContent.startsWith("<aui:") || tagContent.startsWith("<liferay-portlet:") || tagContent.startsWith("<liferay-util:") || tagContent.startsWith("<portlet:")) continue;
            return true;
        } while (pos1 != -1);
        return false;
    }

    protected void checkXSS(String fileName, String jspContent) {
        Matcher matcher = this._xssPattern.matcher(jspContent);
        while (matcher.find()) {
            String documentIdVulnerability;
            String inlineStringVulnerability3;
            String inlineStringVulnerability2;
            String inlineStringVulnerability1;
            String inputVulnerability;
            boolean xssVulnerable = false;
            String jspVariable = matcher.group(1);
            String anchorVulnerability = " href=\"<%= " + jspVariable + " %>";
            if (this.checkTaglibVulnerability(jspContent, anchorVulnerability)) {
                xssVulnerable = true;
            }
            if (this.checkTaglibVulnerability(jspContent, inputVulnerability = " value=\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability1 = "'<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability2 = "(\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability3 = " \"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(documentIdVulnerability = ".<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (!xssVulnerable) continue;
            this.processErrorMessage(fileName, "(xss): " + fileName + " (" + jspVariable + ")");
        }
    }

    @Override
    protected void format() throws Exception {
        String[] excludes = new String[]{"**\\portal\\aui\\**", "**\\bin\\**", "**\\null.jsp", "**\\tmp\\**", "**\\tools\\**"};
        String[] includes = new String[]{"**\\*.jsp", "**\\*.jspf", "**\\*.vm"};
        List<String> fileNames = this.getFileNames(excludes, includes);
        Pattern pattern = Pattern.compile("\\s*@\\s*include\\s*file=['\"](.*)['\"]");
        for (String fileName : fileNames) {
            File file = new File("./" + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = fileUtil.read(file);
            Matcher matcher = pattern.matcher(content);
            String newContent = content;
            while (matcher.find()) {
                newContent = StringUtil.replaceFirst((String)newContent, (String)matcher.group(), (String)("@ include file=\"" + matcher.group(1) + "\""), (int)matcher.start());
            }
            if (this.isAutoFix() && !content.equals(newContent)) {
                fileUtil.write(file, newContent);
                sourceFormatterHelper.printError(fileName, file);
            }
            if (portalSource && !mainReleaseVersion.equals("6.1.0") && fileName.endsWith("/init.jsp") && !fileName.endsWith("/common/init.jsp")) {
                this.addImportCounts(content);
            }
            this._jspContents.put(fileName, newContent);
        }
        if (portalSource && !mainReleaseVersion.equals("6.1.0")) {
            this.moveFrequentlyUsedImportsToCommonInit(4);
        }
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    @Override
    protected String format(String fileName) throws Exception {
        String content;
        File file = new File("./" + fileName);
        fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
        String oldContent = content = fileUtil.read(file);
        String newContent = "";
        while (!oldContent.equals(newContent = this.formatJSP(fileName, oldContent))) {
            oldContent = newContent;
        }
        newContent = StringUtil.replace((String)newContent, (String[])new String[]{"<br/>", "\"/>", "\" >", "@page import", "\"%>", ")%>", "else{", "for(", "function (", "if(", "javascript: ", "while(", "){\n", "\n\n\n"}, (String[])new String[]{"<br />", "\" />", "\">", "@ page import", "\" %>", ") %>", "else {", "for (", "function(", "if (", "javascript:", "while (", ") {\n", "\n\n"});
        newContent = this.fixCompatClassImports(file, newContent);
        if (this._stripJSPImports && !this._jspContents.isEmpty()) {
            try {
                newContent = this.stripJSPImports(fileName, newContent);
            }
            catch (RuntimeException runtimeException) {
                this._stripJSPImports = false;
            }
        }
        if (!(!portalSource || mainReleaseVersion.equals("6.1.0") || !content.contains("page import=") || fileName.contains("init.jsp") || fileName.contains("init-ext.jsp") || fileName.contains("/taglib/aui/") || fileName.endsWith("touch.jsp") || !fileName.endsWith(".jspf") && !content.contains("include file="))) {
            this.processErrorMessage(fileName, "move imports to init.jsp: " + fileName);
        }
        newContent = this.fixCopyright(newContent, this.getCopyright(), this.getOldCopyright(), file, fileName);
        if ((newContent = StringUtil.replace((String)newContent, (String[])new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil."}, (String[])new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil."})).contains("    ") && !fileName.matches(".*template.*\\.vm$")) {
            this.processErrorMessage(fileName, "tab: " + fileName);
        }
        if (fileName.endsWith("init.jsp") || fileName.endsWith("init.jspf")) {
            boolean compressImports;
            int x = newContent.indexOf("<%@ page import=");
            int y = newContent.lastIndexOf("<%@ page import=");
            y = newContent.indexOf("%>", y);
            if (x != -1 && y != -1 && y > x && (compressImports = true)) {
                String imports = newContent.substring(x, y);
                imports = StringUtil.replace((String)imports, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "}, (String[])new String[]{"%><%@\r\n", "%><%@\n"});
                newContent = String.valueOf(newContent.substring(0, x)) + imports + newContent.substring(y);
            }
        }
        newContent = this.fixSessionKey(fileName, newContent, sessionKeyPattern);
        newContent = this.fixSessionKey(fileName, newContent, taglibSessionKeyPattern);
        this.checkLanguageKeys(fileName, newContent, languageKeyPattern);
        this.checkLanguageKeys(fileName, newContent, this._taglibLanguageKeyPattern);
        this.checkXSS(fileName, newContent);
        if (this.isAutoFix() && newContent != null && !content.equals(newContent)) {
            fileUtil.write(file, newContent);
            sourceFormatterHelper.printError(fileName, file);
        }
        return newContent;
    }

    protected String formatJSP(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        String previousLine = "";
        String currentAttributeAndValue = null;
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean readAttributes = false;
        String currentException = null;
        String previousException = null;
        boolean hasUnsortedExceptions = false;
        boolean javaSource = false;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String includeFileName;
            Matcher matcher;
            int y;
            int x;
            ++lineCount;
            if (!fileName.contains("jsonw") || !fileName.endsWith("action.jsp")) {
                line = this.trimLine(line, false);
            }
            if (line.contains("<aui:button ") && line.contains("type=\"button\"")) {
                this.processErrorMessage(fileName, "aui:button " + fileName + " " + lineCount);
            }
            String trimmedLine = StringUtil.trimLeading((String)line);
            String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
            this.checkStringBundler(trimmedLine, fileName, lineCount);
            if (trimmedLine.equals("<%") || trimmedLine.equals("<%!")) {
                javaSource = true;
            } else if (trimmedLine.equals("%>")) {
                javaSource = false;
            }
            if (javaSource || trimmedLine.contains("<%= ")) {
                this.checkInefficientStringMethods(line, fileName, lineCount);
            }
            if (javaSource && portalSource && !this._jspContents.isEmpty() && this.hasUnusedVariable(fileName, trimmedLine)) {
                this.processErrorMessage(fileName, "Unused variable: " + fileName + " " + lineCount);
            }
            if (!trimmedLine.equals("%>") && line.contains("%>") && !line.contains("--%>") && !line.contains(" %>")) {
                line = StringUtil.replace((String)line, (String)"%>", (String)" %>");
            }
            if (line.contains("<%=") && !line.contains("<%= ")) {
                line = StringUtil.replace((String)line, (String)"<%=", (String)"<%= ");
            }
            if (trimmedPreviousLine.equals("%>") && Validator.isNotNull((String)line) && !trimmedLine.equals("-->")) {
                sb.append("\n");
            } else if (Validator.isNotNull((String)previousLine) && !trimmedPreviousLine.equals("<!--") && trimmedLine.equals("<%")) {
                sb.append("\n");
            } else {
                String lineBeforePreviousLine;
                if (trimmedPreviousLine.equals("<%") && Validator.isNull((String)line)) continue;
                if (trimmedPreviousLine.equals("<%") && trimmedLine.startsWith("//")) {
                    sb.append("\n");
                } else if (Validator.isNull((String)previousLine) && trimmedLine.equals("%>") && sb.index() > 2 && !(lineBeforePreviousLine = sb.stringAt(sb.index() - 3)).startsWith("//")) {
                    sb.setIndex(sb.index() - 1);
                }
            }
            if ((trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (")) && trimmedLine.endsWith(") {")) {
                this.checkIfClauseParentheses(trimmedLine, fileName, lineCount);
            }
            if (readAttributes) {
                if (!trimmedLine.startsWith("/") && !trimmedLine.startsWith(">")) {
                    int pos = trimmedLine.indexOf("=");
                    if (pos != -1) {
                        String attribute = trimmedLine.substring(0, pos);
                        if (!trimmedLine.endsWith("\"") && !trimmedLine.endsWith("'")) {
                            this.processErrorMessage(fileName, "attribute: " + fileName + " " + lineCount);
                            readAttributes = false;
                        } else if (trimmedLine.endsWith("'") && !trimmedLine.contains("\"")) {
                            line = StringUtil.replace((String)line, (String)"'", (String)"\"");
                            readAttributes = false;
                        } else if (Validator.isNotNull(previousAttribute)) {
                            if (!this.isJSPAttributName(attribute)) {
                                this.processErrorMessage(fileName, "attribute: " + fileName + " " + lineCount);
                                readAttributes = false;
                            } else if (Validator.isNull(previousAttributeAndValue) && previousAttribute.compareTo(attribute) > 0) {
                                previousAttributeAndValue = previousLine;
                                currentAttributeAndValue = line;
                            }
                        }
                        if (!readAttributes) {
                            previousAttribute = null;
                            previousAttributeAndValue = null;
                        } else {
                            previousAttribute = attribute;
                        }
                    }
                } else {
                    previousAttribute = null;
                    readAttributes = false;
                }
            }
            if (!hasUnsortedExceptions) {
                int i2 = line.indexOf("<liferay-ui:error exception=\"<%=");
                if (i2 != -1) {
                    currentException = line.substring(i2 + 33);
                    if (Validator.isNotNull((String)previousException) && previousException.compareTo(currentException) > 0) {
                        hasUnsortedExceptions = true;
                    }
                }
                if (!hasUnsortedExceptions) {
                    previousException = currentException;
                    currentException = null;
                }
            }
            if (trimmedLine.startsWith("<") && !trimmedLine.startsWith("<%") && !trimmedLine.startsWith("<!")) {
                if (!trimmedLine.contains(">") && !trimmedLine.contains(" ")) {
                    readAttributes = true;
                } else {
                    line = this.sortJSPAttributes(fileName, line, lineCount);
                }
            }
            if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.endsWith(".vm")) {
                    line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                }
            }
            if (!fileName.endsWith("/touch.jsp") && (x = line.indexOf("<%@ include file")) != -1 && (y = line.indexOf("\"", (x = line.indexOf("\"", x)) + 1)) != -1 && !(matcher = this._jspIncludeFilePattern.matcher(includeFileName = line.substring(x + 1, y))).find()) {
                this.processErrorMessage(fileName, "include: " + fileName + " " + lineCount);
            }
            previousLine = line = this.replacePrimitiveWrapperInstantiation(fileName, line, lineCount);
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        content = this.formatTaglibQuotes(fileName, content, "\"");
        content = this.formatTaglibQuotes(fileName, content, "'");
        if (Validator.isNotNull(previousAttributeAndValue)) {
            content = StringUtil.replaceFirst((String)content, (String)(String.valueOf(previousAttributeAndValue) + "\n" + currentAttributeAndValue), (String)(String.valueOf(currentAttributeAndValue) + "\n" + previousAttributeAndValue));
        }
        if (hasUnsortedExceptions) {
            if (StringUtil.count((String)content, currentException) > 1 || StringUtil.count((String)content, previousException) > 1) {
                this.processErrorMessage(fileName, "unsorted exceptions: " + fileName);
            } else {
                content = StringUtil.replaceFirst((String)content, previousException, currentException);
                content = StringUtil.replaceLast((String)content, currentException, previousException);
            }
        }
        return content;
    }

    protected String formatTaglibQuotes(String fileName, String content, String quoteType) {
        String quoteFix = "'";
        if (quoteFix.equals(quoteType)) {
            quoteFix = "\"";
        }
        Pattern pattern = Pattern.compile(this.getTaglibRegex(quoteType));
        Matcher matcher = pattern.matcher(content);
        block0: while (matcher.find()) {
            int x = content.indexOf(String.valueOf(quoteType) + "<%=", matcher.start());
            int y = content.indexOf("%>" + quoteType, x);
            while (x != -1 && y != -1) {
                String result = content.substring(x + 1, y + 2);
                if (result.contains(quoteType)) {
                    int lineCount = 1;
                    char[] contentCharArray = content.toCharArray();
                    int i2 = 0;
                    while (i2 < x) {
                        if (contentCharArray[i2] == '\n') {
                            ++lineCount;
                        }
                        ++i2;
                    }
                    if (!result.contains(quoteFix)) {
                        StringBundler sb = new StringBundler(5);
                        sb.append(content.substring(0, x));
                        sb.append(quoteFix);
                        sb.append(result);
                        sb.append(quoteFix);
                        sb.append(content.substring(y + 3, content.length()));
                        content = sb.toString();
                    } else {
                        this.processErrorMessage(fileName, "taglib: " + fileName + " " + lineCount);
                    }
                }
                if ((x = content.indexOf(String.valueOf(quoteType) + "<%=", y)) > matcher.end()) continue block0;
                y = content.indexOf("%>" + quoteType, x);
            }
        }
        return content;
    }

    protected List<String> getJSPDuplicateImports(String fileName, String content, List<String> importLines) {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 || x >= y || !this.isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    protected String getTaglibRegex(String quoteType) {
        StringBuilder sb = new StringBuilder();
        sb.append("<(");
        int i2 = 0;
        while (i2 < _TAG_LIBRARIES.length) {
            sb.append(_TAG_LIBRARIES[i2]);
            sb.append("|");
            ++i2;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("):([^>]|%>)*");
        sb.append(quoteType);
        sb.append("<%=.*");
        sb.append(quoteType);
        sb.append(".*%>");
        sb.append(quoteType);
        sb.append("([^>]|%>)*>");
        return sb.toString();
    }

    protected String getVariableName(String line) {
        if (!line.endsWith(";") || line.startsWith("//")) {
            return null;
        }
        String variableName = null;
        int x = line.indexOf(" = ");
        if (x == -1) {
            int y = line.lastIndexOf(" ");
            if (y != -1) {
                variableName = line.substring(y + 1, line.length() - 1);
            }
        } else {
            int y = (line = line.substring(0, x)).lastIndexOf(" ");
            if (y != -1) {
                variableName = line.substring(y + 1);
            }
        }
        if (Validator.isVariableName(variableName)) {
            return variableName;
        }
        return null;
    }

    protected boolean hasUnusedVariable(String fileName, String line) {
        if (line.contains(": ")) {
            return false;
        }
        String variableName = this.getVariableName(line);
        if (Validator.isNull((String)variableName) || variableName.equals("false") || variableName.equals("true")) {
            return false;
        }
        HashSet<String> includeFileNames = new HashSet<String>();
        includeFileNames.add(fileName);
        HashSet<String> checkedFileNames = new HashSet<String>();
        return !this.isClassOrVariableRequired(fileName, variableName, includeFileNames, checkedFileNames);
    }

    protected boolean isClassOrVariableRequired(String fileName, String name, Set<String> includeFileNames, Set<String> checkedFileNames) {
        String[] includeFileNamesArray;
        if (checkedFileNames.contains(fileName)) {
            return false;
        }
        checkedFileNames.add(fileName);
        String content = this._jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[^A-Za-z0-9_]" + name + "[^A-Za-z0-9_]");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find() && (checkedFileNames.size() > 1 || matcher.find())) {
            return true;
        }
        this.addJSPIncludeFileNames(fileName, includeFileNames);
        String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
        fileName = fileName.replaceFirst(docrootPath, "");
        if (fileName.endsWith("init.jsp") || fileName.endsWith("init.jspf") || fileName.contains("init-ext.jsp")) {
            this.addJSPReferenceFileNames(fileName, includeFileNames);
        }
        String[] stringArray = includeFileNamesArray = includeFileNames.toArray(new String[includeFileNames.size()]);
        int n = includeFileNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String includeFileName = stringArray[n2];
            if (!checkedFileNames.contains(includeFileName) && this.isClassOrVariableRequired(includeFileName, name, includeFileNames, checkedFileNames)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isJSPAttributName(String attributeName) {
        if (Validator.isNull((String)attributeName)) {
            return false;
        }
        Matcher matcher = this._jspAttributeNamePattern.matcher(attributeName);
        return matcher.matches();
    }

    protected boolean isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) {
        String content = this._jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf("\"", y)) == -1) {
            return false;
        }
        int z = content.indexOf("\"", y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
        includeFileName = String.valueOf(docrootPath) + includeFileName;
        return this.isJSPDuplicateImport(includeFileName, importLine, true);
    }

    protected void moveFrequentlyUsedImportsToCommonInit(int minCount) throws IOException {
        String commonInitFileName = "portal-web/docroot/html/common/init.jsp";
        File commonInitFile = null;
        String commonInitFileContent = null;
        int x = -1;
        for (Map.Entry<String, Integer> importCount : this._importCountMap.entrySet()) {
            int y;
            String importName;
            String importClassName;
            Integer count = importCount.getValue();
            if (count < minCount || this._duplicateImportClassNames.contains(importClassName = (importName = importCount.getKey()).substring((y = importName.lastIndexOf(".")) + 1))) continue;
            if (commonInitFileContent == null) {
                commonInitFile = new File(commonInitFileName);
                commonInitFileContent = fileUtil.read(commonInitFile);
                x = commonInitFileContent.indexOf("<%@ page import");
            }
            commonInitFileContent = StringUtil.insert((String)commonInitFileContent, (String)("<%@ page import=\"" + importName + "\" %>\n"), (int)x);
        }
        if (commonInitFileContent != null) {
            fileUtil.write(commonInitFile, commonInitFileContent);
            this._jspContents.put(commonInitFileName, commonInitFileContent);
        }
    }

    protected String sortJSPAttributes(String fileName, String line, int lineCount) {
        String s = line;
        int x = s.indexOf(" ");
        if (x == -1) {
            return line;
        }
        s = s.substring(x + 1);
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean wrongOrder = false;
        x = 0;
        while ((x = s.indexOf("=")) != -1 && s.length() > x + 1) {
            int lessThanCount;
            int greaterThanCount;
            int startJavaCodeSignCount;
            int endJavaCodeSignCount;
            char delimeter;
            String attribute = s.substring(0, x);
            if (!this.isJSPAttributName(attribute)) {
                return line;
            }
            if (Validator.isNotNull(previousAttribute) && previousAttribute.compareTo(attribute) > 0) {
                wrongOrder = true;
            }
            if ((delimeter = (s = s.substring(x + 1)).charAt(0)) != '\'' && delimeter != '\"') {
                this.processErrorMessage(fileName, "delimeter: " + fileName + " " + lineCount);
                return line;
            }
            s = s.substring(1);
            String value = null;
            int y = -1;
            do {
                if ((y = s.indexOf(delimeter, y + 1)) != -1 && s.length() > y + 1) continue;
                return line;
            } while (!((value = s.substring(0, y)).startsWith("<%") ? (endJavaCodeSignCount = StringUtil.count((String)value, (String)"%>")) == (startJavaCodeSignCount = StringUtil.count((String)value, (String)"<%")) : (greaterThanCount = StringUtil.count((String)value, (String)">")) == (lessThanCount = StringUtil.count((String)value, (String)"<"))));
            if (delimeter == '\'' && !value.contains("\"")) {
                return StringUtil.replace((String)line, (String)("'" + value + "'"), (String)("\"" + value + "\""));
            }
            StringBundler sb = new StringBundler(5);
            sb.append(attribute);
            sb.append("=");
            sb.append(delimeter);
            sb.append(value);
            sb.append(delimeter);
            String currentAttributeAndValue = sb.toString();
            if (wrongOrder) {
                if (StringUtil.count((String)line, (String)currentAttributeAndValue) == 1 && StringUtil.count((String)line, previousAttributeAndValue) == 1) {
                    line = StringUtil.replaceFirst((String)line, (String)previousAttributeAndValue, (String)currentAttributeAndValue);
                    line = StringUtil.replaceLast((String)line, (String)currentAttributeAndValue, (String)previousAttributeAndValue);
                }
                return line;
            }
            s = s.substring(y + 1);
            s = StringUtil.trimLeading((String)s);
            previousAttribute = attribute;
            previousAttributeAndValue = currentAttributeAndValue;
        }
        return line;
    }

    protected String stripJSPImports(String fileName, String content) throws IOException {
        String afterImports;
        if (!(fileName = fileName.replace('\\', '/')).contains("docroot") || fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = this._jspImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        imports = StringUtil.replace((String)imports, (String[])new String[]{"%><%@\r\n", "%><%@\n"}, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "});
        if (!fileName.endsWith("html/common/init.jsp") && !fileName.endsWith("html/portal/init.jsp")) {
            ArrayList<String> importLines = new ArrayList<String>();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (!line.contains("import=")) continue;
                importLines.add(line);
            }
            List<String> unneededImports = this.getJSPDuplicateImports(fileName, content, importLines);
            this.addJSPUnusedImports(fileName, importLines, unneededImports);
            for (String unneededImport : unneededImports) {
                imports = StringUtil.replace((String)imports, (String)unneededImport, (String)"");
            }
        }
        imports = JSPSourceProcessor.formatImports(imports, 17);
        String beforeImports = content.substring(0, matcher.start());
        if (Validator.isNull((String)imports)) {
            beforeImports = StringUtil.replaceLast((String)beforeImports, (String)"\n", (String)"");
        }
        if (Validator.isNull((String)(afterImports = content.substring(matcher.end())))) {
            imports = StringUtil.replaceLast((String)imports, (String)"\n", (String)"");
            content = String.valueOf(beforeImports) + imports;
            return content;
        }
        content = String.valueOf(beforeImports) + imports + "\n" + afterImports;
        return content;
    }
}

