/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ComparableRoute;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import com.liferay.util.ContentUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLSourceProcessor
extends BaseSourceProcessor {
    private static Pattern _commentPattern1 = Pattern.compile(">\n\t+<!--[\n ]");
    private static Pattern _commentPattern2 = Pattern.compile("[\t ]-->\n[\t<]");

    public static String formatXML(String content) {
        String newContent = StringUtil.replace((String)content, (String)"\"/>\n", (String)"\" />\n");
        while (true) {
            Matcher matcher;
            if ((matcher = _commentPattern1.matcher(newContent)).find()) {
                newContent = StringUtil.replaceFirst((String)newContent, (String)">\n", (String)">\n\n", (int)matcher.start());
                continue;
            }
            matcher = _commentPattern2.matcher(newContent);
            if (!matcher.find()) break;
            newContent = StringUtil.replaceFirst((String)newContent, (String)"-->\n", (String)"-->\n\n", (int)matcher.start());
        }
        return newContent;
    }

    protected String fixAntXMLProjectName(String fileName, String content) {
        int y;
        String correctProjectElementText;
        int x = 0;
        if (fileName.endsWith("-ext/build.xml")) {
            if (fileName.startsWith("ext/")) {
                x = 4;
            }
        } else if (fileName.endsWith("-hook/build.xml")) {
            if (fileName.startsWith("hooks/")) {
                x = 6;
            }
        } else if (fileName.endsWith("-layouttpl/build.xml")) {
            if (fileName.startsWith("layouttpl/")) {
                x = 10;
            }
        } else if (fileName.endsWith("-portlet/build.xml")) {
            if (fileName.startsWith("portlets/")) {
                x = 9;
            }
        } else if (fileName.endsWith("-theme/build.xml")) {
            if (fileName.startsWith("themes/")) {
                x = 7;
            }
        } else if (fileName.endsWith("-web/build.xml") && !fileName.endsWith("/ext-web/build.xml")) {
            if (fileName.startsWith("webs/")) {
                x = 5;
            }
        } else {
            return content;
        }
        if (!content.contains(correctProjectElementText = "<project name=\"" + fileName.substring(x, y = fileName.indexOf("/", x)) + "\"")) {
            x = content.indexOf("<project name=\"");
            y = content.indexOf("\"", x) + 1;
            y = content.indexOf("\"", y) + 1;
            content = String.valueOf(content.substring(0, x)) + correctProjectElementText + content.substring(y);
            this.processErrorMessage(fileName, String.valueOf(fileName) + " has an incorrect project name");
        }
        return content;
    }

    @Override
    protected void format() throws Exception {
        String[] excludes = new String[]{"**\\.idea\\**", "**\\bin\\**", "**\\classes\\**"};
        String[] includes = new String[]{"**\\*.xml"};
        Properties exclusions = this.getExclusionsProperties("source_formatter_xml_exclusions.properties");
        List<String> fileNames = this.getFileNames(excludes, includes);
        for (String fileName : fileNames) {
            String content;
            File file = new File("./" + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            if (exclusions != null && exclusions.getProperty(fileName) != null) continue;
            String newContent = content = fileUtil.read(file);
            if (!fileName.contains("/build")) {
                newContent = this.trimContent(newContent, false);
            }
            if (fileName.contains("/build") && !fileName.contains("/tools/")) {
                newContent = this.formatAntXML(fileName, newContent);
            } else if (fileName.endsWith("structures.xml")) {
                newContent = this.formatDDLStructuresXML(newContent);
            } else if (fileName.endsWith("routes.xml")) {
                newContent = this.formatFriendlyURLRoutesXML(fileName, newContent);
            } else if (portalSource && fileName.endsWith("/portlet-custom.xml") || !portalSource && fileName.endsWith("/portlet.xml")) {
                newContent = this.formatPortletXML(newContent);
            } else if (portalSource && fileName.endsWith("/service.xml")) {
                this.formatServiceXML(fileName, newContent);
            } else if (portalSource && fileName.endsWith("/struts-config.xml")) {
                this.formatStrutsConfigXML(fileName, content);
            } else if (portalSource && fileName.endsWith("/tiles-defs.xml")) {
                this.formatTilesDefsXML(fileName, content);
            } else if (portalSource && fileName.endsWith("WEB-INF/web.xml") || !portalSource && fileName.endsWith("/web.xml")) {
                newContent = this.formatWebXML(fileName, content);
            }
            newContent = XMLSourceProcessor.formatXML(newContent);
            if (!this.isAutoFix() || newContent == null || content.equals(newContent)) continue;
            fileUtil.write(file, newContent);
            sourceFormatterHelper.printError(fileName, file);
        }
    }

    protected String formatAntXML(String fileName, String content) throws DocumentException, IOException {
        String newContent = this.trimContent(content, true);
        newContent = this.fixAntXMLProjectName(fileName, newContent);
        Document document = saxReaderUtil.read(newContent);
        Element rootElement = document.getRootElement();
        String previousName = "";
        List targetElements = rootElement.elements("target");
        for (Element targetElement : targetElements) {
            String name = targetElement.attributeValue("name");
            if (name.equals("Test")) {
                name = name.toLowerCase();
            }
            if (name.compareTo(previousName) < -1) {
                this.processErrorMessage(fileName, String.valueOf(fileName) + " has an unordered target " + name);
                break;
            }
            previousName = name;
        }
        return newContent;
    }

    protected String formatDDLStructuresXML(String content) throws DocumentException, IOException {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        rootElement.sortElementsByChildElement("structure", "name");
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            Element structureRootElement = structureElement.element("root");
            structureRootElement.sortElementsByAttribute("dynamic-element", "name");
            List dynamicElementElements = structureRootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                Element metaDataElement = dynamicElementElement.element("meta-data");
                metaDataElement.sortElementsByAttribute("entry", "name");
            }
        }
        return document.formattedString();
    }

    protected String formatFriendlyURLRoutesXML(String fileName, String content) throws DocumentException, IOException {
        Properties friendlyUrlRoutesSortExclusions = this.getExclusionsProperties("source_formatter_friendly_url_routes_sort_exclusions.properties");
        String excluded = null;
        if (friendlyUrlRoutesSortExclusions != null) {
            excluded = friendlyUrlRoutesSortExclusions.getProperty(fileName);
        }
        if (excluded != null) {
            return content;
        }
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        ArrayList<ComparableRoute> comparableRoutes = new ArrayList<ComparableRoute>();
        for (Element routeElement : rootElement.elements("route")) {
            Object value;
            String pattern = routeElement.elementText("pattern");
            ComparableRoute comparableRoute = new ComparableRoute(pattern);
            for (Element element : routeElement.elements("generated-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addGeneratedParameter(string, (String)value);
            }
            for (Element element : routeElement.elements("ignored-parameter")) {
                String string = element.attributeValue("name");
                comparableRoute.addIgnoredParameter(string);
            }
            for (Element element : routeElement.elements("implicit-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addImplicitParameter(string, (String)value);
            }
            for (Element element : routeElement.elements("overridden-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addOverriddenParameter(string, (String)value);
            }
            comparableRoutes.add(comparableRoute);
        }
        Collections.sort(comparableRoutes);
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE routes PUBLIC \"-//Liferay//DTD Friendly URL ");
        sb.append("Routes ");
        sb.append(mainReleaseVersion);
        sb.append("//EN\" \"http://www.liferay.com/dtd/");
        sb.append("liferay-friendly-url-routes_");
        sb.append(StringUtil.replace((String)mainReleaseVersion, (String)".", (String)"_"));
        sb.append(".dtd\">\n\n<routes>\n");
        for (ComparableRoute comparableRoute : comparableRoutes) {
            sb.append("\t<route>\n");
            sb.append("\t\t<pattern>");
            sb.append(comparableRoute.getPattern());
            sb.append("</pattern>\n");
            Map<String, String> generatedParameters = comparableRoute.getGeneratedParameters();
            for (Map.Entry entry : generatedParameters.entrySet()) {
                sb.append("\t\t<generated-parameter name=\"");
                sb.append((String)entry.getKey());
                sb.append("\">");
                sb.append((String)entry.getValue());
                sb.append("</generated-parameter>\n");
            }
            Set<String> set = comparableRoute.getIgnoredParameters();
            for (String entry : set) {
                sb.append("\t\t<ignored-parameter name=\"");
                sb.append(entry);
                sb.append("\" />\n");
            }
            Map<String, String> implicitParameters = comparableRoute.getImplicitParameters();
            for (Map.Entry entry : implicitParameters.entrySet()) {
                sb.append("\t\t<implicit-parameter name=\"");
                sb.append((String)entry.getKey());
                sb.append("\">");
                sb.append((String)entry.getValue());
                sb.append("</implicit-parameter>\n");
            }
            Map<String, String> map = comparableRoute.getOverriddenParameters();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                sb.append("\t\t<overridden-parameter name=\"");
                sb.append(entry.getKey());
                sb.append("\">");
                sb.append(entry.getValue());
                sb.append("</overridden-parameter>\n");
            }
            sb.append("\t</route>\n");
        }
        sb.append("</routes>");
        return sb.toString();
    }

    protected String formatPortletXML(String content) throws DocumentException, IOException {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            portletElement.sortElementsByChildElement("init-param", "name");
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            if (portletPreferencesElement == null) continue;
            portletPreferencesElement.sortElementsByChildElement("preference", "name");
        }
        return document.formattedString();
    }

    protected void formatServiceXML(String fileName, String content) throws DocumentException {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        List entityElements = rootElement.elements("entity");
        String previousEntityName = "";
        for (Element entityElement : entityElements) {
            String entityName = entityElement.attributeValue("name");
            if (Validator.isNotNull((String)previousEntityName) && previousEntityName.compareToIgnoreCase(entityName) > 0) {
                this.processErrorMessage(fileName, "sort: " + fileName + " " + entityName);
            }
            String previousReferenceEntity = "";
            String previousReferencePackagePath = "";
            List referenceElements = entityElement.elements("reference");
            for (Element referenceElement : referenceElements) {
                String referenceEntity = referenceElement.attributeValue("entity");
                String referencePackagePath = referenceElement.attributeValue("package-path");
                if (Validator.isNotNull((String)previousReferencePackagePath) && (previousReferencePackagePath.compareToIgnoreCase(referencePackagePath) > 0 || previousReferencePackagePath.equals(referencePackagePath) && previousReferenceEntity.compareToIgnoreCase(referenceEntity) > 0)) {
                    this.processErrorMessage(fileName, "sort: " + fileName + " " + referencePackagePath);
                }
                previousReferenceEntity = referenceEntity;
                previousReferencePackagePath = referencePackagePath;
            }
            previousEntityName = entityName;
        }
        Element exceptionsElement = rootElement.element("exceptions");
        if (exceptionsElement == null) {
            return;
        }
        List exceptionElements = exceptionsElement.elements("exception");
        String previousException = "";
        for (Element exceptionElement : exceptionElements) {
            String exception = exceptionElement.getStringValue();
            if (Validator.isNotNull((String)previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                this.processErrorMessage(fileName, "sort: " + fileName + " " + exception);
            }
            previousException = exception;
        }
    }

    protected void formatStrutsConfigXML(String fileName, String content) throws DocumentException {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        Element actionMappingsElement = rootElement.element("action-mappings");
        List actionElements = actionMappingsElement.elements("action");
        String previousPath = "";
        for (Element actionElement : actionElements) {
            String path = actionElement.attributeValue("path");
            if (Validator.isNotNull((String)previousPath) && previousPath.compareTo(path) > 0 && (!previousPath.startsWith("/portal/") || path.startsWith("/portal/"))) {
                this.processErrorMessage(fileName, "sort: " + fileName + " " + path);
            }
            previousPath = path;
        }
    }

    protected void formatTilesDefsXML(String fileName, String content) throws DocumentException {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        List definitionElements = rootElement.elements("definition");
        String previousName = "";
        for (Element definitionElement : definitionElements) {
            String name = definitionElement.attributeValue("name");
            if (Validator.isNotNull((String)previousName) && previousName.compareTo(name) > 0 && !previousName.equals("portlet")) {
                this.processErrorMessage(fileName, "sort: " + fileName + " " + name);
            }
            previousName = name;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String formatWebXML(String fileName, String content) throws IOException {
        void var8_13;
        if (!portalSource) {
            String webXML = ContentUtil.get((String)"com/liferay/portal/deploy/dependencies/web.xml");
            if (content.equals(webXML)) {
                this.processErrorMessage(fileName, fileName);
            }
            return content;
        }
        Properties properties = new Properties();
        String propertiesContent = fileUtil.read("./portal-impl/src/portal.properties");
        PropertiesUtil.load((Properties)properties, (String)propertiesContent);
        Object[] locales = StringUtil.split((String)properties.getProperty("locales"));
        Arrays.sort(locales);
        TreeSet<Object> urlPatterns = new TreeSet<Object>();
        Object[] objectArray = locales;
        int n = locales.length;
        boolean n2 = false;
        while (var8_13 < n) {
            Object locale = objectArray[var8_13];
            int n3 = ((String)locale).indexOf("_");
            String languageCode = ((String)locale).substring(0, n3);
            urlPatterns.add(languageCode);
            urlPatterns.add(locale);
            ++var8_13;
        }
        StringBundler sb = new StringBundler();
        for (String string : urlPatterns) {
            sb.append("\t<servlet-mapping>\n");
            sb.append("\t\t<servlet-name>I18n Servlet</servlet-name>\n");
            sb.append("\t\t<url-pattern>/");
            sb.append(string);
            sb.append("/*</url-pattern>\n");
            sb.append("\t</servlet-mapping>\n");
        }
        int n6 = content.indexOf("<servlet-mapping>");
        n6 = content.indexOf("<servlet-name>I18n Servlet</servlet-name>", n6);
        n6 = content.lastIndexOf("<servlet-mapping>", n6) - 1;
        int y = content.lastIndexOf("<servlet-name>I18n Servlet</servlet-name>");
        y = content.indexOf("</servlet-mapping>", y) + 19;
        String newContent = String.valueOf(content.substring(0, n6)) + sb.toString() + content.substring(y);
        int n9 = newContent.indexOf("<security-constraint>");
        n9 = newContent.indexOf("<web-resource-name>/c/portal/protected</web-resource-name>", n9);
        n9 = newContent.indexOf("<url-pattern>", n9) - 3;
        y = newContent.indexOf("<http-method>", n9);
        y = newContent.lastIndexOf("</url-pattern>", y) + 15;
        sb = new StringBundler();
        sb.append("\t\t\t<url-pattern>/c/portal/protected</url-pattern>\n");
        for (String string : urlPatterns) {
            sb.append("\t\t\t<url-pattern>/");
            sb.append(string);
            sb.append("/c/portal/protected</url-pattern>\n");
        }
        return String.valueOf(newContent.substring(0, n9)) + sb.toString() + newContent.substring(y);
    }
}

