/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.PermissionedModel;
import com.liferay.portal.model.ResourceBlock;
import com.liferay.portal.model.ResourceBlockPermissionsContainer;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public class UpgradePermission
extends UpgradeProcess {
    private static final int[] _SCOPES = new int[]{1, 2, 3};
    private static Log _log = LogFactoryUtil.getLog(UpgradePermission.class);

    protected ResourceBlock convertResourcePermissions(String tableName, String pkColumnName, long companyId, long groupId, String name, long primKey) throws SystemException {
        UpgradePermissionedModel permissionedModel = new UpgradePermissionedModel(tableName, pkColumnName, primKey);
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = this.getResourceBlockPermissionsContainer(companyId, groupId, name, primKey);
        String permissionsHash = resourceBlockPermissionsContainer.getPermissionsHash();
        ResourceBlock resourceBlock = ResourceBlockLocalServiceUtil.updateResourceBlockId((long)companyId, (long)groupId, (String)name, (PermissionedModel)permissionedModel, (String)permissionsHash, (ResourceBlockPermissionsContainer)resourceBlockPermissionsContainer);
        return resourceBlock;
    }

    protected void convertResourcePermissions(String name, String tableName, String pkColumnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + pkColumnName + ", groupId, companyId from " + tableName);
            rs = ps.executeQuery();
            while (rs.next()) {
                long primKey = rs.getLong(pkColumnName);
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                ResourceBlock resourceBlock = this.convertResourcePermissions(tableName, pkColumnName, companyId, groupId, name, primKey);
                if (!_log.isInfoEnabled() || resourceBlock.getResourceBlockId() % 100L != 0L) continue;
                _log.info((Object)("Processed 100 resource blocks for " + name));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getScopeResourcePermissions((int[])_SCOPES);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            int scope = resourcePermission.getScope();
            if (!name.equals(resourcePermission.getName())) continue;
            if (scope == 1 || scope == 3) {
                ResourceBlockLocalServiceUtil.setCompanyScopePermissions((long)resourcePermission.getCompanyId(), (String)name, (long)resourcePermission.getRoleId(), (long)resourcePermission.getActionIds());
                continue;
            }
            if (scope != 2) continue;
            ResourceBlockLocalServiceUtil.setGroupScopePermissions((long)resourcePermission.getCompanyId(), (long)GetterUtil.getLong((Object)resourcePermission.getPrimaryKey()), (String)name, (long)resourcePermission.getRoleId(), (long)resourcePermission.getActionIds());
        }
    }

    protected void doUpgrade() throws Exception {
        List modelActions = ResourceActionsUtil.getModelResourceActions((String)Role.class.getName());
        ResourceActionLocalServiceUtil.checkResourceActions((String)Role.class.getName(), (List)modelActions);
        RoleLocalServiceUtil.checkSystemRoles();
        this.updatePermissions("com.liferay.portlet.bookmarks", true, true);
        this.updatePermissions("com.liferay.portlet.documentlibrary", false, true);
        this.updatePermissions("com.liferay.portlet.imagegallery", true, true);
        this.updatePermissions("com.liferay.portlet.messageboards", true, true);
        this.updatePermissions("com.liferay.portlet.shopping", true, true);
        this.convertResourcePermissions(BookmarksEntry.class.getName(), "BookmarksEntry", "entryId");
        this.convertResourcePermissions(BookmarksFolder.class.getName(), "BookmarksFolder", "folderId");
    }

    protected ResourceBlockPermissionsContainer getResourceBlockPermissionsContainer(long companyId, long groupId, String name, long primKey) throws SystemException {
        ResourceBlockPermissionsContainer resourceBlockPermissionContainer = new ResourceBlockPermissionsContainer();
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getResourceResourcePermissions((long)companyId, (long)groupId, (String)name, (String)String.valueOf(primKey));
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourceBlockPermissionContainer.addPermission(resourcePermission.getRoleId(), resourcePermission.getActionIds());
        }
        return resourceBlockPermissionContainer;
    }

    protected void updatePermissions(String name, boolean community, boolean guest) throws Exception {
        List modelActions = ResourceActionsUtil.getModelResourceActions((String)name);
        ResourceActionLocalServiceUtil.checkResourceActions((String)name, (List)modelActions);
        int scope = 4;
        long actionIdsLong = 1L;
        if (community) {
            ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Organization User", (int)scope, (long)actionIdsLong);
            ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Site Member", (int)scope, (long)actionIdsLong);
        }
        if (guest) {
            ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Guest", (int)scope, (long)actionIdsLong);
        }
        ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Owner", (int)scope, (long)actionIdsLong);
    }

    private class UpgradePermissionedModel
    implements PermissionedModel {
        private String _pkColumnName;
        private long _primKey;
        private long _resourceBlockId;
        private String _tableName;

        public UpgradePermissionedModel(String tableName, String pkColumnName, long primKey) {
            this._pkColumnName = pkColumnName;
            this._primKey = primKey;
            this._tableName = tableName;
        }

        public long getResourceBlockId() {
            return this._resourceBlockId;
        }

        public void persist() throws SystemException {
            try {
                StringBundler sb = new StringBundler(8);
                sb.append("update ");
                sb.append(this._tableName);
                sb.append(" set resourceBlockId = ");
                sb.append(this._resourceBlockId);
                sb.append(" where ");
                sb.append(this._pkColumnName);
                sb.append(" = ");
                sb.append(this._primKey);
                UpgradePermission.this.runSQL(sb.toString());
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }

        public void setResourceBlockId(long resourceBlockId) {
            this._resourceBlockId = resourceBlockId;
        }
    }
}

