/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections.map.ReferenceMap;

@DoPrivileged
public class LocalizationImpl
implements Localization {
    private static final String _AVAILABLE_LOCALES = "available-locales";
    private static final String _DEFAULT_LOCALE = "default-locale";
    private static final String _EMPTY_ROOT_NODE = "<root />";
    private static final String _LANGUAGE_ID = "language-id";
    private static final String _ROOT = "root";
    private static Log _log = LogFactoryUtil.getLog(LocalizationImpl.class);
    private Map<String, Map<Tuple, String>> _cache = new ReferenceMap(1, 0);

    public Object deserialize(JSONObject jsonObject) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = jsonObject.getString(languageId);
            if (Validator.isNotNull((String)value)) {
                map.put(locale, value);
            }
            ++n2;
        }
        return map;
    }

    public String[] getAvailableLanguageIds(Document document) {
        String attributeValue = this._getRootAttributeValue(document, _AVAILABLE_LOCALES, "");
        return StringUtil.split((String)attributeValue);
    }

    public String[] getAvailableLanguageIds(String xml) {
        String attributeValue = this._getRootAttributeValue(xml, _AVAILABLE_LOCALES, "");
        return StringUtil.split((String)attributeValue);
    }

    public Locale getDefaultImportLocale(String className, long classPK, Locale contentDefaultLocale, Locale[] contentAvailableLocales) {
        Object[] availableLocales = LanguageUtil.getAvailableLocales();
        if (ArrayUtil.contains((Object[])availableLocales, (Object)contentDefaultLocale)) {
            return contentDefaultLocale;
        }
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        if (ArrayUtil.contains((Object[])contentAvailableLocales, (Object)defaultLocale)) {
            return defaultLocale;
        }
        Locale[] localeArray = contentAvailableLocales;
        int n = contentAvailableLocales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale contentAvailableLocale = localeArray[n2];
            if (ArrayUtil.contains((Object[])availableLocales, (Object)contentAvailableLocale)) {
                return contentAvailableLocale;
            }
            ++n2;
        }
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(9);
            sb.append("Language ");
            sb.append(LocaleUtil.toLanguageId((Locale)contentDefaultLocale));
            sb.append(" is missing for ");
            sb.append(className);
            sb.append(" with primary key ");
            sb.append(classPK);
            sb.append(". Setting default language to ");
            sb.append(LocaleUtil.toLanguageId((Locale)defaultLocale));
            sb.append(".");
            _log.warn((Object)sb.toString());
        }
        return defaultLocale;
    }

    public String getDefaultLanguageId(Document document) {
        return this.getDefaultLanguageId(document, LocaleUtil.getSiteDefault());
    }

    public String getDefaultLanguageId(Document document, Locale defaultLocale) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        return this._getRootAttributeValue(document, _DEFAULT_LOCALE, defaultLanguageId);
    }

    public String getDefaultLanguageId(String xml) {
        return this.getDefaultLanguageId(xml, LocaleUtil.getSiteDefault());
    }

    public String getDefaultLanguageId(String xml, Locale defaultLocale) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        return this._getRootAttributeValue(xml, _DEFAULT_LOCALE, defaultLanguageId);
    }

    public String getLocalization(String xml, String requestedLanguageId) {
        return this.getLocalization(xml, requestedLanguageId, true);
    }

    public String getLocalization(String xml, String requestedLanguageId, boolean useDefault) {
        String value;
        block34: {
            String systemDefaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            if (!Validator.isXml((String)xml)) {
                if (useDefault || requestedLanguageId.equals(systemDefaultLanguageId)) {
                    return xml;
                }
                return "";
            }
            value = this._getCachedValue(xml, requestedLanguageId, useDefault);
            if (value != null) {
                return value;
            }
            value = "";
            String priorityLanguageId = null;
            Locale requestedLocale = LocaleUtil.fromLanguageId((String)requestedLanguageId);
            if (useDefault && LanguageUtil.isDuplicateLanguageCode((String)requestedLocale.getLanguage())) {
                Locale priorityLocale = LanguageUtil.getLocale((String)requestedLocale.getLanguage());
                if (!requestedLanguageId.equals(priorityLanguageId)) {
                    priorityLanguageId = LocaleUtil.toLanguageId((Locale)priorityLocale);
                }
            }
            XMLStreamReader xmlStreamReader = null;
            ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
            ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
            try {
                try {
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(portalClassLoader);
                    }
                    XMLInputFactory xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory();
                    xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
                    String defaultLanguageId = "";
                    if (xmlStreamReader.hasNext()) {
                        xmlStreamReader.nextTag();
                        defaultLanguageId = xmlStreamReader.getAttributeValue(null, _DEFAULT_LOCALE);
                        if (Validator.isNull((String)defaultLanguageId)) {
                            defaultLanguageId = systemDefaultLanguageId;
                        }
                    }
                    String defaultValue = "";
                    String priorityValue = "";
                    while (xmlStreamReader.hasNext()) {
                        int event = xmlStreamReader.next();
                        if (event == 1) {
                            String languageId = xmlStreamReader.getAttributeValue(null, _LANGUAGE_ID);
                            if (Validator.isNull((String)languageId)) {
                                languageId = defaultLanguageId;
                            }
                            if (!languageId.equals(defaultLanguageId) && !languageId.equals(priorityLanguageId) && !languageId.equals(requestedLanguageId)) continue;
                            String text = xmlStreamReader.getElementText();
                            if (languageId.equals(defaultLanguageId)) {
                                defaultValue = text;
                            }
                            if (languageId.equals(priorityLanguageId)) {
                                priorityValue = text;
                            }
                            if (languageId.equals(requestedLanguageId)) {
                                value = text;
                            }
                            if (!Validator.isNotNull((String)value)) continue;
                            break;
                        }
                        if (event == 8) break;
                    }
                    if (useDefault && Validator.isNotNull((String)priorityLanguageId) && Validator.isNull((String)value) && Validator.isNotNull((String)priorityValue)) {
                        value = priorityValue;
                    }
                    if (useDefault && Validator.isNull((String)value)) {
                        value = defaultValue;
                    }
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
        this._setCachedValue(xml, requestedLanguageId, useDefault, value);
        return value;
    }

    public Map<Locale, String> getLocalizationMap(HttpServletRequest request, String parameter) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String localeParameter = parameter.concat("_").concat(languageId);
            map.put(locale, ParamUtil.getString((HttpServletRequest)request, (String)localeParameter));
            ++n2;
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(PortletPreferences preferences, String parameter) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String localeParameter = parameter.concat("_").concat(languageId);
            map.put(locale, preferences.getValue(localeParameter, ""));
            ++n2;
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(PortletRequest portletRequest, String parameter) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String localeParameter = parameter.concat("_").concat(languageId);
            map.put(locale, ParamUtil.getString((PortletRequest)portletRequest, (String)localeParameter));
            ++n2;
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(String xml) {
        return this.getLocalizationMap(xml, false);
    }

    public Map<Locale, String> getLocalizationMap(String xml, boolean useDefault) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            map.put(locale, this.getLocalization(xml, languageId, useDefault));
            ++n2;
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(String bundleName, ClassLoader classLoader, String key, boolean includeBetaLocales) {
        if (key == null) {
            return null;
        }
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultValue = this._getLocalization(bundleName, defaultLocale, classLoader, key, key);
        map.put(defaultLocale, defaultValue);
        Locale[] locales = null;
        locales = includeBetaLocales ? LanguageUtil.getAvailableLocales() : LanguageUtil.getSupportedLocales();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            Locale locale = localeArray[n2];
            if (!locale.equals(defaultLocale) && Validator.isNotNull((String)(value = this._getLocalization(bundleName, locale, classLoader, key, null))) && !value.equals(defaultValue)) {
                map.put(locale, value);
            }
            ++n2;
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(String[] languageIds, String[] values) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        int i2 = 0;
        while (i2 < values.length) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageIds[i2]);
            map.put(locale, values[i2]);
            ++i2;
        }
        return map;
    }

    public String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter) {
        return this.getLocalizationXmlFromPreferences(preferences, portletRequest, parameter, null);
    }

    public String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter, String defaultValue) {
        String oldValue;
        String xml = "";
        Locale[] locales = LanguageUtil.getAvailableLocales();
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String localizedKey = this.getPreferencesKey(parameter, languageId);
            String value = PrefsParamUtil.getString((PortletPreferences)preferences, (PortletRequest)portletRequest, (String)localizedKey);
            if (Validator.isNotNull((String)value)) {
                xml = this.updateLocalization(xml, parameter, value, languageId);
            }
            ++n2;
        }
        if (Validator.isNull((String)this.getLocalization(xml, defaultLanguageId)) && Validator.isNotNull((String)(oldValue = PrefsParamUtil.getString((PortletPreferences)preferences, (PortletRequest)portletRequest, (String)parameter, (String)defaultValue)))) {
            xml = this.updateLocalization(xml, parameter, oldValue);
        }
        return xml;
    }

    public Map<Locale, String> getLocalizedParameter(PortletRequest portletRequest, String parameter) {
        return this.getLocalizationMap(portletRequest, parameter);
    }

    public String getPreferencesKey(String key, String languageId) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        if (!languageId.equals(defaultLanguageId)) {
            key = String.valueOf(key) + "_" + languageId;
        }
        return key;
    }

    public String getPreferencesValue(PortletPreferences preferences, String key, String languageId) {
        return this.getPreferencesValue(preferences, key, languageId, true);
    }

    public String getPreferencesValue(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        String localizedKey = this.getPreferencesKey(key, languageId);
        String value = preferences.getValue(localizedKey, "");
        if (useDefault && Validator.isNull((String)value)) {
            value = preferences.getValue(key, "");
        }
        return value;
    }

    public String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId) {
        return this.getPreferencesValues(preferences, key, languageId, true);
    }

    public String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        String localizedKey = this.getPreferencesKey(key, languageId);
        Object[] values = preferences.getValues(localizedKey, new String[0]);
        if (useDefault && ArrayUtil.isEmpty((Object[])values)) {
            values = preferences.getValues(key, new String[0]);
        }
        return values;
    }

    public String removeLocalization(String xml, String key, String requestedLanguageId) {
        return this.removeLocalization(xml, key, requestedLanguageId, false);
    }

    public String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata) {
        return this.removeLocalization(xml, key, requestedLanguageId, cdata, true);
    }

    public String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata, boolean localized) {
        block34: {
            if (Validator.isNull((String)xml)) {
                return "";
            }
            if (!Validator.isXml((String)xml)) {
                return xml;
            }
            xml = this._sanitizeXML(xml);
            String systemDefaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            XMLStreamReader xmlStreamReader = null;
            XMLStreamWriter xmlStreamWriter = null;
            ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
            ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
            try {
                try {
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(portalClassLoader);
                    }
                    XMLInputFactory xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory();
                    xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
                    String availableLocales = "";
                    String defaultLanguageId = "";
                    if (xmlStreamReader.hasNext()) {
                        xmlStreamReader.nextTag();
                        availableLocales = xmlStreamReader.getAttributeValue(null, _AVAILABLE_LOCALES);
                        defaultLanguageId = xmlStreamReader.getAttributeValue(null, _DEFAULT_LOCALE);
                        if (Validator.isNull((String)defaultLanguageId)) {
                            defaultLanguageId = systemDefaultLanguageId;
                        }
                    }
                    if (availableLocales != null && availableLocales.contains(requestedLanguageId)) {
                        availableLocales = StringUtil.remove((String)availableLocales, (String)requestedLanguageId, (String)",");
                        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                        xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
                        xmlStreamWriter.writeStartDocument();
                        xmlStreamWriter.writeStartElement(_ROOT);
                        if (localized) {
                            xmlStreamWriter.writeAttribute(_AVAILABLE_LOCALES, availableLocales);
                            xmlStreamWriter.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
                        }
                        this._copyNonExempt(xmlStreamReader, xmlStreamWriter, requestedLanguageId, defaultLanguageId, cdata);
                        xmlStreamWriter.writeEndElement();
                        xmlStreamWriter.writeEndDocument();
                        xmlStreamWriter.close();
                        xmlStreamWriter = null;
                        xml = unsyncStringWriter.toString();
                    }
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (xmlStreamWriter != null) {
                        try {
                            xmlStreamWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (xmlStreamWriter != null) {
                    try {
                        xmlStreamWriter.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        return xml;
    }

    public void setLocalizedPreferencesValues(PortletRequest portletRequest, PortletPreferences preferences, String parameter) throws Exception {
        Map<Locale, String> map = this.getLocalizationMap(portletRequest, parameter);
        for (Map.Entry<Locale, String> entry : map.entrySet()) {
            String languageId = LocaleUtil.toLanguageId((Locale)entry.getKey());
            String value = entry.getValue();
            this.setPreferencesValue(preferences, parameter, languageId, value);
        }
    }

    public void setPreferencesValue(PortletPreferences preferences, String key, String languageId, String value) throws Exception {
        preferences.setValue(this.getPreferencesKey(key, languageId), value);
    }

    public void setPreferencesValues(PortletPreferences preferences, String key, String languageId, String[] values) throws Exception {
        preferences.setValues(this.getPreferencesKey(key, languageId), values);
    }

    public String updateLocalization(Map<Locale, String> localizationMap, String xml, String key, String defaultLanguageId) {
        Locale[] locales;
        Locale[] localeArray = locales = LanguageUtil.getAvailableLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String value = localizationMap.get(locale);
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            xml = Validator.isNotNull((String)value) ? this.updateLocalization(xml, key, value, languageId, defaultLanguageId) : this.removeLocalization(xml, key, languageId);
            ++n2;
        }
        return xml;
    }

    public String updateLocalization(String xml, String key, String value) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.updateLocalization(xml, key, value, defaultLanguageId, defaultLanguageId);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId) {
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, false);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata) {
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, cdata, true);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata, boolean localized) {
        block35: {
            xml = this._sanitizeXML(xml);
            XMLStreamReader xmlStreamReader = null;
            XMLStreamWriter xmlStreamWriter = null;
            ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
            ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
            try {
                try {
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(portalClassLoader);
                    }
                    XMLInputFactory xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory();
                    xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
                    String availableLocales = "";
                    if (xmlStreamReader.hasNext()) {
                        xmlStreamReader.nextTag();
                        availableLocales = xmlStreamReader.getAttributeValue(null, _AVAILABLE_LOCALES);
                        if (Validator.isNull((String)availableLocales)) {
                            availableLocales = defaultLanguageId;
                        }
                        if (!availableLocales.contains(requestedLanguageId)) {
                            availableLocales = StringUtil.add((String)availableLocales, (String)requestedLanguageId, (String)",");
                        }
                    }
                    UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                    XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                    xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
                    xmlStreamWriter.writeStartDocument();
                    xmlStreamWriter.writeStartElement(_ROOT);
                    if (localized) {
                        xmlStreamWriter.writeAttribute(_AVAILABLE_LOCALES, availableLocales);
                        xmlStreamWriter.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
                    }
                    this._copyNonExempt(xmlStreamReader, xmlStreamWriter, requestedLanguageId, defaultLanguageId, cdata);
                    xmlStreamWriter.writeStartElement(key);
                    if (localized) {
                        xmlStreamWriter.writeAttribute(_LANGUAGE_ID, requestedLanguageId);
                    }
                    if (cdata) {
                        xmlStreamWriter.writeCData(value);
                    } else {
                        xmlStreamWriter.writeCharacters(value);
                    }
                    xmlStreamWriter.writeEndElement();
                    xmlStreamWriter.writeEndElement();
                    xmlStreamWriter.writeEndDocument();
                    xmlStreamWriter.close();
                    xmlStreamWriter = null;
                    xml = unsyncStringWriter.toString();
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (xmlStreamWriter != null) {
                        try {
                            xmlStreamWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (xmlStreamWriter != null) {
                    try {
                        xmlStreamWriter.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        return xml;
    }

    private void _copyNonExempt(XMLStreamReader xmlStreamReader, XMLStreamWriter xmlStreamWriter, String exemptLanguageId, String defaultLanguageId, boolean cdata) throws XMLStreamException {
        while (xmlStreamReader.hasNext()) {
            int event = xmlStreamReader.next();
            if (event == 1) {
                String languageId = xmlStreamReader.getAttributeValue(null, _LANGUAGE_ID);
                if (Validator.isNull((String)languageId)) {
                    languageId = defaultLanguageId;
                }
                if (languageId.equals(exemptLanguageId)) continue;
                xmlStreamWriter.writeStartElement(xmlStreamReader.getLocalName());
                xmlStreamWriter.writeAttribute(_LANGUAGE_ID, languageId);
                while (xmlStreamReader.hasNext()) {
                    event = xmlStreamReader.next();
                    if (event == 4 || event == 12) {
                        String text = xmlStreamReader.getText();
                        if (cdata) {
                            xmlStreamWriter.writeCData(text);
                            break;
                        }
                        xmlStreamWriter.writeCharacters(xmlStreamReader.getText());
                        break;
                    }
                    if (event == 2) break;
                }
                xmlStreamWriter.writeEndElement();
                continue;
            }
            if (event == 8) break;
        }
    }

    private String _getCachedValue(String xml, String requestedLanguageId, boolean useDefault) {
        String value = null;
        Map<Tuple, String> valueMap = this._cache.get(xml);
        if (valueMap != null) {
            Tuple subkey = new Tuple(new Object[]{useDefault, requestedLanguageId});
            value = valueMap.get(subkey);
        }
        return value;
    }

    private String _getLocalization(String bundleName, Locale locale, ClassLoader classLoader, String key, String defaultValue) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, locale, classLoader);
        String value = null;
        try {
            value = resourceBundle.getString(key);
            value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (Exception exception) {}
        value = Validator.isNotNull((String)value) ? LanguageResources.fixValue(value) : LanguageUtil.get((Locale)locale, (String)key, (String)defaultValue);
        return value;
    }

    private String _getRootAttributeValue(Document document, String name, String defaultValue) {
        Element rootElement = document.getRootElement();
        return rootElement.attributeValue(name, defaultValue);
    }

    private String _getRootAttributeValue(String xml, String name, String defaultValue) {
        String value;
        block21: {
            value = null;
            XMLStreamReader xmlStreamReader = null;
            ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
            ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
            try {
                try {
                    XMLInputFactory xmlInputFactory;
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(portalClassLoader);
                    }
                    if ((xmlStreamReader = (xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory()).createXMLStreamReader((Reader)new UnsyncStringReader(xml))).hasNext()) {
                        xmlStreamReader.nextTag();
                        value = xmlStreamReader.getAttributeValue(null, name);
                    }
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (Validator.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    private String _sanitizeXML(String xml) {
        if (Validator.isNull((String)xml) || !xml.contains("<root")) {
            xml = _EMPTY_ROOT_NODE;
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setCachedValue(String xml, String requestedLanguageId, boolean useDefault, String value) {
        if (Validator.isNotNull((String)xml) && !xml.equals(_EMPTY_ROOT_NODE)) {
            Map<String, Map<Tuple, String>> map = this._cache;
            synchronized (map) {
                Map<Tuple, String> map2 = this._cache.get(xml);
                if (map2 == null) {
                    map2 = new HashMap<Tuple, String>();
                }
                Tuple subkey = new Tuple(new Object[]{useDefault, requestedLanguageId});
                map2.put(subkey, value);
                this._cache.put(xml, map2);
            }
        }
    }
}

