/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SessionTreeJSClicks {
    private static Log _log = LogFactoryUtil.getLog(SessionTreeJSClicks.class);

    public static void closeLayoutNodes(HttpServletRequest request, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(request, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.closeNodes(request, treeId, layoutIds.toArray(new String[layoutIds.size()]));
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static void closeNode(HttpServletRequest request, String treeId, String nodeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                openNodesString = StringUtil.remove((String)openNodesString, (String)nodeId);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                return;
            }
            break;
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, "");
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                return;
            }
            break;
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                String[] stringArray = nodeIds;
                int n = nodeIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String nodeId = stringArray[n2];
                    openNodesString = StringUtil.remove((String)openNodesString, (String)nodeId);
                    ++n2;
                }
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                return;
            }
            break;
        }
    }

    public static String getOpenNodes(HttpServletRequest request, String treeId) {
        try {
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            return portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    public static void openLayoutNodes(HttpServletRequest request, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(request, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.openNodes(request, treeId, layoutIds.toArray(new String[layoutIds.size()]));
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static void openNode(HttpServletRequest request, String treeId, String nodeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                return;
            }
            break;
        }
    }

    public static void openNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                String[] stringArray = nodeIds;
                int n = nodeIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String nodeId = stringArray[n2];
                    openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
                    ++n2;
                }
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                return;
            }
            break;
        }
    }

    protected static List<String> getLayoutIds(HttpServletRequest request, boolean privateLayout, long parentLayoutId, List<String> layoutIds) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
        for (Layout layout : layouts) {
            layoutIds.add(String.valueOf(layout.getLayoutId()));
            SessionTreeJSClicks.getLayoutIds(request, privateLayout, layout.getLayoutId(), layoutIds);
        }
        return layoutIds;
    }
}

