/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WebAppPool {
    private static WebAppPool _instance = new WebAppPool();
    private ConcurrentMap<Long, Map<String, Object>> _webAppPool = new ConcurrentHashMap<Long, Map<String, Object>>();

    public static void clear() {
        WebAppPool._instance._webAppPool.clear();
    }

    public static Object get(Long webAppId, String key) {
        return _instance._get(webAppId, key);
    }

    public static void put(Long webAppId, String key, Object obj) {
        _instance._put(webAppId, key, obj);
    }

    public static Object remove(Long webAppId, String key) {
        return _instance._remove(webAppId, key);
    }

    private WebAppPool() {
    }

    private Object _get(Long webAppId, String key) {
        Map map = (Map)this._webAppPool.get(webAppId);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    private void _put(Long webAppId, String key, Object obj) {
        Map previousMap;
        Map<String, Object> map = (ConcurrentHashMap<String, Object>)this._webAppPool.get(webAppId);
        if (map == null && (previousMap = (Map)this._webAppPool.putIfAbsent(webAppId, map = new ConcurrentHashMap<String, Object>())) != null) {
            map = previousMap;
        }
        map.put(key, obj);
    }

    private Object _remove(Long webAppId, String key) {
        Map map = (Map)this._webAppPool.get(webAppId);
        if (map == null) {
            return null;
        }
        return map.remove(key);
    }
}

