/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.impl.ResourcePermissionLocalServiceImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.util.ArrayList;
import java.util.List;

public class VerifyPermission
extends VerifyProcess {
    private static final List<String> _DEPRECATED_ORGANIZATION_ACTION_IDS = new ArrayList<String>();
    private static Log _log = LogFactoryUtil.getLog(VerifyPermission.class);

    static {
        _DEPRECATED_ORGANIZATION_ACTION_IDS.add("MANAGE_ARCHIVED_SETUPS");
        _DEPRECATED_ORGANIZATION_ACTION_IDS.add("MANAGE_LAYOUTS");
        _DEPRECATED_ORGANIZATION_ACTION_IDS.add("MANAGE_STAGING");
        _DEPRECATED_ORGANIZATION_ACTION_IDS.add("MANAGE_TEAMS");
        _DEPRECATED_ORGANIZATION_ACTION_IDS.add("PUBLISH_STAGING");
        _DEPRECATED_ORGANIZATION_ACTION_IDS.add("APPROVE_PROPOSAL");
        _DEPRECATED_ORGANIZATION_ACTION_IDS.add("ASSIGN_REVIEWER");
    }

    protected void checkPermissions() throws Exception {
        List modelNames = ResourceActionsUtil.getModelNames();
        for (String modelName : modelNames) {
            List actionIds = ResourceActionsUtil.getModelResourceActions((String)modelName);
            ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)actionIds, (boolean)true);
        }
        List portletNames = ResourceActionsUtil.getPortletNames();
        for (String portletName : portletNames) {
            List actionIds = ResourceActionsUtil.getPortletResourceActions((String)portletName);
            ResourceActionLocalServiceUtil.checkResourceActions((String)portletName, (List)actionIds, (boolean)true);
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                long companyId = lArray[n2];
                try {
                    this.deleteDefaultPrivateLayoutPermissions_6(companyId);
                }
                catch (Exception e2) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)e2, (Throwable)e2);
                }
            }
            ++n2;
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions_6(long companyId) throws Exception {
        Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions((long)role.getRoleId());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.isPrivateLayout(resourcePermission.getName(), resourcePermission.getPrimKey())) continue;
            ResourcePermissionLocalServiceUtil.deleteResourcePermission((long)resourcePermission.getResourcePermissionId());
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteDefaultPrivateLayoutPermissions();
        this.checkPermissions();
        this.fixOrganizationRolePermissions();
        this.fixUserDefaultRolePermissions();
    }

    protected void fixOrganizationRolePermissions() throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(ResourcePermission.class);
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)Organization.class.getName()));
        List resourcePermissions = ResourcePermissionLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            ResourcePermission groupResourcePermission = null;
            try {
                groupResourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
            }
            catch (Exception exception) {
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId(), (String[])ResourcePermissionLocalServiceImpl.EMPTY_ACTION_IDS);
                groupResourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
            }
            for (String actionId : _DEPRECATED_ORGANIZATION_ACTION_IDS) {
                if (!resourcePermission.hasActionId(actionId)) continue;
                resourcePermission.removeResourceAction(actionId);
                groupResourcePermission.addResourceAction(actionId);
            }
            try {
                resourcePermission.resetOriginalValues();
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
                groupResourcePermission.resetOriginalValues();
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)groupResourcePermission);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        PermissionCacheUtil.clearResourceCache();
    }

    protected void fixUserDefaultRolePermissions() throws Exception {
        long[] companyIds;
        long userClassNameId = PortalUtil.getClassNameId(User.class);
        long userGroupClassNameId = PortalUtil.getClassNameId(UserGroup.class);
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
            Role userRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
            StringBundler joinSB = new StringBundler(22);
            joinSB.append("ResourcePermission resourcePermission1 left outer ");
            joinSB.append("join ResourcePermission resourcePermission2 on ");
            joinSB.append("resourcePermission1.companyId = ");
            joinSB.append("resourcePermission2.companyId and ");
            joinSB.append("resourcePermission1.name = ");
            joinSB.append("resourcePermission2.name and ");
            joinSB.append("resourcePermission1.primKey = ");
            joinSB.append("resourcePermission2.primKey and ");
            joinSB.append("resourcePermission1.scope = ");
            joinSB.append("resourcePermission2.scope and ");
            joinSB.append("resourcePermission2.roleId = ");
            joinSB.append(userRole.getRoleId());
            joinSB.append(" inner join Layout on ");
            joinSB.append("resourcePermission1.companyId = Layout.companyId ");
            joinSB.append("and resourcePermission1.primKey like ");
            joinSB.append("replace('[$PLID$]");
            joinSB.append("_LAYOUT_");
            joinSB.append("%', '[$PLID$]', cast_text(Layout.plid)) inner ");
            joinSB.append("join Group_ on Layout.groupId = ");
            joinSB.append("Group_.groupId and Layout.type_ = '");
            joinSB.append("portlet");
            joinSB.append("'");
            StringBundler whereSB = new StringBundler(12);
            whereSB.append("where resourcePermission1.scope = ");
            whereSB.append(4);
            whereSB.append(" and resourcePermission1.primKey like '%");
            whereSB.append("_LAYOUT_");
            whereSB.append("%' and resourcePermission1.roleId = ");
            whereSB.append(powerUserRole.getRoleId());
            whereSB.append(" and resourcePermission2.roleId is null and ");
            whereSB.append("(Group_.classNameId = ");
            whereSB.append(userClassNameId);
            whereSB.append(" or Group_.classNameId = ");
            whereSB.append(userGroupClassNameId);
            whereSB.append(")");
            StringBundler sb = new StringBundler(8);
            if (dbType.equals("mysql")) {
                sb.append("update ");
                sb.append(joinSB.toString());
                sb.append(" set resourcePermission1.roleId = ");
                sb.append(userRole.getRoleId());
                sb.append(" ");
                sb.append(whereSB.toString());
            } else {
                sb.append("update ResourcePermission set roleId = ");
                sb.append(userRole.getRoleId());
                sb.append(" where resourcePermissionId in (select ");
                sb.append("resourcePermission1.resourcePermissionId from ");
                sb.append(joinSB.toString());
                sb.append(" ");
                sb.append(whereSB.toString());
                sb.append(")");
            }
            this.runSQL(sb.toString());
            ++n2;
        }
        EntityCacheUtil.clearCache();
        FinderCacheUtil.clearCache();
    }

    protected boolean isPrivateLayout(String name, String primKey) throws Exception {
        long plid;
        Layout layout;
        if (!name.equals(Layout.class.getName()) && !primKey.contains("_LAYOUT_")) {
            return false;
        }
        if (primKey.contains("_LAYOUT_")) {
            primKey = StringUtil.extractFirst((String)primKey, (String)"_LAYOUT_");
        }
        return !(layout = LayoutLocalServiceUtil.getLayout((long)(plid = GetterUtil.getLong((String)primKey)))).isPublicLayout() && !layout.isTypeControlPanel();
    }
}

