/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.persistence.PortletPreferencesActionableDynamicQuery;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;

public class VerifyPortletPreferences
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyPortletPreferences.class);

    public static void cleanUpLayoutRevisionPortletPreferences() throws Exception {
        PortletPreferencesActionableDynamicQuery actionableDynamicQuery = new PortletPreferencesActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property plidProperty = PropertyFactoryUtil.forName((String)"plid");
                DynamicQuery layoutRevisionDynamicQuery = LayoutRevisionLocalServiceUtil.dynamicQuery();
                layoutRevisionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"layoutRevisionId"));
                dynamicQuery.add(plidProperty.in(layoutRevisionDynamicQuery));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                com.liferay.portal.model.PortletPreferences portletPreferences = (com.liferay.portal.model.PortletPreferences)object;
                long layoutRevisionId = portletPreferences.getPlid();
                LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
                Layout layout = LayoutLocalServiceUtil.getLayout((long)layoutRevision.getPlid());
                if (!layout.isTypePortlet()) {
                    return;
                }
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                List portlets = layoutTypePortlet.getAllPortlets();
                ArrayList<String> portletIds = new ArrayList<String>(portlets.size());
                for (Portlet portlet : portlets) {
                    portletIds.add((String)Portlet.PORTLET_ID_ACCESSOR.get((Object)portlet));
                }
                if (portletIds.contains(portletPreferences.getPortletId())) {
                    return;
                }
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Removing portlet preferences " + portletPreferences.getPortletPreferencesId()));
                }
                PortletPreferencesLocalServiceUtil.deletePortletPreferences((com.liferay.portal.model.PortletPreferences)portletPreferences);
            }
        };
        actionableDynamicQuery.performActions();
    }

    public static void cleanUpScopeIdPortletPreferences() throws Exception {
        final long classNameId = ClassNameLocalServiceUtil.getClassNameId((String)JournalArticle.class.getName());
        PortletPreferencesActionableDynamicQuery actionableDynamicQuery = new PortletPreferencesActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property plidProperty = PropertyFactoryUtil.forName((String)"plid");
                DynamicQuery layoutDynamicQuery = LayoutLocalServiceUtil.dynamicQuery();
                layoutDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"plid"));
                dynamicQuery.add(plidProperty.in(layoutDynamicQuery));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                com.liferay.portal.model.PortletPreferences portletPreferences = (com.liferay.portal.model.PortletPreferences)object;
                long plid = portletPreferences.getPlid();
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                if (!layout.isTypePortlet()) {
                    return;
                }
                PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.strictFromXML((long)layout.getCompanyId(), (long)portletPreferences.getOwnerId(), (int)portletPreferences.getOwnerType(), (long)plid, (String)portletPreferences.getPortletId(), (String)portletPreferences.getPreferences());
                Object[] scopeIds = jxPortletPreferences.getValues("scopeIds", null);
                String preferenceName = "classTypeIdsJournalArticleAssetRendererFactory";
                Object[] classTypeIds = jxPortletPreferences.getValues(preferenceName, null);
                try {
                    if (ArrayUtil.isNotEmpty((Object[])classTypeIds) || ArrayUtil.isNotEmpty((Object[])scopeIds)) {
                        if (ArrayUtil.isEmpty((Object[])scopeIds)) {
                            scopeIds = new String[]{"Group_default"};
                            jxPortletPreferences.setValue("scopeIds", (String)scopeIds[0]);
                        }
                        long[] groupIds = VerifyPortletPreferences.getGroupIds((String[])scopeIds, layout.getGroupId());
                        List structures = DDMStructureLocalServiceUtil.getStructures((long[])groupIds, (long)classNameId);
                        long[] structureIds = new long[structures.size()];
                        for (DDMStructure structure : structures) {
                            structureIds = ArrayUtil.append((long[])structureIds, (long)structure.getStructureId());
                        }
                        if (ArrayUtil.isNotEmpty((long[])structureIds)) {
                            String structureIdsString = StringUtil.strip((String)Arrays.toString(structureIds), (char[])new char[]{']', '[', ' '});
                            jxPortletPreferences.setValue(preferenceName, structureIdsString);
                        } else {
                            jxPortletPreferences.reset(preferenceName);
                        }
                    } else {
                        jxPortletPreferences.reset(preferenceName);
                    }
                }
                catch (ReadOnlyException readOnlyException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to update portlet preferences " + portletPreferences.getPortletPreferencesId()));
                    }
                    return;
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Updating portlet preferences " + portletPreferences.getPortletPreferencesId()));
                }
                PortletPreferencesLocalServiceUtil.updatePreferences((long)portletPreferences.getOwnerId(), (int)portletPreferences.getOwnerType(), (long)plid, (String)portletPreferences.getPortletId(), (PortletPreferences)jxPortletPreferences);
            }
        };
        actionableDynamicQuery.performActions();
    }

    private static long[] getGroupIds(String[] scopeIds, long defaultGroupId) {
        long[] groupIds = new long[]{};
        String[] stringArray = scopeIds;
        int n = scopeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String scopeId = stringArray[n2];
            if (scopeId.startsWith("Group_")) {
                long siteGroupId = 0L;
                String scopeIdSuffix = scopeId.substring("Group_".length());
                siteGroupId = scopeIdSuffix.equals("default") ? defaultGroupId : Long.valueOf(scopeIdSuffix);
                groupIds = ArrayUtil.append((long[])groupIds, (long)siteGroupId);
            }
            ++n2;
        }
        return groupIds;
    }

    @Override
    protected void doVerify() throws Exception {
        VerifyPortletPreferences.cleanUpLayoutRevisionPortletPreferences();
        VerifyPortletPreferences.cleanUpScopeIdPortletPreferences();
    }
}

