/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;

public class AssetEntryPermission {
    public static void check(PermissionChecker permissionChecker, AssetEntry entry, String actionId) throws PortalException {
        if (!AssetEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        if (!AssetEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException, SystemException {
        if (!AssetEntryPermission.contains(permissionChecker, className, classPK, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AssetEntry entry, String actionId) throws PortalException {
        String className = PortalUtil.getClassName((long)entry.getClassNameId());
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        try {
            return assetRendererFactory.hasPermission(permissionChecker, entry.getClassPK(), actionId);
        }
        catch (Exception e2) {
            throw new PrincipalException((Throwable)e2);
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        AssetEntry entry = AssetEntryLocalServiceUtil.getEntry((long)entryId);
        return AssetEntryPermission.contains(permissionChecker, entry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException, SystemException {
        AssetEntry entry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
        return AssetEntryPermission.contains(permissionChecker, entry, actionId);
    }
}

