/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.model.impl.AssetTagPropertyImpl;
import com.liferay.portlet.asset.service.persistence.AssetTagPropertyFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AssetTagPropertyFinderImpl
extends BasePersistenceImpl<AssetTagProperty>
implements AssetTagPropertyFinder {
    public static final String COUNT_BY_G_K = String.valueOf(AssetTagPropertyFinder.class.getName()) + ".countByG_K";
    public static final String FIND_BY_G_K = String.valueOf(AssetTagPropertyFinder.class.getName()) + ".findByG_K";

    public int countByG_K(long groupId, String key) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_K);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(key);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AssetTagProperty> findByG_K(long groupId, String key) throws SystemException {
        return this.findByG_K(groupId, key, -1, -1);
    }

    public List<AssetTagProperty> findByG_K(long groupId, String key, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_K);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("tagPropertyValue", Type.STRING);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(key);
            ArrayList<AssetTagProperty> tagProperties = new ArrayList<AssetTagProperty>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                String value = (String)itr.next();
                AssetTagPropertyImpl tagProperty = new AssetTagPropertyImpl();
                tagProperty.setKey(key);
                tagProperty.setValue(value);
                tagProperties.add(tagProperty);
            }
            ArrayList<AssetTagProperty> arrayList = tagProperties;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }
}

