/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;

public class BlogsEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<BlogsEntry> {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.fetchBlogsEntryByUuidAndGroupId((String)uuid, (long)groupId);
        if (entry != null) {
            BlogsEntryLocalServiceUtil.deleteEntry((BlogsEntry)entry);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BlogsEntry entry) {
        return entry.getTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        if (entry.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.fetchImage((long)entry.getSmallImageId());
            if (Validator.isNotNull((String)entry.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)entry, (Element)entryElement, (String)entry.getSmallImageURL().concat(" "), (boolean)true);
                entry.setSmallImageURL(smallImageURL);
            } else if (smallImage != null) {
                String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)entry, (String)(String.valueOf(smallImage.getImageId()) + "." + smallImage.getType()));
                entryElement.addAttribute("small-image-path", smallImagePath);
                entry.setSmallImageType(smallImage.getType());
                portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
            }
        }
        String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)entry, (Element)entryElement, (String)entry.getContent(), (boolean)portletDataContext.getBooleanParameter("blogs", "referenced-content"));
        entry.setContent(content);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        Element entryElement = portletDataContext.getImportDataStagedModelElement((StagedModel)entry);
        String content = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)entryElement, (String)entry.getContent(), (boolean)portletDataContext.getBooleanParameter("blogs", "referenced-content"));
        entry.setContent(content);
        Calendar displayDateCal = CalendarFactoryUtil.getCalendar();
        displayDateCal.setTime(entry.getDisplayDate());
        int displayDateMonth = displayDateCal.get(2);
        int displayDateDay = displayDateCal.get(5);
        int displayDateYear = displayDateCal.get(1);
        int displayDateHour = displayDateCal.get(10);
        int displayDateMinute = displayDateCal.get(12);
        if (displayDateCal.get(9) == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = entry.isAllowPingbacks();
        boolean allowTrackbacks = entry.isAllowTrackbacks();
        String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
        String smallImageFileName = null;
        InputStream smallImageInputStream = null;
        try {
            if (entry.isSmallImage()) {
                String smallImagePath = entryElement.attributeValue("small-image-path");
                if (Validator.isNotNull((String)entry.getSmallImageURL())) {
                    String smallImageURL = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)entryElement, (String)entry.getSmallImageURL(), (boolean)true);
                    entry.setSmallImageURL(smallImageURL);
                } else if (Validator.isNotNull((String)smallImagePath)) {
                    smallImageFileName = String.valueOf(entry.getSmallImageId()).concat(".").concat(entry.getSmallImageType());
                    smallImageInputStream = portletDataContext.getZipEntryAsInputStream(smallImagePath);
                }
            }
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)entry);
            BlogsEntry importedEntry = null;
            if (portletDataContext.isDataStrategyMirror()) {
                serviceContext.setAttribute("urlTitle", (Serializable)((Object)entry.getUrlTitle()));
                BlogsEntry existingEntry = BlogsEntryLocalServiceUtil.fetchBlogsEntryByUuidAndGroupId((String)entry.getUuid(), (long)portletDataContext.getScopeGroupId());
                if (existingEntry == null) {
                    serviceContext.setUuid(entry.getUuid());
                    importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.isSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
                } else {
                    importedEntry = BlogsEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.getSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
                }
            } else {
                importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.getSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
            }
            portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(smallImageInputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)smallImageInputStream);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        BlogsEntry existingEntry = BlogsEntryLocalServiceUtil.fetchBlogsEntryByUuidAndGroupId((String)entry.getUuid(), (long)portletDataContext.getScopeGroupId());
        if (existingEntry == null || !existingEntry.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingEntry.getTrashHandler();
        if (trashHandler.isRestorable(existingEntry.getEntryId())) {
            trashHandler.restoreTrashEntry(userId, existingEntry.getEntryId());
        }
    }
}

