/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.social;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;

public class BookmarksEntryActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/bookmarks/find_entry?entryId=" + activity.getClassPK();
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-entry-add-entry";
            }
            return "activity-bookmarks-entry-add-entry-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-entry-update-entry";
            }
            return "activity-bookmarks-entry-update-entry-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-entry-move-to-trash";
            }
            return "activity-bookmarks-entry-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-entry-restore-from-trash";
            }
            return "activity-bookmarks-entry-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return BookmarksEntryPermission.contains(permissionChecker, activity.getClassPK(), actionId);
    }
}

