/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.service.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.calendar.model.CalEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CalEventLocalUtil {
    private static final String _CACHE_NAME = CalEventLocalUtil.class.getName();
    private static PortalCache<String, Serializable> _portalCache = MultiVMPoolUtil.getCache((String)_CACHE_NAME);

    protected static void clearEventsPool(long groupId) {
        String key = CalEventLocalUtil._encodeKey(groupId);
        _portalCache.remove((Serializable)((Object)key));
    }

    protected static Map<String, List<CalEvent>> getEventsPool(long groupId) {
        String key = CalEventLocalUtil._encodeKey(groupId);
        ConcurrentHashMap eventsPool = (ConcurrentHashMap)_portalCache.get((Serializable)((Object)key));
        if (eventsPool == null) {
            eventsPool = new ConcurrentHashMap();
            _portalCache.put((Serializable)((Object)key), (Object)eventsPool);
        }
        return eventsPool;
    }

    private static String _encodeKey(long groupId) {
        return _CACHE_NAME.concat("#").concat(StringUtil.toHexString((long)groupId));
    }
}

