/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.TreeModelFinder;
import com.liferay.portal.kernel.util.TreePathUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.TreeModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.journal.DuplicateFolderNameException;
import com.liferay.portlet.journal.FolderNameException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.base.JournalFolderLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.comparator.FolderIdComparator;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JournalFolderLocalServiceImpl
extends JournalFolderLocalServiceBaseImpl {
    public JournalFolder addFolder(long userId, long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validateFolder(0L, groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        JournalFolder folder = this.journalFolderPersistence.create(folderId);
        folder.setUuid(serviceContext.getUuid());
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setUserName(user.getFullName());
        folder.setCreateDate(serviceContext.getCreateDate(now));
        folder.setModifiedDate(serviceContext.getModifiedDate(now));
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.journalFolderPersistence.update((BaseModel)folder);
        this.resourceLocalService.addModelResources((AuditedModel)folder, serviceContext);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false, type=1)
    public JournalFolder deleteFolder(JournalFolder folder) throws PortalException, SystemException {
        return this.deleteFolder(folder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false, type=1)
    public JournalFolder deleteFolder(JournalFolder folder, boolean includeTrashedEntries) throws PortalException, SystemException {
        List folders = this.journalFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (JournalFolder curFolder : folders) {
            if (!includeTrashedEntries && curFolder.isInTrashExplicitly()) continue;
            this.deleteFolder(curFolder, includeTrashedEntries);
        }
        this.journalFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource((AuditedModel)folder, 4);
        this.journalArticleLocalService.deleteArticles(folder.getGroupId(), folder.getFolderId(), includeTrashedEntries);
        this.assetEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        this.expandoValueLocalService.deleteValues(JournalFolder.class.getName(), folder.getFolderId());
        this.trashEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    public JournalFolder deleteFolder(long folderId) throws PortalException, SystemException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        return this.journalFolderLocalService.deleteFolder(folder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    public JournalFolder deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        return this.journalFolderLocalService.deleteFolder(folder, includeTrashedEntries);
    }

    public void deleteFolders(long groupId) throws PortalException, SystemException {
        List folders = this.journalFolderPersistence.findByGroupId(groupId);
        for (JournalFolder folder : folders) {
            this.journalFolderLocalService.deleteFolder(folder);
        }
    }

    public JournalFolder fetchFolder(long folderId) throws SystemException {
        return this.journalFolderPersistence.fetchByPrimaryKey(folderId);
    }

    public JournalFolder fetchFolder(long groupId, long parentFolderId, String name) throws SystemException {
        return this.journalFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
    }

    public JournalFolder fetchFolder(long groupId, String name) throws SystemException {
        return this.journalFolderPersistence.fetchByG_N(groupId, name);
    }

    public List<JournalFolder> getCompanyFolders(long companyId, int start, int end) throws SystemException {
        return this.journalFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) throws SystemException {
        return this.journalFolderPersistence.countByCompanyId(companyId);
    }

    public JournalFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.journalFolderPersistence.findByPrimaryKey(folderId);
    }

    public List<JournalFolder> getFolders(long groupId) throws SystemException {
        return this.journalFolderPersistence.findByGroupId(groupId);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.getFolders(groupId, parentFolderId, 0);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status) throws SystemException {
        return this.journalFolderPersistence.findByG_P_S(groupId, parentFolderId, status);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) throws SystemException {
        return this.journalFolderPersistence.findByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, obc);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersAndArticlesCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int articlesCount = this.journalArticleFinder.countByG_F(groupId, folderIds.subList(start, end), queryDefinition);
        folderIds.subList(start, end).clear();
        return articlesCount += this.getFoldersAndArticlesCount(groupId, folderIds, status);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.journalFolderFinder.countF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, 0L, false);
        return this.journalFolderFinder.countF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) throws SystemException {
        return this.journalFolderPersistence.countByG_P_S(groupId, parentFolderId, status);
    }

    public List<JournalFolder> getNoAssetFolders() throws SystemException {
        return this.journalFolderFinder.findF_ByNoAssets();
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.journalFolderPersistence.findByG_P(groupId, folderId);
        for (JournalFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (folder.getParentFolderId() == parentFolderId) {
            return folder;
        }
        this.validateFolder(folder.getFolderId(), folder.getGroupId(), parentFolderId, folder.getName());
        folder.setModifiedDate(serviceContext.getModifiedDate(null));
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder.setExpandoBridgeAttributes(serviceContext);
        this.journalFolderPersistence.update((BaseModel)folder);
        this.rebuildTree(folder.getCompanyId(), folderId, folder.getTreePath(), true);
        return folder;
    }

    public JournalFolder moveFolderFromTrash(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        if (folder.isInTrashExplicitly()) {
            this.restoreFolderFromTrash(userId, folderId);
        } else {
            TrashEntry trashEntry = folder.getTrashEntry();
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(trashEntry.getEntryId(), JournalFolder.class.getName(), folderId);
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, folder, status);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
            this.restoreDependentsFromTrash(foldersAndArticles, trashEntry.getEntryId());
        }
        return this.journalFolderLocalService.moveFolder(folderId, parentFolderId, serviceContext);
    }

    public JournalFolder moveFolderToTrash(long userId, long folderId) throws PortalException, SystemException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        String title = folder.getName();
        folder = this.updateStatus(userId, folder, 8);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", folder.getName());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), folder.getUuid(), null, 0, null, typeSettingsProperties);
        folder.setName(TrashUtil.getTrashTitle((long)trashEntry.getEntryId()));
        this.journalFolderPersistence.update((BaseModel)folder);
        List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId());
        this.moveDependentsToTrash(foldersAndArticles, trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", title);
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), 10007, extraDataJSONObject.toString(), 0L);
        return folder;
    }

    public void rebuildTree(long companyId) throws PortalException, SystemException {
        this.rebuildTree(companyId, 0L, "/", false);
    }

    public void rebuildTree(long companyId, long parentFolderId, String parentTreePath, final boolean reindex) throws PortalException, SystemException {
        TreePathUtil.rebuildTree((long)companyId, (long)parentFolderId, (String)parentTreePath, (TreeModelFinder)new TreeModelFinder<JournalFolder>(){

            public List<JournalFolder> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) throws SystemException {
                return JournalFolderLocalServiceImpl.this.journalFolderPersistence.findByF_C_P_NotS(previousId, companyId, parentPrimaryKey, 8, -1, size, (OrderByComparator)new FolderIdComparator());
            }

            public void rebuildDependentModelsTreePaths(long parentPrimaryKey, String treePath) throws PortalException, SystemException {
                JournalFolderLocalServiceImpl.this.journalArticleLocalService.setTreePaths(parentPrimaryKey, treePath, false);
            }

            public void reindexTreeModels(List<TreeModel> treeModels) throws PortalException {
                if (!reindex) {
                    return;
                }
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
                for (TreeModel treeModel : treeModels) {
                    indexer.reindex((Object)treeModel);
                }
            }
        });
    }

    public void restoreFolderFromTrash(long userId, long folderId) throws PortalException, SystemException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        folder.setName(TrashUtil.getOriginalTitle((String)folder.getName()));
        this.journalFolderPersistence.update((BaseModel)folder);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(JournalFolder.class.getName(), folderId);
        this.updateStatus(userId, folder, trashEntry.getStatus());
        List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
        this.restoreDependentsFromTrash(foldersAndArticles, trashEntry.getEntryId());
        this.trashEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", folder.getName());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), 10008, extraDataJSONObject.toString(), 0L);
    }

    public void updateAsset(long userId, JournalFolder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), JournalFolder.class.getName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, true, null, null, null, "text/plain", folder.getName(), folder.getDescription(), null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder updateFolder(long userId, long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (mergeWithParentFolder && folderId != parentFolderId) {
            this.mergeFolders(folder, parentFolderId);
            return folder;
        }
        this.validateFolder(folderId, folder.getGroupId(), parentFolderId, name);
        long oldParentFolderId = folder.getParentFolderId();
        if (oldParentFolderId != parentFolderId) {
            folder.setParentFolderId(parentFolderId);
            folder.setTreePath(folder.buildTreePath());
        }
        folder.setModifiedDate(serviceContext.getModifiedDate(null));
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.journalFolderPersistence.update((BaseModel)folder);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (oldParentFolderId != parentFolderId) {
            this.rebuildTree(folder.getCompanyId(), folderId, folder.getTreePath(), true);
        }
        return folder;
    }

    public JournalFolder updateStatus(long userId, JournalFolder folder, int status) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        folder.setStatus(status);
        folder.setStatusByUserId(userId);
        folder.setStatusByUserName(user.getFullName());
        folder.setStatusDate(new Date());
        this.journalFolderPersistence.update((BaseModel)folder);
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), true);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), false);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
        indexer.reindex((Object)folder);
        return folder;
    }

    protected long getParentFolderId(JournalFolder folder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        JournalFolder parentFolder = this.journalFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        JournalFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.journalFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(JournalFolder fromFolder, long toFolderId) throws PortalException, SystemException {
        List folders = this.journalFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (JournalFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List articles = this.journalArticlePersistence.findByG_F(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (JournalArticle article : articles) {
            article.setFolderId(toFolderId);
            article.setTreePath(article.buildTreePath());
            this.journalArticlePersistence.update((BaseModel)article);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            indexer.reindex((Object)article);
        }
        this.journalFolderLocalService.deleteFolder(fromFolder);
    }

    protected void moveDependentsToTrash(List<Object> foldersAndArticles, long trashEntryId) throws PortalException, SystemException {
        for (Object object : foldersAndArticles) {
            JournalFolder folder;
            if (object instanceof JournalArticle) {
                JournalArticle article = (JournalArticle)object;
                if (article.getStatus() == 8) continue;
                List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
                for (JournalArticle curArticle : articles) {
                    int curArticleOldStatus = curArticle.getStatus();
                    curArticle.setStatus(8);
                    this.journalArticlePersistence.update((BaseModel)curArticle);
                    int status = curArticleOldStatus;
                    if (curArticleOldStatus == 1) {
                        status = 2;
                    }
                    if (curArticleOldStatus != 0) {
                        this.trashVersionLocalService.addTrashVersion(trashEntryId, JournalArticle.class.getName(), curArticle.getId(), status, null);
                    }
                    if (curArticleOldStatus != 1) continue;
                    this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(curArticle.getCompanyId(), curArticle.getGroupId(), JournalArticle.class.getName(), curArticle.getId());
                }
                this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
                indexer.reindex((Object)article);
                continue;
            }
            if (!(object instanceof JournalFolder) || (folder = (JournalFolder)object).isInTrashExplicitly()) continue;
            int oldStatus = folder.getStatus();
            folder.setStatus(8);
            this.journalFolderPersistence.update((BaseModel)folder);
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntryId, JournalFolder.class.getName(), folder.getFolderId(), oldStatus, null);
            }
            List<Object> curFoldersAndArticles = this.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId());
            this.moveDependentsToTrash(curFoldersAndArticles, trashEntryId);
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), false);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void restoreDependentsFromTrash(List<Object> foldersAndArticles, long trashEntryId) throws PortalException, SystemException {
        for (Object object : foldersAndArticles) {
            Indexer indexer;
            int oldStatus;
            TrashVersion trashVersion;
            TrashEntry trashEntry;
            if (object instanceof JournalArticle) {
                JournalArticle article = (JournalArticle)object;
                trashEntry = this.trashEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
                if (trashEntry != null) continue;
                trashVersion = this.trashVersionLocalService.fetchVersion(trashEntryId, JournalArticle.class.getName(), article.getId());
                oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
                for (JournalArticle curArticle : articles) {
                    trashVersion = this.trashVersionLocalService.fetchVersion(trashEntryId, JournalArticle.class.getName(), curArticle.getId());
                    int curArticleOldStatus = 0;
                    if (trashVersion != null) {
                        curArticleOldStatus = trashVersion.getStatus();
                    }
                    curArticle.setStatus(curArticleOldStatus);
                    this.journalArticlePersistence.update((BaseModel)curArticle);
                    if (trashVersion == null) continue;
                    this.trashVersionLocalService.deleteTrashVersion(trashVersion);
                }
                if (oldStatus == 0) {
                    this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), true);
                }
                indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
                indexer.reindex((Object)article);
                continue;
            }
            if (!(object instanceof JournalFolder)) continue;
            JournalFolder folder = (JournalFolder)object;
            trashEntry = this.trashEntryLocalService.fetchEntry(JournalFolder.class.getName(), folder.getFolderId());
            if (trashEntry != null) continue;
            trashVersion = this.trashVersionLocalService.fetchVersion(trashEntryId, JournalFolder.class.getName(), folder.getFolderId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            folder.setStatus(oldStatus);
            this.journalFolderPersistence.update((BaseModel)folder);
            List<Object> curFoldersAndArticles = this.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
            this.restoreDependentsFromTrash(curFoldersAndArticles, trashEntryId);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), true);
            indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void validateFolder(long folderId, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        this.validateFolderName(name);
        JournalFolder folder = this.journalFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
        if (folder != null && folder.getFolderId() != folderId) {
            throw new DuplicateFolderNameException(name);
        }
    }

    protected void validateFolderName(String name) throws PortalException {
        if (!AssetUtil.isValidWord(name)) {
            throw new FolderNameException();
        }
        if (name.contains("\\\\") || name.contains("//")) {
            throw new FolderNameException();
        }
    }
}

