/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.NoSuchFolderException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;

public class JournalArticlePermission {
    public static void check(PermissionChecker permissionChecker, JournalArticle article, String actionId) throws PortalException, SystemException {
        if (!JournalArticlePermission.contains(permissionChecker, article, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        if (!JournalArticlePermission.contains(permissionChecker, resourcePrimKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String articleId, double version, String actionId) throws PortalException, SystemException {
        if (!JournalArticlePermission.contains(permissionChecker, groupId, articleId, version, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String articleId, int status, String actionId) throws PortalException, SystemException {
        if (!JournalArticlePermission.contains(permissionChecker, groupId, articleId, status, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String articleId, String actionId) throws PortalException, SystemException {
        if (!JournalArticlePermission.contains(permissionChecker, groupId, articleId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, JournalArticle article, String actionId) throws PortalException, SystemException {
        block14: {
            Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)article.getGroupId(), (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (String)"15", (String)actionId);
            if (hasPermission != null) {
                return hasPermission;
            }
            if (article.isDraft()) {
                if (actionId.equals("VIEW") && !JournalArticlePermission.contains(permissionChecker, article, "UPDATE")) {
                    return false;
                }
            } else if (article.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)article.getGroupId(), (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (String)actionId)) != null) {
                return hasPermission;
            }
            if (actionId.equals("VIEW") && !PropsValues.JOURNAL_ARTICLE_VIEW_PERMISSION_CHECK_ENABLED) {
                return true;
            }
            if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                long folderId = article.getFolderId();
                if (folderId == 0L) {
                    if (!JournalPermission.contains(permissionChecker, article.getGroupId(), actionId)) {
                        return false;
                    }
                } else {
                    try {
                        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
                        if (!JournalFolderPermission.contains(permissionChecker, folder, "ACCESS") && !JournalFolderPermission.contains(permissionChecker, folder, "VIEW")) {
                            return false;
                        }
                    }
                    catch (NoSuchFolderException nsfe) {
                        if (article.isInTrash()) break block14;
                        throw nsfe;
                    }
                }
            }
        }
        if (permissionChecker.hasOwnerPermission(article.getCompanyId(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)resourcePrimKey);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String articleId, double version, String actionId) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String articleId, int status, String actionId) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)groupId, (String)articleId, (int)status);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String articleId, String actionId) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }
}

