/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontentsearch.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class ContentHits {
    private boolean _showListed = true;

    public boolean isShowListed() {
        return this._showListed;
    }

    public void recordHits(Hits hits, long groupId, boolean privateLayout, int start, int end) throws Exception {
        List<Document> docs = new ArrayList();
        List<Float> scores = new ArrayList();
        Document[] docsArray = hits.getDocs();
        int i2 = 0;
        while (i2 < docsArray.length) {
            Document doc = hits.doc(i2);
            long articleGroupId = GetterUtil.getLong((String)doc.get("groupId"));
            String articleId = doc.get("articleId");
            int layoutIdsCount = JournalContentSearchLocalServiceUtil.getLayoutIdsCount((long)groupId, (boolean)privateLayout, (String)articleId);
            if (layoutIdsCount > 0 || !this.isShowListed() && articleGroupId == groupId) {
                docs.add(hits.doc(i2));
                scores.add(Float.valueOf(hits.score(i2)));
            }
            ++i2;
        }
        int length = docs.size();
        hits.setLength(length);
        if (end > length) {
            end = length;
        }
        docs = docs.subList(start, end);
        scores = scores.subList(start, end);
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(scores.toArray(new Float[docs.size()]));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
    }

    public void setShowListed(boolean showListed) {
        this._showListed = showListed;
    }
}

