/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portalsettings.action;

import com.liferay.portal.ImageTypeException;
import com.liferay.portal.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.flash.FlashMagicBytesUtil;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditCompanyLogoAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(EditCompanyLogoAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
            if (cmd.equals("add_temp")) {
                this.addTempImageFile((PortletRequest)actionRequest);
            } else {
                this.saveTempImageFile(actionRequest);
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.portal_settings.error");
            }
            if (e2 instanceof FileSizeException || e2 instanceof ImageTypeException) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.putException(e2);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
            }
            if (e2 instanceof NoSuchFileException || e2 instanceof UploadException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portal_settings.edit_company_logo"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
            if (cmd.equals("get_temp")) {
                FileEntry tempFileEntry = this.getTempImageFileEntry((PortletRequest)resourceRequest);
                FlashMagicBytesUtil.Result flashMagicBytesUtilResult = FlashMagicBytesUtil.check((InputStream)tempFileEntry.getContentStream());
                if (flashMagicBytesUtilResult.isFlash()) {
                    return;
                }
                this.serveTempImageFile((MimeResponse)resourceResponse, flashMagicBytesUtilResult.getInputStream());
            }
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
    }

    protected void addTempImageFile(PortletRequest portletRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String contentType = uploadPortletRequest.getContentType("fileName");
        String fileName = uploadPortletRequest.getFileName("fileName");
        File file = uploadPortletRequest.getFile("fileName");
        String mimeType = MimeTypesUtil.getContentType((File)file, (String)fileName);
        if (!StringUtil.equalsIgnoreCase((String)"application/octet-stream", (String)mimeType)) {
            contentType = mimeType;
        }
        if (!MimeTypesUtil.isWebImage((String)contentType)) {
            throw new ImageTypeException();
        }
        try {
            TempFileUtil.deleteTempFile((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getTempImageFileName(portletRequest), (String)this.getTempImageFolderName());
        }
        catch (Exception exception) {}
        TempFileUtil.addTempFile((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getTempImageFileName(portletRequest), (String)this.getTempImageFolderName(), (File)file, (String)contentType);
    }

    protected RenderedImage getCroppedRenderedImage(RenderedImage renderedImage, int height, int width, int x, int y) {
        Rectangle rectangle = new Rectangle(width, height);
        Rectangle croppedRectangle = rectangle.intersection(new Rectangle(renderedImage.getWidth(), renderedImage.getHeight()));
        BufferedImage bufferedImage = ImageToolUtil.getBufferedImage((RenderedImage)renderedImage);
        return bufferedImage.getSubimage(x, y, croppedRectangle.width, croppedRectangle.height);
    }

    protected FileEntry getTempImageFileEntry(PortletRequest portletRequest) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return TempFileUtil.getTempFile((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getTempImageFileName(portletRequest), (String)this.getTempImageFolderName());
    }

    protected String getTempImageFileName(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return String.valueOf(themeDisplay.getCompanyId());
    }

    protected String getTempImageFolderName() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return clazz.getName();
    }

    protected void saveTempImageFile(ActionRequest actionRequest) throws Exception {
        FileEntry tempFileEntry = null;
        InputStream tempImageStream = null;
        try {
            try {
                tempFileEntry = this.getTempImageFileEntry((PortletRequest)actionRequest);
                tempImageStream = tempFileEntry.getContentStream();
                ImageBag imageBag = ImageToolUtil.read((InputStream)tempImageStream);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                String cropRegionJSON = ParamUtil.getString((PortletRequest)actionRequest, (String)"cropRegion");
                if (Validator.isNotNull((String)cropRegionJSON)) {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)cropRegionJSON);
                    int height = jsonObject.getInt("height");
                    int width = jsonObject.getInt("width");
                    int x = jsonObject.getInt("x");
                    int y = jsonObject.getInt("y");
                    if (height + y > renderedImage.getHeight()) {
                        height = renderedImage.getHeight() - y;
                    }
                    if (width + x > renderedImage.getWidth()) {
                        width = renderedImage.getWidth() - x;
                    }
                    renderedImage = this.getCroppedRenderedImage(renderedImage, height, width, x, y);
                }
                byte[] bytes = ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
                this.saveTempImageFile((PortletRequest)actionRequest, bytes);
            }
            catch (NoSuchFileEntryException nsfee) {
                throw new UploadException((Throwable)nsfee);
            }
            catch (NoSuchRepositoryException nsre) {
                throw new UploadException((Throwable)nsre);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(tempImageStream);
            if (tempFileEntry != null) {
                TempFileUtil.deleteTempFile((long)tempFileEntry.getFileEntryId());
            }
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)tempImageStream);
        if (tempFileEntry != null) {
            TempFileUtil.deleteTempFile((long)tempFileEntry.getFileEntryId());
        }
    }

    protected void saveTempImageFile(PortletRequest portletRequest, byte[] bytes) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = CompanyServiceUtil.updateLogo((long)themeDisplay.getCompanyId(), (byte[])bytes);
        themeDisplay.setCompany(company);
    }

    protected void serveTempImageFile(MimeResponse mimeResponse, InputStream tempImageStream) throws Exception {
        ImageBag imageBag = ImageToolUtil.read((InputStream)tempImageStream);
        byte[] bytes = ImageToolUtil.getBytes((RenderedImage)imageBag.getRenderedImage(), (String)imageBag.getType());
        String contentType = MimeTypesUtil.getExtensionContentType((String)imageBag.getType());
        mimeResponse.setContentType(contentType);
        PortletResponseUtil.write((MimeResponse)mimeResponse, (byte[])bytes);
    }
}

