/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.amazonrankings.model.AmazonRankings;
import com.liferay.portlet.amazonrankings.util.AmazonRankingsUtil;
import com.liferay.portlet.shopping.AmazonException;
import com.liferay.portlet.shopping.DuplicateItemSKUException;
import com.liferay.portlet.shopping.ItemLargeImageNameException;
import com.liferay.portlet.shopping.ItemLargeImageSizeException;
import com.liferay.portlet.shopping.ItemMediumImageNameException;
import com.liferay.portlet.shopping.ItemMediumImageSizeException;
import com.liferay.portlet.shopping.ItemNameException;
import com.liferay.portlet.shopping.ItemSKUException;
import com.liferay.portlet.shopping.ItemSmallImageNameException;
import com.liferay.portlet.shopping.ItemSmallImageSizeException;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemField;
import com.liferay.portlet.shopping.model.ShoppingItemPrice;
import com.liferay.portlet.shopping.service.base.ShoppingItemLocalServiceBaseImpl;
import com.liferay.util.PwdGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ShoppingItemLocalServiceImpl
extends ShoppingItemLocalServiceBaseImpl {
    public void addBookItems(long userId, long groupId, long categoryId, String[] isbns) throws PortalException, SystemException {
        try {
            this.doAddBookItems(userId, groupId, categoryId, isbns);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public ShoppingItem addItem(long userId, long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, Boolean sale, boolean smallImage, String smallImageURL, File smallImageFile, boolean mediumImage, String mediumImageURL, File mediumImageFile, boolean largeImage, String largeImageURL, File largeImageFile, List<ShoppingItemField> itemFields, List<ShoppingItemPrice> itemPrices, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        sku = StringUtil.toUpperCase((String)sku.trim());
        byte[] smallImageBytes = null;
        byte[] mediumImageBytes = null;
        byte[] largeImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            mediumImageBytes = FileUtil.getBytes((File)mediumImageFile);
            largeImageBytes = FileUtil.getBytes((File)largeImageFile);
        }
        catch (IOException iOException) {}
        Date now = new Date();
        this.validate(user.getCompanyId(), 0L, sku, name, smallImage, smallImageURL, smallImageFile, smallImageBytes, mediumImage, mediumImageURL, mediumImageFile, mediumImageBytes, largeImage, largeImageURL, largeImageFile, largeImageBytes);
        long itemId = this.counterLocalService.increment();
        ShoppingItem item = this.shoppingItemPersistence.create(itemId);
        item.setGroupId(groupId);
        item.setCompanyId(user.getCompanyId());
        item.setUserId(user.getUserId());
        item.setUserName(user.getFullName());
        item.setCreateDate(now);
        item.setModifiedDate(now);
        item.setCategoryId(categoryId);
        item.setSku(sku);
        item.setName(name);
        item.setDescription(description);
        item.setProperties(properties);
        item.setFields(itemFields.size() > 0);
        item.setFieldsQuantities(fieldsQuantities);
        for (ShoppingItemPrice itemPrice : itemPrices) {
            if (itemPrice.getStatus() == 1) {
                item.setMinQuantity(itemPrice.getMinQuantity());
                item.setMaxQuantity(itemPrice.getMaxQuantity());
                item.setPrice(itemPrice.getPrice());
                item.setDiscount(itemPrice.getDiscount());
                item.setTaxable(itemPrice.getTaxable());
                item.setShipping(itemPrice.getShipping());
                item.setUseShippingFormula(itemPrice.getUseShippingFormula());
            }
            if (sale != null || !(itemPrice.getDiscount() > 0.0) || itemPrice.getStatus() != 1 && itemPrice.getStatus() != 2) continue;
            sale = Boolean.TRUE;
        }
        item.setRequiresShipping(requiresShipping);
        item.setStockQuantity(stockQuantity);
        item.setFeatured(featured);
        item.setSale(sale != null ? sale : false);
        item.setSmallImage(smallImage);
        item.setSmallImageId(this.counterLocalService.increment());
        item.setSmallImageURL(smallImageURL);
        item.setMediumImage(mediumImage);
        item.setMediumImageId(this.counterLocalService.increment());
        item.setMediumImageURL(mediumImageURL);
        item.setLargeImage(largeImage);
        item.setLargeImageId(this.counterLocalService.increment());
        item.setLargeImageURL(largeImageURL);
        this.shoppingItemPersistence.update((BaseModel)item);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addItemResources(item, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addItemResources(item, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.saveImages(smallImage, item.getSmallImageId(), smallImageFile, smallImageBytes, mediumImage, item.getMediumImageId(), mediumImageFile, mediumImageBytes, largeImage, item.getLargeImageId(), largeImageFile, largeImageBytes);
        for (ShoppingItemField itemField : itemFields) {
            long itemFieldId = this.counterLocalService.increment();
            itemField.setItemFieldId(itemFieldId);
            itemField.setItemId(itemId);
            itemField.setName(this.checkItemField(itemField.getName()));
            itemField.setValues(this.checkItemField(itemField.getValues()));
            this.shoppingItemFieldPersistence.update((BaseModel)itemField);
        }
        if (itemPrices.size() > 1) {
            for (ShoppingItemPrice itemPrice : itemPrices) {
                long itemPriceId = this.counterLocalService.increment();
                itemPrice.setItemPriceId(itemPriceId);
                itemPrice.setItemId(itemId);
                this.shoppingItemPricePersistence.update((BaseModel)itemPrice);
            }
        }
        return item;
    }

    public void addItemResources(long itemId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        this.addItemResources(item, addGroupPermissions, addGuestPermissions);
    }

    public void addItemResources(long itemId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        this.addItemResources(item, groupPermissions, guestPermissions);
    }

    public void addItemResources(ShoppingItem item, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(item.getCompanyId(), item.getGroupId(), item.getUserId(), ShoppingItem.class.getName(), item.getItemId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addItemResources(ShoppingItem item, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(item.getCompanyId(), item.getGroupId(), item.getUserId(), ShoppingItem.class.getName(), item.getItemId(), groupPermissions, guestPermissions);
    }

    public void deleteItem(long itemId) throws PortalException, SystemException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        this.deleteItem(item);
    }

    public void deleteItem(ShoppingItem item) throws PortalException, SystemException {
        this.shoppingItemPersistence.remove((BaseModel)item);
        this.resourceLocalService.deleteResource(item.getCompanyId(), ShoppingItem.class.getName(), 4, item.getItemId());
        this.imageLocalService.deleteImage(item.getSmallImageId());
        this.imageLocalService.deleteImage(item.getMediumImageId());
        this.imageLocalService.deleteImage(item.getLargeImageId());
        this.shoppingItemFieldPersistence.removeByItemId(item.getItemId());
        this.shoppingItemPricePersistence.removeByItemId(item.getItemId());
    }

    public void deleteItems(long groupId, long categoryId) throws PortalException, SystemException {
        List items = this.shoppingItemPersistence.findByG_C(groupId, categoryId);
        for (ShoppingItem item : items) {
            this.deleteItem(item);
        }
    }

    public int getCategoriesItemsCount(long groupId, List<Long> categoryIds) throws SystemException {
        return this.shoppingItemFinder.countByG_C(groupId, categoryIds);
    }

    public List<ShoppingItem> getFeaturedItems(long groupId, long categoryId, int numOfItems) throws SystemException {
        List childCategories;
        List featuredItems = this.shoppingItemFinder.findByFeatured(groupId, new long[]{categoryId}, numOfItems);
        if (featuredItems.size() == 0 && (childCategories = this.shoppingCategoryPersistence.findByG_P(groupId, categoryId)).size() > 0) {
            long[] categoryIds = new long[childCategories.size()];
            int i2 = 0;
            while (i2 < childCategories.size()) {
                ShoppingCategory childCategory = (ShoppingCategory)childCategories.get(i2);
                categoryIds[i2] = childCategory.getCategoryId();
                ++i2;
            }
            featuredItems = this.shoppingItemFinder.findByFeatured(groupId, categoryIds, numOfItems);
        }
        return featuredItems;
    }

    public ShoppingItem getItem(long itemId) throws PortalException, SystemException {
        return this.shoppingItemPersistence.findByPrimaryKey(itemId);
    }

    public ShoppingItem getItem(long companyId, String sku) throws PortalException, SystemException {
        return this.shoppingItemPersistence.findByC_S(companyId, sku);
    }

    public ShoppingItem getItemByLargeImageId(long largeImageId) throws PortalException, SystemException {
        return this.shoppingItemPersistence.findByLargeImageId(largeImageId);
    }

    public ShoppingItem getItemByMediumImageId(long mediumImageId) throws PortalException, SystemException {
        return this.shoppingItemPersistence.findByMediumImageId(mediumImageId);
    }

    public ShoppingItem getItemBySmallImageId(long smallImageId) throws PortalException, SystemException {
        return this.shoppingItemPersistence.findBySmallImageId(smallImageId);
    }

    public List<ShoppingItem> getItems(long groupId, long categoryId) throws SystemException {
        return this.shoppingItemPersistence.findByG_C(groupId, categoryId);
    }

    public List<ShoppingItem> getItems(long groupId, long categoryId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.shoppingItemPersistence.findByG_C(groupId, categoryId, start, end, obc);
    }

    public int getItemsCount(long groupId, long categoryId) throws SystemException {
        return this.shoppingItemPersistence.countByG_C(groupId, categoryId);
    }

    public ShoppingItem[] getItemsPrevAndNext(long itemId, OrderByComparator obc) throws PortalException, SystemException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        return this.shoppingItemPersistence.findByG_C_PrevAndNext(item.getItemId(), item.getGroupId(), item.getCategoryId(), obc);
    }

    public List<ShoppingItem> getSaleItems(long groupId, long categoryId, int numOfItems) throws SystemException {
        List childCategories;
        List saleItems = this.shoppingItemFinder.findBySale(groupId, new long[]{categoryId}, numOfItems);
        if (saleItems.size() == 0 && (childCategories = this.shoppingCategoryPersistence.findByG_P(groupId, categoryId)).size() > 0) {
            long[] categoryIds = new long[childCategories.size()];
            int i2 = 0;
            while (i2 < childCategories.size()) {
                ShoppingCategory childCategory = (ShoppingCategory)childCategories.get(i2);
                categoryIds[i2] = childCategory.getCategoryId();
                ++i2;
            }
            saleItems = this.shoppingItemFinder.findBySale(groupId, categoryIds, numOfItems);
        }
        return saleItems;
    }

    public List<ShoppingItem> search(long groupId, long[] categoryIds, String keywords, int start, int end) throws SystemException {
        return this.shoppingItemFinder.findByKeywords(groupId, categoryIds, keywords, start, end);
    }

    public int searchCount(long groupId, long[] categoryIds, String keywords) throws SystemException {
        return this.shoppingItemFinder.countByKeywords(groupId, categoryIds, keywords);
    }

    public ShoppingItem updateItem(long userId, long itemId, long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, Boolean sale, boolean smallImage, String smallImageURL, File smallImageFile, boolean mediumImage, String mediumImageURL, File mediumImageFile, boolean largeImage, String largeImageURL, File largeImageFile, List<ShoppingItemField> itemFields, List<ShoppingItemPrice> itemPrices, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        User user = this.userPersistence.findByPrimaryKey(userId);
        categoryId = this.getCategory(item, categoryId);
        sku = StringUtil.toUpperCase((String)sku.trim());
        byte[] smallImageBytes = null;
        byte[] mediumImageBytes = null;
        byte[] largeImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            mediumImageBytes = FileUtil.getBytes((File)mediumImageFile);
            largeImageBytes = FileUtil.getBytes((File)largeImageFile);
        }
        catch (IOException iOException) {}
        this.validate(user.getCompanyId(), itemId, sku, name, smallImage, smallImageURL, smallImageFile, smallImageBytes, mediumImage, mediumImageURL, mediumImageFile, mediumImageBytes, largeImage, largeImageURL, largeImageFile, largeImageBytes);
        item.setModifiedDate(new Date());
        item.setCategoryId(categoryId);
        item.setSku(sku);
        item.setName(name);
        item.setDescription(description);
        item.setProperties(properties);
        item.setFields(itemFields.size() > 0);
        item.setFieldsQuantities(fieldsQuantities);
        for (ShoppingItemPrice itemPrice : itemPrices) {
            if (itemPrice.getStatus() == 1) {
                item.setMinQuantity(itemPrice.getMinQuantity());
                item.setMaxQuantity(itemPrice.getMaxQuantity());
                item.setPrice(itemPrice.getPrice());
                item.setDiscount(itemPrice.getDiscount());
                item.setTaxable(itemPrice.getTaxable());
                item.setShipping(itemPrice.getShipping());
                item.setUseShippingFormula(itemPrice.getUseShippingFormula());
            }
            if (sale != null || !(itemPrice.getDiscount() > 0.0) || itemPrice.getStatus() != 1 && itemPrice.getStatus() != 2) continue;
            sale = Boolean.TRUE;
        }
        item.setRequiresShipping(requiresShipping);
        item.setStockQuantity(stockQuantity);
        item.setFeatured(featured);
        item.setSale(sale != null ? sale : false);
        item.setSmallImage(smallImage);
        item.setSmallImageURL(smallImageURL);
        item.setMediumImage(mediumImage);
        item.setMediumImageURL(mediumImageURL);
        item.setLargeImage(largeImage);
        item.setLargeImageURL(largeImageURL);
        this.shoppingItemPersistence.update((BaseModel)item);
        this.saveImages(smallImage, item.getSmallImageId(), smallImageFile, smallImageBytes, mediumImage, item.getMediumImageId(), mediumImageFile, mediumImageBytes, largeImage, item.getLargeImageId(), largeImageFile, largeImageBytes);
        this.shoppingItemFieldPersistence.removeByItemId(itemId);
        for (ShoppingItemField itemField : itemFields) {
            long itemFieldId = this.counterLocalService.increment();
            itemField.setItemFieldId(itemFieldId);
            itemField.setItemId(itemId);
            itemField.setName(this.checkItemField(itemField.getName()));
            itemField.setValues(this.checkItemField(itemField.getValues()));
            this.shoppingItemFieldPersistence.update((BaseModel)itemField);
        }
        this.shoppingItemPricePersistence.removeByItemId(itemId);
        if (itemPrices.size() > 1) {
            for (ShoppingItemPrice itemPrice : itemPrices) {
                long itemPriceId = this.counterLocalService.increment();
                itemPrice.setItemPriceId(itemPriceId);
                itemPrice.setItemId(itemId);
                this.shoppingItemPricePersistence.update((BaseModel)itemPrice);
            }
        }
        return item;
    }

    protected String checkItemField(String value) {
        return StringUtil.replace((String)value, (String[])new String[]{"&", "'", "=", "|", "\""}, (String[])new String[]{"", "", "", "", ""});
    }

    protected void doAddBookItems(long userId, long groupId, long categoryId, String[] isbns) throws IOException, PortalException, SystemException {
        if (!AmazonRankingsUtil.isEnabled()) {
            throw new AmazonException("Amazon integration is not enabled");
        }
        String tmpDir = SystemProperties.get((String)"java.io.tmpdir");
        int i2 = 0;
        while (i2 < isbns.length && i2 < 50) {
            String isbn = isbns[i2];
            AmazonRankings amazonRankings = AmazonRankingsUtil.getAmazonRankings(isbn);
            if (amazonRankings != null) {
                String name = amazonRankings.getProductName();
                String description = "";
                String properties = this.getBookProperties(amazonRankings);
                int minQuantity = 0;
                int maxQuantity = 0;
                double price = amazonRankings.getListPrice();
                double discount = 1.0 - amazonRankings.getOurPrice() / price;
                boolean taxable = true;
                double shipping = 0.0;
                boolean useShippingFormula = true;
                ShoppingItemPrice itemPrice = this.shoppingItemPricePersistence.create(0L);
                itemPrice.setMinQuantity(minQuantity);
                itemPrice.setMaxQuantity(maxQuantity);
                itemPrice.setPrice(price);
                itemPrice.setDiscount(discount);
                itemPrice.setTaxable(taxable);
                itemPrice.setShipping(shipping);
                itemPrice.setUseShippingFormula(useShippingFormula);
                itemPrice.setStatus(1);
                boolean requiresShipping = true;
                int stockQuantity = 0;
                boolean featured = false;
                Boolean sale = null;
                boolean smallImage = true;
                String smallImageURL = "";
                File smallImageFile = new File(String.valueOf(tmpDir) + File.separatorChar + PwdGenerator.getPassword((int)8, (String[])new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ"}) + ".jpg");
                byte[] smallImageBytes = HttpUtil.URLtoByteArray((String)amazonRankings.getSmallImageURL());
                if (smallImageBytes.length < 1024) {
                    smallImage = false;
                } else {
                    FileOutputStream os = new FileOutputStream(smallImageFile);
                    ((OutputStream)os).write(smallImageBytes);
                    ((OutputStream)os).close();
                }
                boolean mediumImage = true;
                String mediumImageURL = "";
                File mediumImageFile = new File(String.valueOf(tmpDir) + File.separatorChar + PwdGenerator.getPassword((int)8, (String[])new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ"}) + ".jpg");
                byte[] mediumImageBytes = HttpUtil.URLtoByteArray((String)amazonRankings.getMediumImageURL());
                if (mediumImageBytes.length < 1024) {
                    mediumImage = false;
                } else {
                    FileOutputStream os = new FileOutputStream(mediumImageFile);
                    ((OutputStream)os).write(mediumImageBytes);
                    ((OutputStream)os).close();
                }
                boolean largeImage = true;
                String largeImageURL = "";
                File largeImageFile = new File(String.valueOf(tmpDir) + File.separatorChar + PwdGenerator.getPassword((int)8, (String[])new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ"}) + ".jpg");
                byte[] largeImageBytes = HttpUtil.URLtoByteArray((String)amazonRankings.getLargeImageURL());
                if (largeImageBytes.length < 1024) {
                    largeImage = false;
                } else {
                    FileOutputStream os = new FileOutputStream(largeImageFile);
                    ((OutputStream)os).write(largeImageBytes);
                    ((OutputStream)os).close();
                }
                ArrayList<ShoppingItemField> itemFields = new ArrayList<ShoppingItemField>();
                ArrayList<ShoppingItemPrice> itemPrices = new ArrayList<ShoppingItemPrice>();
                itemPrices.add(itemPrice);
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                this.addItem(userId, groupId, categoryId, isbn, name, description, properties, "", requiresShipping, stockQuantity, featured, sale, smallImage, smallImageURL, smallImageFile, mediumImage, mediumImageURL, mediumImageFile, largeImage, largeImageURL, largeImageFile, itemFields, itemPrices, serviceContext);
                smallImageFile.delete();
                mediumImageFile.delete();
                largeImageFile.delete();
            }
            ++i2;
        }
    }

    protected String getBookProperties(AmazonRankings amazonRankings) {
        String isbn = amazonRankings.getISBN();
        String authors = StringUtil.merge((Object[])amazonRankings.getAuthors(), (String)", ");
        String publisher = String.valueOf(amazonRankings.getManufacturer()) + "; (" + amazonRankings.getReleaseDateAsString() + ")";
        String properties = "ISBN=" + isbn + "\nAuthor=" + authors + "\nPublisher=" + publisher;
        return properties;
    }

    protected long getCategory(ShoppingItem item, long categoryId) throws SystemException {
        ShoppingCategory newCategory;
        if (item.getCategoryId() != categoryId && categoryId != 0L && ((newCategory = this.shoppingCategoryPersistence.fetchByPrimaryKey(categoryId)) == null || item.getGroupId() != newCategory.getGroupId())) {
            categoryId = item.getCategoryId();
        }
        return categoryId;
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes, boolean mediumImage, long mediumImageId, File mediumImageFile, byte[] mediumImageBytes, boolean largeImage, long largeImageId, File largeImageFile, byte[] largeImageBytes) throws PortalException, SystemException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
        if (mediumImage) {
            if (mediumImageFile != null && mediumImageBytes != null) {
                this.imageLocalService.updateImage(mediumImageId, mediumImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(mediumImageId);
        }
        if (largeImage) {
            if (largeImageFile != null && largeImageBytes != null) {
                this.imageLocalService.updateImage(largeImageId, largeImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(largeImageId);
        }
    }

    protected void validate(long companyId, long itemId, String sku, String name, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, boolean mediumImage, String mediumImageURL, File mediumImageFile, byte[] mediumImageBytes, boolean largeImage, String largeImageURL, File largeImageFile, byte[] largeImageBytes) throws PortalException, SystemException {
        long largeImageMaxSize;
        int i2;
        if (Validator.isNull((String)sku)) {
            throw new ItemSKUException();
        }
        ShoppingItem item = this.shoppingItemPersistence.fetchByC_S(companyId, sku);
        if (item != null && item.getItemId() != itemId) {
            StringBundler sb = new StringBundler(5);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", sku=");
            sb.append(sku);
            sb.append("}");
            throw new DuplicateItemSKUException(sb.toString());
        }
        if (Validator.isNull((String)name)) {
            throw new ItemNameException();
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("shopping.image.extensions", ",");
        if (smallImage && Validator.isNull((String)smallImageURL) && smallImageFile != null && smallImageBytes != null) {
            long smallImageMaxSize;
            String smallImageName = smallImageFile.getName();
            if (smallImageName != null) {
                boolean validSmallImageExtension = false;
                i2 = 0;
                while (i2 < imageExtensions.length) {
                    if ("*".equals(imageExtensions[i2]) || StringUtil.endsWith((String)smallImageName, (String)imageExtensions[i2])) {
                        validSmallImageExtension = true;
                        break;
                    }
                    ++i2;
                }
                if (!validSmallImageExtension) {
                    throw new ItemSmallImageNameException(smallImageName);
                }
            }
            if ((smallImageMaxSize = PrefsPropsUtil.getLong("shopping.image.small.max.size")) > 0L && (smallImageBytes == null || (long)smallImageBytes.length > smallImageMaxSize)) {
                throw new ItemSmallImageSizeException();
            }
        }
        if (mediumImage && Validator.isNull((String)mediumImageURL) && mediumImageFile != null && mediumImageBytes != null) {
            long mediumImageMaxSize;
            String mediumImageName = mediumImageFile.getName();
            if (mediumImageName != null) {
                boolean validMediumImageExtension = false;
                i2 = 0;
                while (i2 < imageExtensions.length) {
                    if ("*".equals(imageExtensions[i2]) || StringUtil.endsWith((String)mediumImageName, (String)imageExtensions[i2])) {
                        validMediumImageExtension = true;
                        break;
                    }
                    ++i2;
                }
                if (!validMediumImageExtension) {
                    throw new ItemMediumImageNameException(mediumImageName);
                }
            }
            if ((mediumImageMaxSize = PrefsPropsUtil.getLong("shopping.image.medium.max.size")) > 0L && (mediumImageBytes == null || (long)mediumImageBytes.length > mediumImageMaxSize)) {
                throw new ItemMediumImageSizeException();
            }
        }
        if (!largeImage || Validator.isNotNull((String)largeImageURL) || largeImageFile == null || largeImageBytes == null) {
            return;
        }
        String largeImageName = largeImageFile.getName();
        if (largeImageName != null) {
            boolean validLargeImageExtension = false;
            i2 = 0;
            while (i2 < imageExtensions.length) {
                if ("*".equals(imageExtensions[i2]) || StringUtil.endsWith((String)largeImageName, (String)imageExtensions[i2])) {
                    validLargeImageExtension = true;
                    break;
                }
                ++i2;
            }
            if (!validLargeImageExtension) {
                throw new ItemLargeImageNameException(largeImageName);
            }
        }
        if ((largeImageMaxSize = PrefsPropsUtil.getLong("shopping.image.large.max.size")) > 0L && (largeImageBytes == null || (long)largeImageBytes.length > largeImageMaxSize)) {
            throw new ItemLargeImageSizeException();
        }
    }
}

