/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.softwarecatalog.LicenseNameException;
import com.liferay.portlet.softwarecatalog.NoSuchLicenseException;
import com.liferay.portlet.softwarecatalog.RequiredLicenseException;
import com.liferay.portlet.softwarecatalog.action.ActionUtil;
import com.liferay.portlet.softwarecatalog.service.SCLicenseServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditLicenseAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateLicense(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteLicense(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchLicenseException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.software_catalog.error");
            }
            if (e2 instanceof LicenseNameException || e2 instanceof RequiredLicenseException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getLicense((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchLicenseException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.software_catalog.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.software_catalog.edit_license"));
    }

    protected void deleteLicense(ActionRequest actionRequest) throws Exception {
        long licenseId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"licenseId");
        SCLicenseServiceUtil.deleteLicense((long)licenseId);
    }

    protected void updateLicense(ActionRequest actionRequest) throws Exception {
        long licenseId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"licenseId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        boolean openSource = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"openSource");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        boolean recommended = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"recommended");
        if (licenseId <= 0L) {
            SCLicenseServiceUtil.addLicense((String)name, (String)url, (boolean)openSource, (boolean)active, (boolean)recommended);
        } else {
            SCLicenseServiceUtil.updateLicense((long)licenseId, (String)name, (String)url, (boolean)openSource, (boolean)active, (boolean)recommended);
        }
    }
}

