/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines.antlrwiki;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.parsers.creole.ast.ASTNode;
import com.liferay.portal.parsers.creole.ast.WikiPageNode;
import com.liferay.portal.parsers.creole.ast.link.LinkNode;
import com.liferay.portal.parsers.creole.parser.Creole10Lexer;
import com.liferay.portal.parsers.creole.parser.Creole10Parser;
import com.liferay.portal.parsers.creole.visitor.impl.LinkNodeCollectorVisitor;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.engines.WikiEngine;
import com.liferay.portlet.wiki.engines.antlrwiki.translator.XhtmlTranslator;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletURL;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class CreoleWikiEngine
implements WikiEngine {
    private static Log _log = LogFactoryUtil.getLog(CreoleWikiEngine.class);

    @Override
    public String convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        XhtmlTranslator xhtmlTranslator = new XhtmlTranslator();
        return xhtmlTranslator.translate(page, viewPageURL, editPageURL, attachmentURLPrefix, this.parse(page.getContent()));
    }

    @Override
    public Map<String, Boolean> getOutgoingLinks(WikiPage page) throws PageContentException {
        HashMap<String, Boolean> outgoingLinks = new HashMap<String, Boolean>();
        LinkNodeCollectorVisitor linkNodeCollectorVisitor = new LinkNodeCollectorVisitor();
        List<ASTNode> astNodes = linkNodeCollectorVisitor.collect(this.parse(page.getContent()));
        try {
            for (ASTNode astNode : astNodes) {
                LinkNode linkNode = (LinkNode)astNode;
                String title = linkNode.getLink();
                boolean existingLink = false;
                if (WikiPageLocalServiceUtil.getPagesCount((long)page.getNodeId(), (String)title, (boolean)true) > 0) {
                    existingLink = true;
                }
                if (existingLink) {
                    title = StringUtil.toLowerCase((String)title);
                }
                outgoingLinks.put(title, existingLink);
            }
        }
        catch (SystemException se) {
            throw new PageContentException((Throwable)se);
        }
        return outgoingLinks;
    }

    @Override
    public void setInterWikiConfiguration(String interWikiConfiguration) {
    }

    @Override
    public void setMainConfiguration(String mainConfiguration) {
    }

    @Override
    public boolean validate(long nodeId, String content) {
        return true;
    }

    protected Creole10Parser build(String creoleCode) {
        ANTLRStringStream antlrStringStream = new ANTLRStringStream(creoleCode);
        Creole10Lexer creole10Lexer = new Creole10Lexer((CharStream)antlrStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)creole10Lexer);
        return new Creole10Parser((TokenStream)commonTokenStream);
    }

    /*
     * Unable to fully structure code
     */
    protected WikiPageNode parse(String creoleCode) {
        block3: {
            creole10Parser = this.build(creoleCode);
            try {
                creole10Parser.wikipage();
                break block3;
            }
            catch (RecognitionException re) {
                if (!CreoleWikiEngine._log.isDebugEnabled()) break block3;
                CreoleWikiEngine._log.debug((Object)("Unable to parse:\n" + creoleCode), (Throwable)re);
                ** for (error : creole10Parser.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                CreoleWikiEngine._log.debug((Object)error);
                continue;
            }
        }
        return creole10Parser.getWikiPageNode();
    }
}

