/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines.jspwiki;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.engines.WikiEngine;
import com.liferay.portlet.wiki.engines.jspwiki.LiferayJSPWikiEngine;
import com.liferay.portlet.wiki.engines.jspwiki.LiferayPageProvider;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletURL;

public class JSPWikiEngine
implements WikiEngine {
    private static final String[] _JSP_WIKI_NAME_1 = new String[]{"'", "@", "^", "!", "\u00a1", "\u00bf", "`", "?", "/", "*"};
    private static final String[] _JSP_WIKI_NAME_2 = new String[]{"__APO__", "__AT__", "__CAR__", "__EXM__", "__INE__", "__INQ__", "__GRA__", "__QUE__", "__SLA__", "__STA__"};
    private static Log _log = LogFactoryUtil.getLog(JSPWikiEngine.class);
    private static Pattern _wikiCommentPattern = Pattern.compile("[\\{]{3,3}(.*?)[\\}]{3,3}", 32);
    private static Pattern _wikiLinkPattern = Pattern.compile("[\\[]{1,2}(.+?)[\\]]{1,2}", 32);
    private Map<Long, LiferayJSPWikiEngine> _engines = new ConcurrentHashMap<Long, LiferayJSPWikiEngine>();
    private Properties _properties;

    public static String decodeJSPWikiName(String jspWikiName) {
        return StringUtil.replace((String)jspWikiName, (String[])_JSP_WIKI_NAME_2, (String[])_JSP_WIKI_NAME_1);
    }

    @Override
    public String convert(com.liferay.portlet.wiki.model.WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException {
        try {
            return this.convert(page);
        }
        catch (WikiException we) {
            throw new PageContentException((Throwable)we);
        }
    }

    @Override
    public Map<String, Boolean> getOutgoingLinks(com.liferay.portlet.wiki.model.WikiPage page) throws PageContentException {
        if (Validator.isNull((String)page.getContent())) {
            return Collections.emptyMap();
        }
        try {
            LiferayJSPWikiEngine engine = this.getEngine(page.getNodeId());
            WikiPage jspWikiPage = LiferayPageProvider.toJSPWikiPage(page, engine);
            Collection<String> titles = engine.scanWikiLinks(jspWikiPage, JSPWikiEngine._encodeJSPWikiContent(page.getContent()));
            HashMap<String, Boolean> links = new HashMap<String, Boolean>();
            for (String title : titles) {
                if (title.startsWith("[[")) {
                    title = title.substring(2);
                } else if (title.startsWith("[")) {
                    title = title.substring(1);
                }
                if (title.endsWith("]]")) {
                    title = title.substring(0, title.length() - 2);
                } else if (title.endsWith("]")) {
                    title = title.substring(0, title.length() - 1);
                }
                Boolean existsObj = (Boolean)links.get(title);
                if (existsObj != null) continue;
                existsObj = WikiPageLocalServiceUtil.getPagesCount((long)page.getNodeId(), (String)title, (boolean)true) > 0 ? Boolean.TRUE : Boolean.FALSE;
                links.put(title, existsObj);
            }
            return links;
        }
        catch (SystemException se) {
            throw new PageContentException((Throwable)se);
        }
        catch (WikiException we) {
            throw new PageContentException((Throwable)we);
        }
    }

    @Override
    public void setInterWikiConfiguration(String interWikiConfiguration) {
    }

    @Override
    public void setMainConfiguration(String mainConfiguration) {
        this.setProperties(mainConfiguration);
    }

    @Override
    public boolean validate(long nodeId, String newContent) {
        return true;
    }

    protected String convert(com.liferay.portlet.wiki.model.WikiPage page) throws WikiException {
        String content = JSPWikiEngine._encodeJSPWikiContent(page.getContent());
        if (Validator.isNull((String)content)) {
            return "";
        }
        LiferayJSPWikiEngine engine = this.getEngine(page.getNodeId());
        WikiPage jspWikiPage = LiferayPageProvider.toJSPWikiPage(page, engine);
        WikiContext wikiContext = new WikiContext((com.ecyrd.jspwiki.WikiEngine)engine, jspWikiPage);
        return JSPWikiEngine._decodeJSPWikiContent(engine.textToHTML(wikiContext, content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LiferayJSPWikiEngine getEngine(long nodeId) throws WikiException {
        LiferayJSPWikiEngine engine = this._engines.get(nodeId);
        if (engine != null) {
            return engine;
        }
        Map<Long, LiferayJSPWikiEngine> map = this._engines;
        synchronized (map) {
            engine = this._engines.get(nodeId);
            if (engine != null) {
                return engine;
            }
            Properties nodeProperties = new Properties(this._properties);
            nodeProperties.setProperty("nodeId", String.valueOf(nodeId));
            String appName = nodeProperties.getProperty("jspwiki.applicationName");
            nodeProperties.setProperty("jspwiki.applicationName", String.valueOf(appName) + " for node " + nodeId);
            engine = new LiferayJSPWikiEngine(nodeProperties);
            this._engines.put(nodeId, engine);
            return engine;
        }
    }

    protected synchronized void setProperties(String configuration) {
        this._properties = new Properties();
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(configuration.getBytes());
        try {
            this._properties.load((InputStream)is);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
    }

    private static String _decodeJSPWikiContent(String jspWikiContent) {
        return StringUtil.replace((String)jspWikiContent, (String[])_JSP_WIKI_NAME_2, (String[])_JSP_WIKI_NAME_1);
    }

    private static String _encodeJSPWikiContent(String content) {
        StringBundler encodedContent = new StringBundler();
        Matcher commentMatcher = _wikiCommentPattern.matcher(content);
        int start = 0;
        int end = 0;
        while (commentMatcher.find()) {
            end = commentMatcher.start();
            String oldContent = content.substring(start, end);
            Matcher wikiLinkMatcher = _wikiLinkPattern.matcher(oldContent);
            encodedContent.append(JSPWikiEngine._encodeLink(oldContent, wikiLinkMatcher));
            encodedContent.append(content.substring(commentMatcher.start(), commentMatcher.end()));
            start = commentMatcher.end();
        }
        if (start < content.length()) {
            content = content.substring(start);
            Matcher wikiLinkMatcher = _wikiLinkPattern.matcher(content);
            encodedContent.append(JSPWikiEngine._encodeLink(content, wikiLinkMatcher));
        }
        return encodedContent.toString();
    }

    private static String _encodeJSPWikiName(String name) {
        if (name == null) {
            return "";
        }
        return StringUtil.replace((String)name, (String[])_JSP_WIKI_NAME_1, (String[])_JSP_WIKI_NAME_2);
    }

    private static String _encodeLink(String content, Matcher wikiLinkMatcher) {
        while (wikiLinkMatcher.find()) {
            String linkValues;
            String link = wikiLinkMatcher.group();
            String name = linkValues = wikiLinkMatcher.group(1);
            String url = linkValues;
            int pos = linkValues.indexOf(124);
            if (pos != -1) {
                name = linkValues.substring(pos + 1);
                url = linkValues.substring(0, pos);
            }
            String newLink = "[[" + JSPWikiEngine._encodeJSPWikiName(url) + "|" + JSPWikiEngine._encodeJSPWikiName(name) + "]]";
            content = StringUtil.replace((String)content, (String)link, (String)newLink);
        }
        return content;
    }
}

