/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Repository;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.service.TrashEntryLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageBaseImpl;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WikiPageImpl
extends WikiPageBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(WikiPageImpl.class);
    private long _attachmentsFolderId;

    public Folder addAttachmentsFolder() throws PortalException, SystemException {
        if (this._attachmentsFolderId != 0L) {
            return PortletFileRepositoryUtil.getPortletFolder((long)this._attachmentsFolderId);
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)this.getGroupId(), (String)"36", (ServiceContext)serviceContext);
        WikiNode node = this.getNode();
        Folder nodeFolder = node.addAttachmentsFolder();
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)this.getUserId(), (long)repository.getRepositoryId(), (long)nodeFolder.getFolderId(), (String)String.valueOf(this.getResourcePrimKey()), (ServiceContext)serviceContext);
        this._attachmentsFolderId = folder.getFolderId();
        return folder;
    }

    public WikiPage fetchParentPage() throws SystemException {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.fetchPage((long)this.getNodeId(), (String)this.getParentTitle());
    }

    public WikiPage fetchRedirectPage() throws SystemException {
        if (Validator.isNull((String)this.getRedirectTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.fetchPage((long)this.getNodeId(), (String)this.getRedirectTitle());
    }

    public List<FileEntry> getAttachmentsFileEntries() throws SystemException {
        return this.getAttachmentsFileEntries(-1, -1);
    }

    public List<FileEntry> getAttachmentsFileEntries(int start, int end) throws SystemException {
        List<Object> fileEntries = new ArrayList<FileEntry>();
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (int)0, (int)start, (int)end, null);
        }
        return fileEntries;
    }

    public int getAttachmentsFileEntriesCount() throws SystemException {
        int attachmentsFileEntriesCount = 0;
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            attachmentsFileEntriesCount = PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)attachmentsFolderId, (int)0);
        }
        return attachmentsFileEntriesCount;
    }

    public long getAttachmentsFolderId() throws SystemException {
        if (this._attachmentsFolderId != 0L) {
            return this._attachmentsFolderId;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)this.getGroupId(), (String)"36");
        long nodeAttachmentsFolderId = this.getNodeAttachmentsFolderId();
        if (repository == null || nodeAttachmentsFolderId == 0L) {
            return 0L;
        }
        try {
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)this.getUserId(), (long)repository.getRepositoryId(), (long)nodeAttachmentsFolderId, (String)String.valueOf(this.getResourcePrimKey()), (ServiceContext)serviceContext);
            this._attachmentsFolderId = folder.getFolderId();
        }
        catch (Exception exception) {}
        return this._attachmentsFolderId;
    }

    public List<WikiPage> getChildPages() {
        try {
            return WikiPageLocalServiceUtil.getChildren((long)this.getNodeId(), (boolean)true, (String)this.getTitle());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return Collections.emptyList();
        }
    }

    public List<FileEntry> getDeletedAttachmentsFileEntries() throws SystemException {
        return this.getDeletedAttachmentsFileEntries(-1, -1);
    }

    public List<FileEntry> getDeletedAttachmentsFileEntries(int start, int end) throws SystemException {
        List<Object> fileEntries = new ArrayList<FileEntry>();
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (int)8, (int)start, (int)end, null);
        }
        return fileEntries;
    }

    public int getDeletedAttachmentsFileEntriesCount() throws SystemException {
        int deletedAttachmentsFileEntriesCount = 0;
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            return PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)attachmentsFolderId, (int)8);
        }
        return deletedAttachmentsFileEntriesCount;
    }

    public WikiNode getNode() {
        try {
            return WikiNodeLocalServiceUtil.getNode((long)this.getNodeId());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return new WikiNodeImpl();
        }
    }

    public long getNodeAttachmentsFolderId() throws SystemException {
        WikiNode node = this.getNode();
        return node.getAttachmentsFolderId();
    }

    public WikiPage getParentPage() throws PortalException, SystemException {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.getPage((long)this.getNodeId(), (String)this.getParentTitle());
    }

    public List<WikiPage> getParentPages() throws SystemException {
        ArrayList<WikiPage> parentPages = new ArrayList<WikiPage>();
        WikiPage parentPage = this.fetchParentPage();
        if (parentPage != null) {
            parentPages.addAll(parentPage.getParentPages());
            parentPages.add(parentPage);
        }
        return parentPages;
    }

    public WikiPage getRedirectPage() throws PortalException, SystemException {
        if (Validator.isNull((String)this.getRedirectTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.getPage((long)this.getNodeId(), (String)this.getRedirectTitle());
    }

    @Override
    public long getTrashEntryClassPK() {
        return this.getResourcePrimKey();
    }

    public List<WikiPage> getViewableChildPages() {
        try {
            return WikiPageServiceUtil.getChildren((long)this.getGroupId(), (long)this.getNodeId(), (boolean)true, (String)this.getTitle());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return Collections.emptyList();
        }
    }

    public WikiPage getViewableParentPage() {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        try {
            return WikiPageServiceUtil.getPage((long)this.getGroupId(), (long)this.getNodeId(), (String)this.getParentTitle());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    public List<WikiPage> getViewableParentPages() {
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        WikiPage page = this.getViewableParentPage();
        if (page != null) {
            pages.addAll(page.getViewableParentPages());
            pages.add(page);
        }
        return pages;
    }

    public boolean isInTrashExplicitly() throws SystemException {
        if (!this.isInTrash()) {
            return false;
        }
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry((String)this.getModelClassName(), (long)this.getTrashEntryClassPK());
        return trashEntry != null;
    }

    @Override
    public boolean isResourceMain() {
        return this.isHead();
    }

    public void setAttachmentsFolderId(long attachmentsFolderId) {
        this._attachmentsFolderId = attachmentsFolderId;
    }
}

