/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;

public abstract class LockInfo {
    private static final long MAXIMUM_TIMEOUT = 3153600000L;
    private final NodeId id;
    private final boolean sessionScoped;
    private final boolean deep;
    private final String lockOwner;
    private final long timeoutHint;
    private long timeoutTime;
    private boolean live;
    private SessionImpl lockHolder;

    protected LockInfo(NodeId id, boolean sessionScoped, boolean deep, String lockOwner, long timeoutHint) {
        this.id = id;
        this.sessionScoped = sessionScoped;
        this.deep = deep;
        this.lockOwner = lockOwner;
        this.timeoutHint = timeoutHint;
        this.updateTimeoutTime();
    }

    protected LockInfo(LockInfo that) {
        this.id = that.id;
        this.sessionScoped = that.sessionScoped;
        this.deep = that.deep;
        this.lockOwner = that.lockOwner;
        this.timeoutHint = that.timeoutHint;
        this.timeoutTime = that.timeoutTime;
    }

    public String getLockToken() {
        String uuid = this.id.toString();
        return uuid + "-" + LockInfo.getLockTokenCheckDigit(uuid);
    }

    public NodeId getId() {
        return this.id;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public boolean isDeep() {
        return this.deep;
    }

    public boolean isLockHolder(Session session) {
        return this.lockHolder == session;
    }

    public SessionImpl getLockHolder() {
        return this.lockHolder;
    }

    public void setLockHolder(SessionImpl lockHolder) {
        this.lockHolder = lockHolder;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public boolean mayChange() {
        return this.live;
    }

    public boolean isSessionScoped() {
        return this.sessionScoped;
    }

    public long getTimeoutHint() {
        return this.timeoutHint;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public boolean isExpired() {
        return this.timeoutTime != Long.MAX_VALUE && this.timeoutTime * 1000L > System.currentTimeMillis();
    }

    public void updateTimeoutTime() {
        if (this.timeoutHint > 0L && this.timeoutHint <= 3153600000L) {
            long now = (System.currentTimeMillis() + 999L) / 1000L;
            this.timeoutTime = now + this.timeoutHint;
        } else {
            this.timeoutTime = Long.MAX_VALUE;
        }
    }

    public void throwLockException(String message, SessionImpl session) throws LockException, RepositoryException {
        String path;
        try {
            path = session.getJCRPath(session.getHierarchyManager().getPath(this.id));
        }
        catch (RepositoryException ignored) {
            path = null;
        }
        if (path != null) {
            throw new LockException(message + " (lock held by node " + path + ")", null, path);
        }
        throw new LockException(message);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        if (this.deep) {
            buffer.append("deep ");
        }
        if (this.sessionScoped) {
            buffer.append("session ");
        }
        buffer.append("holder:");
        if (this.lockHolder != null) {
            buffer.append(this.lockHolder.getUserID());
        } else {
            buffer.append("none");
        }
        buffer.append("owner:").append(this.lockOwner);
        buffer.append(')');
        return buffer.toString();
    }

    public static NodeId parseLockToken(String token) throws IllegalArgumentException {
        int sep = token.lastIndexOf(45);
        if (sep == -1 || sep == token.length() - 1) {
            throw new IllegalArgumentException("Separator not found.");
        }
        String uuid = token.substring(0, sep);
        if (LockInfo.getLockTokenCheckDigit(uuid) != token.charAt(token.length() - 1)) {
            throw new IllegalArgumentException("Bad check digit.");
        }
        return NodeId.valueOf(uuid);
    }

    private static char getLockTokenCheckDigit(String uuid) {
        int result = 0;
        int multiplier = 36;
        for (int i = 0; i < uuid.length(); ++i) {
            int num;
            char c = uuid.charAt(i);
            if (c >= '0' && c <= '9') {
                num = c - 48;
                result += multiplier * num;
                --multiplier;
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                num = c - 65 + 10;
                result += multiplier * num;
                --multiplier;
                continue;
            }
            if (c < 'a' || c > 'f') continue;
            num = c - 97 + 10;
            result += multiplier * num;
            --multiplier;
        }
        int rem = result % 37;
        if (rem != 0) {
            rem = 37 - rem;
        }
        if (rem >= 0 && rem <= 9) {
            return (char)(48 + rem);
        }
        if (rem >= 10 && rem <= 35) {
            return (char)(65 + rem - 10);
        }
        return '+';
    }
}

