/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.AQTQueryFactory;
import org.apache.jackrabbit.core.query.CompoundQueryFactory;
import org.apache.jackrabbit.core.query.QOMQueryFactory;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryManagerImpl
implements QueryManager {
    private final SessionImpl session;
    private final ItemManager itemMgr;
    private final SearchManager searchMgr;
    private final QueryObjectModelFactoryImpl qomFactory;

    public QueryManagerImpl(final SessionImpl session, ItemManager itemMgr, final SearchManager searchMgr) throws RepositoryException {
        this.session = session;
        this.itemMgr = itemMgr;
        this.searchMgr = searchMgr;
        this.qomFactory = new QueryObjectModelFactoryImpl(session){

            protected QueryObjectModel createQuery(QueryObjectModelTree qomTree) throws InvalidQueryException, RepositoryException {
                return searchMgr.createQueryObjectModel(session, qomTree, "JCR-JQOM", null);
            }
        };
    }

    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        this.sanityCheck();
        QueryFactoryImpl qf = new QueryFactoryImpl(language);
        return qf.createQuery(statement, language);
    }

    public Query getQuery(Node node) throws InvalidQueryException, RepositoryException {
        this.sanityCheck();
        if (!node.isNodeType(this.session.getJCRName(NameConstants.NT_QUERY))) {
            throw new InvalidQueryException("node is not of type nt:query");
        }
        String statement = node.getProperty(this.session.getJCRName(NameConstants.JCR_STATEMENT)).getString();
        String language = node.getProperty(this.session.getJCRName(NameConstants.JCR_LANGUAGE)).getString();
        QueryFactoryImpl qf = new QueryFactoryImpl(node, language);
        return qf.createQuery(statement, language);
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        List<String> languages = new QueryFactoryImpl("JCR-JQOM").getSupportedLanguages();
        return languages.toArray(new String[languages.size()]);
    }

    public QueryObjectModelFactory getQOMFactory() {
        return this.qomFactory;
    }

    public Iterable<Node> getWeaklyReferringNodes(Node node) throws RepositoryException {
        this.sanityCheck();
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            NodeId nodeId = new NodeId(node.getIdentifier());
            for (NodeId id : this.searchMgr.getWeaklyReferringNodes(nodeId)) {
                nodes.add(this.session.getNodeById(id));
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return nodes;
    }

    QueryHandler getQueryHandler() {
        return this.searchMgr.getQueryHandler();
    }

    private void sanityCheck() throws RepositoryException {
        if (!this.session.isLive()) {
            throw new RepositoryException("corresponding session has been closed");
        }
    }

    private class QueryFactoryImpl
    extends CompoundQueryFactory {
        public QueryFactoryImpl(String language) {
            this(null, language);
        }

        public QueryFactoryImpl(final Node node, final String language) {
            super(Arrays.asList(new QOMQueryFactory((QueryObjectModelFactory)new QueryObjectModelFactoryImpl(QueryManagerImpl.this.session){

                protected QueryObjectModel createQuery(QueryObjectModelTree qomTree) throws InvalidQueryException, RepositoryException {
                    return QueryManagerImpl.this.searchMgr.createQueryObjectModel(QueryManagerImpl.this.session, qomTree, language, node);
                }
            }, QueryManagerImpl.this.session.getValueFactory()), new AQTQueryFactory(){

                public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
                    return QueryManagerImpl.this.searchMgr.createQuery(QueryManagerImpl.this.session, QueryManagerImpl.this.itemMgr, statement, language, node);
                }
            }));
        }
    }
}

