/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.spi.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryImpl
implements ExecutableQuery {
    protected final SessionImpl session;
    protected final ItemManager itemMgr;
    protected final SearchIndex index;
    protected final PropertyTypeRegistry propReg;
    private boolean documentOrder = true;
    private final Set<Name> variableNames = new HashSet<Name>();
    private final Map<Name, Value> bindValues = new HashMap<Name, Value>();

    public AbstractQueryImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg) {
        this.session = session;
        this.itemMgr = itemMgr;
        this.index = index;
        this.propReg = propReg;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setRespectDocumentOrder(boolean documentOrder) {
        this.documentOrder = documentOrder;
    }

    @Override
    public void bindValue(Name varName, Value value) throws IllegalArgumentException, RepositoryException {
        if (!this.variableNames.contains(varName)) {
            throw new IllegalArgumentException("not a valid variable in this query");
        }
        this.bindValues.put(varName, value);
    }

    @Override
    public Name[] getBindVariableNames() throws RepositoryException {
        return this.variableNames.toArray(new Name[this.variableNames.size()]);
    }

    protected void addVariableName(Name varName) {
        this.variableNames.add(varName);
    }

    protected Map<Name, Value> getBindVariableValues() {
        return Collections.unmodifiableMap(this.bindValues);
    }

    protected QueryObjectModelFactory getQOMFactory() throws RepositoryException {
        return this.session.getWorkspace().getQueryManager().getQOMFactory();
    }

    public abstract boolean needsSystemTree();
}

