/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

public class PropInfo {
    private final Name name;
    private final int type;
    private final TextValue[] values;

    public PropInfo(Name name, int type, TextValue[] values) {
        this.name = name;
        this.type = type;
        this.values = values;
    }

    public void dispose() {
        for (TextValue value : this.values) {
            value.dispose();
        }
    }

    public int getTargetType(QPropertyDefinition def) {
        int target = def.getRequiredType();
        if (target != 0) {
            return target;
        }
        if (this.type != 0) {
            return this.type;
        }
        return 1;
    }

    public QPropertyDefinition getApplicablePropertyDef(EffectiveNodeType ent) throws ConstraintViolationException {
        if (this.values.length == 1) {
            return ent.getApplicablePropertyDef(this.name, this.type);
        }
        return ent.getApplicablePropertyDef(this.name, this.type, true);
    }

    public Name getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public TextValue[] getTextValues() {
        return this.values;
    }

    public Value[] getValues(int targetType, NamePathResolver resolver) throws RepositoryException {
        Value[] va = new Value[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            va[i] = this.values[i].getValue(targetType, resolver);
        }
        return va;
    }
}

