/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JsonFieldNameValidator {
    private static final Pattern JSON_FIELD_NAME_PATTERN = Pattern.compile("(^[a-zA-Z][a-zA-Z0-9\\$_\\-]*$)|(^[\\$_][a-zA-Z][a-zA-Z0-9\\$_\\-]*$)");

    JsonFieldNameValidator() {
    }

    public String validate(String fieldName) {
        Preconditions.checkNotNull(fieldName);
        Preconditions.checkArgument(!"".equals(fieldName.trim()));
        Matcher matcher = JSON_FIELD_NAME_PATTERN.matcher(fieldName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(fieldName + " is not a valid JSON field name.");
        }
        return fieldName;
    }
}

