/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.Map;
import java.util.Set;
import jodd.bean.BeanUtil;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.util.ArraysUtil;

public abstract class BeanVisitor {
    protected Object source;
    protected String[] excludeNames;
    protected String[] includeNames;
    protected boolean declared;
    protected boolean ignoreNullValues;

    protected String[] resolveProperties(Object bean, boolean declared) {
        String[] properties;
        if (bean instanceof Map) {
            Set keys = ((Map)bean).keySet();
            properties = new String[keys.size()];
            int ndx = 0;
            for (Object key : keys) {
                properties[ndx] = key.toString();
                ++ndx;
            }
        } else {
            ClassDescriptor classDescriptor = ClassIntrospector.lookup(bean.getClass());
            properties = classDescriptor.getAllBeanGetterNames(declared);
        }
        return properties;
    }

    public void visit() {
        String[] properties;
        for (String name : properties = this.resolveProperties(this.source, false)) {
            Object value;
            if (this.excludeNames != null && ArraysUtil.contains(this.excludeNames, name) || this.includeNames != null && !ArraysUtil.contains(this.includeNames, name) || (value = this.declared ? BeanUtil.getDeclaredProperty(this.source, name) : BeanUtil.getProperty(this.source, name)) == null && this.ignoreNullValues) continue;
            this.visitProperty(name, value);
        }
    }

    protected abstract boolean visitProperty(String var1, Object var2);
}

