/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import jodd.mail.MailException;
import jodd.mail.SendMailSession;
import jodd.mail.SendMailSessionProvider;
import jodd.mail.SimpleAuthenticator;

public class SmtpServer
implements SendMailSessionProvider {
    protected static final String MAIL_HOST = "mail.host";
    protected static final String MAIL_SMTP_HOST = "mail.smtp.host";
    protected static final String MAIL_SMTP_PORT = "mail.smtp.port";
    protected static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    protected static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    protected static final String PROTOCOL_SMTP = "smtp";
    protected static final int DEFAULT_SMTP_PORT = 25;
    protected final String host;
    protected final int port;
    protected final Authenticator authenticator;
    protected final Properties sessionProperties;

    public SmtpServer(String host) {
        this(host, 25, null);
    }

    public SmtpServer(String host, int port) {
        this(host, port, null);
    }

    public SmtpServer(String host, Authenticator authenticator) {
        this(host, 25, authenticator);
    }

    public SmtpServer(String host, int port, String username, String password) {
        this(host, port, new SimpleAuthenticator(username, password));
    }

    public SmtpServer(String host, String username, String password) {
        this(host, 25, new SimpleAuthenticator(username, password));
    }

    public SmtpServer(String host, int port, Authenticator authenticator) {
        this.host = host;
        this.port = port;
        this.authenticator = authenticator;
        this.sessionProperties = this.createSessionProperties();
    }

    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty(MAIL_TRANSPORT_PROTOCOL, PROTOCOL_SMTP);
        props.setProperty(MAIL_HOST, this.host);
        props.setProperty(MAIL_SMTP_HOST, this.host);
        props.setProperty(MAIL_SMTP_PORT, String.valueOf(this.port));
        if (this.authenticator != null) {
            props.setProperty(MAIL_SMTP_AUTH, "true");
        }
        return props;
    }

    public SendMailSession createSession() {
        Transport mailTransport;
        Session mailSession = Session.getInstance((Properties)this.sessionProperties, (Authenticator)this.authenticator);
        try {
            mailTransport = this.getTransport(mailSession);
        }
        catch (NoSuchProviderException nspex) {
            throw new MailException(nspex);
        }
        return new SendMailSession(mailSession, mailTransport);
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return session.getTransport(PROTOCOL_SMTP);
    }

    public String getHost() {
        return this.host;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getPort() {
        return this.port;
    }
}

