/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.petite.BeanDefinition;
import jodd.petite.CtorInjectionPoint;
import jodd.petite.InitMethodPoint;
import jodd.petite.InjectionPointFactory;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.ProviderDefinition;
import jodd.petite.SetInjectionPoint;
import jodd.petite.resolver.CtorResolver;
import jodd.petite.resolver.InitMethodResolver;
import jodd.petite.resolver.MethodResolver;
import jodd.petite.resolver.PropertyResolver;
import jodd.petite.resolver.ProviderResolver;
import jodd.petite.resolver.SetResolver;

public class PetiteResolvers {
    protected CtorResolver ctorResolver;
    protected PropertyResolver propertyResolver;
    protected MethodResolver methodResolver;
    protected SetResolver setResolver;
    protected InitMethodResolver initMethodResolver;
    protected ProviderResolver providerResolver;

    public PetiteResolvers(InjectionPointFactory injectionPointFactory) {
        this.ctorResolver = new CtorResolver(injectionPointFactory);
        this.propertyResolver = new PropertyResolver(injectionPointFactory);
        this.methodResolver = new MethodResolver(injectionPointFactory);
        this.setResolver = new SetResolver(injectionPointFactory);
        this.initMethodResolver = new InitMethodResolver();
        this.providerResolver = new ProviderResolver();
    }

    public CtorInjectionPoint resolveCtorInjectionPoint(Class type) {
        return this.ctorResolver.resolve(type, true);
    }

    public PropertyInjectionPoint[] resolvePropertyInjectionPoint(Class type, boolean autowire) {
        return this.propertyResolver.resolve(type, autowire);
    }

    public MethodInjectionPoint[] resolveMethodInjectionPoint(Class type) {
        return this.methodResolver.resolve(type);
    }

    public SetInjectionPoint[] resolveSetInjectionPoint(Class type, boolean autowire) {
        return this.setResolver.resolve(type, autowire);
    }

    public InitMethodPoint[] resolveInitMethodPoint(Object bean) {
        return this.initMethodResolver.resolve(bean);
    }

    public ProviderDefinition[] resolveProviderDefinitions(BeanDefinition beanDefinition) {
        return this.providerResolver.resolve(beanDefinition);
    }
}

