/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import jodd.JoddProxetta;
import jodd.asm.EmptyClassVisitor;
import jodd.asm.EmptyMethodVisitor;
import jodd.asm.MethodAdapter;
import jodd.asm4.ClassReader;
import jodd.asm4.FieldVisitor;
import jodd.asm4.Label;
import jodd.asm4.MethodVisitor;
import jodd.io.StreamUtil;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyAdvice;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.ProxyPointcut;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.proxetta.asm.WorkData;
import jodd.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProxyAspectData {
    final ClassReader adviceClassReader;
    final ProxyAspect aspect;
    final Class<? extends ProxyAdvice> advice;
    final ProxyPointcut pointcut;
    final int aspectIndex;
    final WorkData wd;
    String adviceReference;
    boolean ready;
    int maxLocalVarOffset;
    private static Map<Class<? extends ProxyAdvice>, ClassReader> adviceClassReaderCache;

    ProxyAspectData(WorkData wd, ProxyAspect aspect, int aspectIndex) {
        this.aspect = aspect;
        this.advice = aspect.getAdvice();
        this.pointcut = aspect.getPointcut();
        this.aspectIndex = aspectIndex;
        this.wd = wd;
        this.adviceClassReader = this.getCachedAdviceClassReader(this.advice);
        this.readAdviceData();
    }

    boolean apply(MethodInfo msign) {
        return this.pointcut.apply(msign);
    }

    private ClassReader createAdviceClassReader(Class<? extends ProxyAdvice> advice) {
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtil.getClassAsStream(advice);
            ClassReader classReader = new ClassReader(inputStream);
            return classReader;
        }
        catch (IOException ioex) {
            throw new ProxettaException(ioex);
        }
        finally {
            StreamUtil.close(inputStream);
        }
    }

    private ClassReader getCachedAdviceClassReader(Class<? extends ProxyAdvice> advice) {
        ClassReader adviceReader;
        if (adviceClassReaderCache == null) {
            adviceClassReaderCache = new HashMap<Class<? extends ProxyAdvice>, ClassReader>();
        }
        if ((adviceReader = adviceClassReaderCache.get(advice)) == null) {
            adviceReader = this.createAdviceClassReader(advice);
            adviceClassReaderCache.put(advice, adviceReader);
        }
        return adviceReader;
    }

    ClassReader getAdviceClassReader() {
        return this.adviceClassReader;
    }

    private void readAdviceData() {
        if (this.ready) {
            return;
        }
        this.adviceClassReader.accept(new EmptyClassVisitor(){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ProxyAspectData.this.adviceReference = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                throw new ProxettaException("Proxetta doesn't allow inner classes in/for advice: " + ProxyAspectData.this.advice.getName());
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                ProxyAspectData.this.wd.dest.visitField(access, ProxettaAsmUtil.adviceFieldName(name, ProxyAspectData.this.aspectIndex), desc, signature, value);
                return super.visitField(access, name, desc, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("<clinit>")) {
                    if (!desc.equals("()V")) {
                        throw new ProxettaException("Invalid static initialization block description for advice: " + ProxyAspectData.this.advice.getName());
                    }
                    name = JoddProxetta.clinitMethodName + JoddProxetta.methodDivider + ProxyAspectData.this.aspectIndex;
                    ProxyAspectData.this.wd.addAdviceClinitMethod(name);
                    return new MethodAdapter(ProxyAspectData.this.wd.dest.visitMethod(access |= 0x12, name, desc, signature, exceptions)){

                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        }

                        public void visitLineNumber(int line, Label start) {
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            if (opcode == 184 && owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc);
                        }

                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceFieldName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                        }
                    };
                }
                if (name.equals("<init>")) {
                    if (!desc.equals("()V")) {
                        throw new ProxettaException("Advices can have only default constructors. Invalid advice: " + ProxyAspectData.this.advice.getName());
                    }
                    name = JoddProxetta.initMethodName + JoddProxetta.methodDivider + ProxyAspectData.this.aspectIndex;
                    access = ProxettaAsmUtil.makePrivateFinalAccess(access);
                    ProxyAspectData.this.wd.addAdviceInitMethod(name);
                    return new MethodAdapter(ProxyAspectData.this.wd.dest.visitMethod(access, name, desc, signature, exceptions)){
                        int state;

                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        }

                        public void visitLineNumber(int line, Label start) {
                        }

                        public void visitVarInsn(int opcode, int var) {
                            if (this.state == 0 && opcode == 25 && var == 0) {
                                ++this.state;
                                return;
                            }
                            super.visitVarInsn(opcode, var);
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            if (this.state == 1 && opcode == 183) {
                                ++this.state;
                                return;
                            }
                            if (opcode == 182 || opcode == 185) {
                                if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                    owner = ProxyAspectData.this.wd.thisReference;
                                    name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                                }
                            } else if (opcode == 184 && owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc);
                        }

                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceFieldName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                        }
                    };
                }
                if (!name.equals(JoddProxetta.executeMethodName)) {
                    name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                    return new MethodAdapter(ProxyAspectData.this.wd.dest.visitMethod(access, name, desc, signature, exceptions)){

                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        }

                        public void visitLineNumber(int line, Label start) {
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            if (opcode == 182 || opcode == 185) {
                                if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                    owner = ProxyAspectData.this.wd.thisReference;
                                    name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                                }
                            } else if ((opcode == 184 || opcode == 183) && owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc);
                        }

                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceFieldName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                        }
                    };
                }
                return new EmptyMethodVisitor(){

                    public void visitVarInsn(int opcode, int var) {
                        if (ProxettaAsmUtil.isStoreOpcode(opcode) && var > ProxyAspectData.this.maxLocalVarOffset) {
                            ProxyAspectData.this.maxLocalVarOffset = var;
                        }
                        super.visitVarInsn(opcode, var);
                    }
                };
            }
        }, 0);
        this.maxLocalVarOffset += 2;
        this.ready = true;
    }
}

