/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jodd.util.ref.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    protected ConcurrentMap<Object, Object> delegate;
    protected final ReferenceType keyReferenceType;
    protected final ReferenceType valueReferenceType;
    private volatile Set<Map.Entry<K, V>> entrySet;

    public ReferenceMap(ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        if (keyReferenceType == null || valueReferenceType == null) {
            throw new IllegalArgumentException("References types can not be null");
        }
        if (keyReferenceType == ReferenceType.PHANTOM || valueReferenceType == ReferenceType.PHANTOM) {
            throw new IllegalArgumentException("Phantom references not supported");
        }
        this.delegate = new ConcurrentHashMap<Object, Object>();
        this.keyReferenceType = keyReferenceType;
        this.valueReferenceType = valueReferenceType;
    }

    @Override
    public V get(Object key) {
        Object valueReference = this.delegate.get(this.makeKeyReferenceAware(key));
        return this.dereferenceValue(valueReference);
    }

    private V execute(Strategy strategy, K key, V value) {
        Object keyReference = this.referenceKey(key);
        return (V)strategy.execute(this, keyReference, this.referenceValue(keyReference, value));
    }

    @Override
    public V put(K key, V value) {
        return this.execute(PutStrategy.PUT, key, value);
    }

    @Override
    public V remove(Object key) {
        Object referenceAwareKey = this.makeKeyReferenceAware(key);
        Object valueReference = this.delegate.remove(referenceAwareKey);
        return this.dereferenceValue(valueReference);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Object referenceAwareKey = this.makeKeyReferenceAware(key);
        return this.delegate.containsKey(referenceAwareKey);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object valueReference : this.delegate.values()) {
            if (!value.equals(this.dereferenceValue(valueReference))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.execute(PutStrategy.PUT_IF_ABSENT, key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(this.makeKeyReferenceAware(key), this.makeValueReferenceAware(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object keyReference = this.referenceKey(key);
        Object referenceAwareOldValue = this.makeValueReferenceAware(oldValue);
        return this.delegate.replace(keyReference, referenceAwareOldValue, this.referenceValue(keyReference, newValue));
    }

    @Override
    public V replace(K key, V value) {
        return this.execute(PutStrategy.REPLACE, key, value);
    }

    Entry dereferenceEntry(Map.Entry<Object, Object> entry) {
        K key = this.dereferenceKey(entry.getKey());
        V value = this.dereferenceValue(entry.getValue());
        return key == null || value == null ? null : new Entry(key, value);
    }

    Object referenceKey(K key) {
        switch (this.keyReferenceType) {
            case STRONG: {
                return key;
            }
            case SOFT: {
                return new SoftKeyReference(key);
            }
            case WEAK: {
                return new WeakKeyReference(key);
            }
        }
        throw new AssertionError();
    }

    K dereferenceKey(Object o) {
        return (K)this.dereference(this.keyReferenceType, o);
    }

    V dereferenceValue(Object o) {
        if (o == null) {
            return null;
        }
        Object value = this.dereference(this.valueReferenceType, o);
        if (o instanceof InternalReference) {
            InternalReference reference = (InternalReference)o;
            if (value == null) {
                reference.finalizeReferent();
            }
        }
        return (V)value;
    }

    private Object dereference(ReferenceType referenceType, Object reference) {
        return referenceType == ReferenceType.STRONG ? reference : ((Reference)reference).get();
    }

    Object referenceValue(Object keyReference, Object value) {
        switch (this.valueReferenceType) {
            case STRONG: {
                return value;
            }
            case SOFT: {
                return new SoftValueReference(keyReference, value);
            }
            case WEAK: {
                return new WeakValueReference(keyReference, value);
            }
        }
        throw new AssertionError();
    }

    private Object makeKeyReferenceAware(Object o) {
        return this.keyReferenceType == ReferenceType.STRONG ? o : new KeyReferenceAwareWrapper(o);
    }

    private Object makeValueReferenceAware(Object o) {
        return this.valueReferenceType == ReferenceType.STRONG ? o : new ReferenceAwareWrapper(o);
    }

    private static boolean referenceEquals(Reference r, Object o) {
        if (o instanceof InternalReference) {
            if (o == r) {
                return true;
            }
            Object referent = ((Reference)o).get();
            return referent != null && referent == r.get();
        }
        return ((ReferenceAwareWrapper)o).unwrap() == r.get();
    }

    private static boolean isExpired(Object valueReference, Object value) {
        return valueReference != null && value == null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferenceIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<Object, Object>> i;
        private Map.Entry<K, V> nextEntry;
        private Map.Entry<K, V> lastReturned;

        private ReferenceIterator() {
            this.i = ReferenceMap.this.delegate.entrySet().iterator();
            this.advanceToNext();
        }

        private void advanceToNext() {
            while (this.i.hasNext()) {
                Entry entry = ReferenceMap.this.dereferenceEntry(this.i.next());
                if (entry == null) continue;
                this.nextEntry = entry;
                return;
            }
            this.nextEntry = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advanceToNext();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            ReferenceMap.this.remove(this.lastReturned.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ReferenceIterator();
        }

        @Override
        public int size() {
            return ReferenceMap.this.delegate.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ReferenceMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ReferenceMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public void clear() {
            ReferenceMap.this.delegate.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    implements Map.Entry<K, V> {
        final K key;
        V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            this.value = newValue;
            return ReferenceMap.this.put(this.key, newValue);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() * 31 + this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.key.equals(entry.key) && this.value.equals(entry.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PutStrategy implements Strategy
    {
        PUT{

            public Object execute(ReferenceMap map, Object keyReference, Object valueReference) {
                return map.dereferenceValue(map.delegate.put(keyReference, valueReference));
            }
        }
        ,
        REPLACE{

            public Object execute(ReferenceMap map, Object keyReference, Object valueReference) {
                Object existingValue;
                while (true) {
                    Object existingValueReference;
                    if (ReferenceMap.isExpired(existingValueReference = map.delegate.get(keyReference), existingValue = map.dereferenceValue(existingValueReference))) {
                        continue;
                    }
                    if (existingValueReference == null) {
                        return false;
                    }
                    if (map.delegate.replace(keyReference, existingValueReference, valueReference)) break;
                }
                return existingValue;
            }
        }
        ,
        PUT_IF_ABSENT{

            public Object execute(ReferenceMap map, Object keyReference, Object valueReference) {
                Object existingValue;
                Object existingValueReference;
                while (ReferenceMap.isExpired(existingValueReference = map.delegate.putIfAbsent(keyReference, valueReference), existingValue = map.dereferenceValue(existingValueReference))) {
                }
                return existingValue;
            }
        };

    }

    protected static interface Strategy {
        public Object execute(ReferenceMap var1, Object var2, Object var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FinalizableReferenceQueue
    extends ReferenceQueue<Object> {
        static final ReferenceQueue<Object> instance = FinalizableReferenceQueue.createAndStart();

        private FinalizableReferenceQueue() {
        }

        void cleanUp(Reference reference) {
            try {
                ((InternalReference)((Object)reference)).finalizeReferent();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to clean up after reference", t);
            }
        }

        void start() {
            Thread thread = new Thread("FinalizableReferenceQueue"){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                FinalizableReferenceQueue.this.cleanUp(FinalizableReferenceQueue.this.remove());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }

        static FinalizableReferenceQueue createAndStart() {
            FinalizableReferenceQueue queue = new FinalizableReferenceQueue();
            queue.start();
            return queue;
        }

        public static ReferenceQueue<Object> getInstance() {
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WeakValueReference
    extends WeakReference<Object>
    implements InternalReference {
        final Object keyReference;

        WeakValueReference(Object keyReference, Object value) {
            super(value, FinalizableReferenceQueue.getInstance());
            this.keyReference = keyReference;
        }

        @Override
        public void finalizeReferent() {
            ReferenceMap.this.delegate.remove(this.keyReference, this);
        }

        public boolean equals(Object obj) {
            return ReferenceMap.referenceEquals(this, obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SoftValueReference
    extends SoftReference<Object>
    implements InternalReference {
        final Object keyReference;

        SoftValueReference(Object keyReference, Object value) {
            super(value, FinalizableReferenceQueue.getInstance());
            this.keyReference = keyReference;
        }

        @Override
        public void finalizeReferent() {
            ReferenceMap.this.delegate.remove(this.keyReference, this);
        }

        public boolean equals(Object obj) {
            return ReferenceMap.referenceEquals(this, obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WeakKeyReference
    extends WeakReference<Object>
    implements InternalReference {
        final int hashCode;

        WeakKeyReference(Object key) {
            super(key, FinalizableReferenceQueue.getInstance());
            this.hashCode = System.identityHashCode(key);
        }

        @Override
        public void finalizeReferent() {
            ReferenceMap.this.delegate.remove(this);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return ReferenceMap.referenceEquals(this, o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SoftKeyReference
    extends SoftReference<Object>
    implements InternalReference {
        final int hashCode;

        SoftKeyReference(Object key) {
            super(key, FinalizableReferenceQueue.getInstance());
            this.hashCode = System.identityHashCode(key);
        }

        @Override
        public void finalizeReferent() {
            ReferenceMap.this.delegate.remove(this);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return ReferenceMap.referenceEquals(this, o);
        }
    }

    static class KeyReferenceAwareWrapper
    extends ReferenceAwareWrapper {
        KeyReferenceAwareWrapper(Object wrapped) {
            super(wrapped);
        }

        public int hashCode() {
            return System.identityHashCode(this.wrapped);
        }
    }

    static class ReferenceAwareWrapper {
        final Object wrapped;

        ReferenceAwareWrapper(Object wrapped) {
            this.wrapped = wrapped;
        }

        Object unwrap() {
            return this.wrapped;
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public boolean equals(Object obj) {
            return obj.equals(this);
        }
    }

    static interface InternalReference {
        public void finalizeReferent();

        public Object get();
    }
}

