/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.ArrayUtil;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class NilPICFAndBinData {
    private static final POILogger log = POILogFactory.getLogger(NilPICFAndBinData.class);
    private byte[] _binData;

    public NilPICFAndBinData(byte[] data, int offset) {
        this.fillFields(data, offset);
    }

    public void fillFields(byte[] data, int offset) {
        int lcb = LittleEndian.getInt((byte[])data, (int)offset);
        int cbHeader = LittleEndian.getUShort((byte[])data, (int)(offset + 4));
        if (cbHeader != 68) {
            log.log(5, (Object)"NilPICFAndBinData at offset ", (Object)offset, (Object)(" cbHeader 0x" + Integer.toHexString(cbHeader) + " != 0x44"));
        }
        int binaryLength = lcb - cbHeader;
        this._binData = ArrayUtil.copyOfRange((byte[])data, (int)(offset + cbHeader), (int)(offset + cbHeader + binaryLength));
    }

    public byte[] getBinData() {
        return this._binData;
    }

    public byte[] serialize() {
        byte[] bs = new byte[this._binData.length + 68];
        LittleEndian.putInt((byte[])bs, (int)0, (int)(this._binData.length + 68));
        System.arraycopy(this._binData, 0, bs, 68, this._binData.length);
        return bs;
    }

    public int serialize(byte[] data, int offset) {
        LittleEndian.putInt((byte[])data, (int)offset, (int)(this._binData.length + 68));
        System.arraycopy(this._binData, 0, data, offset + 68, this._binData.length);
        return 68 + this._binData.length;
    }
}

