/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jamwiki.Environment;
import org.jamwiki.db.AnsiQueryHandler;
import org.jamwiki.db.DatabaseConnection;
import org.jamwiki.model.Category;
import org.jamwiki.model.LogItem;
import org.jamwiki.model.RecentChange;
import org.jamwiki.model.TopicType;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.utils.Pagination;
import org.jamwiki.utils.SortedProperties;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheQueryHandler
extends AnsiQueryHandler {
    private static final WikiLogger logger = WikiLogger.getLogger(AnsiQueryHandler.class.getName());
    protected static final String SQL_PROPERTY_FILE_NAME = "sql.cache.properties";

    protected CacheQueryHandler() {
        SortedProperties defaults = Environment.loadProperties("sql.ansi.properties");
        SortedProperties props = Environment.loadProperties(SQL_PROPERTY_FILE_NAME, defaults);
        super.init(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Category> getCategories(int virtualWikiId, String virtualWikiName, Pagination pagination) throws SQLException {
        ArrayList<Category> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getCategoriesStatement(conn, virtualWikiId, virtualWikiName, pagination);
            rs = stmt.executeQuery();
            ArrayList<Category> results = new ArrayList<Category>();
            while (rs.next()) {
                Category category = new Category();
                category.setName(rs.getString("category_name"));
                category.setVirtualWiki(virtualWikiName);
                category.setSortKey(rs.getString("sort_key"));
                results.add(category);
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    @Override
    protected PreparedStatement getCategoriesStatement(Connection conn, int virtualWikiId, String virtualWikiName, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_CATEGORIES);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setInt(2, virtualWikiId);
        stmt.setInt(3, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogItem> getLogItems(int virtualWikiId, String virtualWikiName, int logType, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<LogItem> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getLogItemsStatement(conn, virtualWikiId, virtualWikiName, logType, pagination, descending);
            rs = stmt.executeQuery();
            while (rs.next()) {
                logItems.add(this.initLogItem(rs, virtualWikiName));
            }
            arrayList = logItems;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    @Override
    protected PreparedStatement getLogItemsStatement(Connection conn, int virtualWikiId, String virtualWikiName, int logType, Pagination pagination, boolean descending) throws SQLException {
        int index = 1;
        PreparedStatement stmt = null;
        if (logType == -1) {
            stmt = conn.prepareStatement(STATEMENT_SELECT_LOG_ITEMS);
        } else {
            stmt = conn.prepareStatement(STATEMENT_SELECT_LOG_ITEMS_BY_TYPE);
            stmt.setInt(index++, logType);
        }
        stmt.setInt(index++, pagination.getNumResults());
        stmt.setInt(index++, virtualWikiId);
        stmt.setInt(index++, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getRecentChanges(String virtualWiki, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getRecentChangesStatement(conn, virtualWiki, pagination, descending);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    @Override
    protected PreparedStatement getRecentChangesStatement(Connection conn, String virtualWiki, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_RECENT_CHANGES);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setString(2, virtualWiki);
        stmt.setInt(3, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getTopicHistory(int topicId, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getTopicHistoryStatement(conn, topicId, pagination, descending);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    @Override
    protected PreparedStatement getTopicHistoryStatement(Connection conn, int topicId, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_HISTORY);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setInt(2, topicId);
        stmt.setInt(3, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTopicsAdmin(int virtualWikiId, Pagination pagination) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getTopicsAdminStatement(conn, virtualWikiId, pagination);
            rs = stmt.executeQuery();
            ArrayList<String> results = new ArrayList<String>();
            while (rs.next()) {
                results.add(rs.getString("topic_name"));
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    @Override
    protected PreparedStatement getTopicsAdminStatement(Connection conn, int virtualWikiId, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPICS_ADMIN);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setInt(2, virtualWikiId);
        stmt.setInt(3, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getUserContributionsByLogin(String virtualWiki, String login, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getUserContributionsByLoginStatement(conn, virtualWiki, login, pagination, descending);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    @Override
    protected PreparedStatement getUserContributionsByLoginStatement(Connection conn, String virtualWiki, String login, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_CHANGES_LOGIN);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setString(2, virtualWiki);
        stmt.setString(3, login);
        stmt.setInt(4, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getUserContributionsByUserDisplay(String virtualWiki, String userDisplay, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getUserContributionsByUserDisplayStatement(conn, virtualWiki, userDisplay, pagination, descending);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    @Override
    protected PreparedStatement getUserContributionsByUserDisplayStatement(Connection conn, String virtualWiki, String userDisplay, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_CHANGES_ANONYMOUS);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setString(2, virtualWiki);
        stmt.setString(3, userDisplay);
        stmt.setInt(4, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWatchlist(int virtualWikiId, int userId) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_WATCHLIST);
            stmt.setInt(1, virtualWikiId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            ArrayList<String> watchedTopicNames = new ArrayList<String>();
            while (rs.next()) {
                watchedTopicNames.add(rs.getString("topic_name"));
            }
            arrayList = watchedTopicNames;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getWatchlist(int virtualWikiId, int userId, Pagination pagination) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getWatchlistStatement(conn, virtualWikiId, userId, pagination);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    @Override
    protected PreparedStatement getWatchlistStatement(Connection conn, int virtualWikiId, int userId, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WATCHLIST_CHANGES);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setInt(2, virtualWikiId);
        stmt.setInt(3, userId);
        stmt.setInt(4, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, String> lookupTopicByType(int virtualWikiId, TopicType topicType1, TopicType topicType2, int namespaceStart, int namespaceEnd, Pagination pagination) throws SQLException {
        LinkedHashMap<Integer, String> linkedHashMap;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.lookupTopicByTypeStatement(conn, virtualWikiId, topicType1, topicType2, namespaceStart, namespaceEnd, pagination);
            rs = stmt.executeQuery();
            LinkedHashMap<Integer, String> results = new LinkedHashMap<Integer, String>();
            while (rs.next()) {
                results.put(rs.getInt("topic_id"), rs.getString("topic_name"));
            }
            linkedHashMap = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return linkedHashMap;
    }

    @Override
    protected PreparedStatement lookupTopicByTypeStatement(Connection conn, int virtualWikiId, TopicType topicType1, TopicType topicType2, int namespaceStart, int namespaceEnd, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_BY_TYPE);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setInt(2, virtualWikiId);
        stmt.setInt(3, topicType1.id());
        stmt.setInt(4, topicType2.id());
        stmt.setInt(5, namespaceStart);
        stmt.setInt(6, namespaceEnd);
        stmt.setInt(7, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTopicVersion(TopicVersion topicVersion, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringReader sr = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_TOPIC_VERSION);
                int topicVersionId = this.nextTopicVersionId(conn);
                topicVersion.setTopicVersionId(topicVersionId);
                stmt.setInt(index++, topicVersion.getTopicVersionId());
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_TOPIC_VERSION_AUTO_INCREMENT, 1);
            }
            if (topicVersion.getEditDate() == null) {
                Timestamp editDate = new Timestamp(System.currentTimeMillis());
                topicVersion.setEditDate(editDate);
            }
            stmt.setInt(index++, topicVersion.getTopicId());
            stmt.setString(index++, topicVersion.getEditComment());
            sr = new StringReader(topicVersion.getVersionContent());
            stmt.setCharacterStream(index++, (Reader)sr, topicVersion.getVersionContent().length());
            if (topicVersion.getAuthorId() == null) {
                stmt.setNull(index++, 4);
            } else {
                stmt.setInt(index++, topicVersion.getAuthorId());
            }
            stmt.setInt(index++, topicVersion.getEditType());
            stmt.setString(index++, topicVersion.getAuthorDisplay());
            stmt.setTimestamp(index++, topicVersion.getEditDate());
            if (topicVersion.getPreviousTopicVersionId() == null) {
                stmt.setNull(index++, 4);
            } else {
                stmt.setInt(index++, topicVersion.getPreviousTopicVersionId());
            }
            stmt.setInt(index++, topicVersion.getCharactersChanged());
            stmt.setString(index++, topicVersion.getVersionParamString());
            stmt.executeUpdate();
            if (this.autoIncrementPrimaryKeys()) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new SQLException("Unable to determine auto-generated ID for database record");
                }
                topicVersion.setTopicVersionId(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            sr.close();
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
        sr.close();
    }
}

