/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.db.WikiDatabase;
import org.jamwiki.utils.Encryption;
import org.jamwiki.utils.Utilities;

public class LocalDataSource
extends BasicDataSource {
    public LocalDataSource() throws SQLException, ClassNotFoundException {
        if (!StringUtils.isBlank((String)Environment.getValue("driver"))) {
            Utilities.forName(Environment.getValue("driver"));
        }
        this.setUrl(Environment.getValue("url"));
        this.setUsername(Environment.getValue("db-user"));
        this.setPassword(Encryption.getEncryptedProperty("db-password", null));
        this.setDefaultReadOnly(false);
        this.setMaxActive(Environment.getIntValue("dbcp-max-active"));
        this.setMaxIdle(Environment.getIntValue("dbcp-max-idle"));
        this.setMinEvictableIdleTimeMillis(Environment.getIntValue("dbcp-min-evictable-idle-time") * 1000);
        this.setTestOnBorrow(Environment.getBooleanValue("dbcp-test-on-borrow"));
        this.setTestOnReturn(Environment.getBooleanValue("dbcp-test-on-return"));
        this.setTestWhileIdle(Environment.getBooleanValue("dbcp-test-while-idle"));
        this.setTimeBetweenEvictionRunsMillis(Environment.getIntValue("dbcp-time-between-eviction-runs") * 1000);
        this.setNumTestsPerEvictionRun(Environment.getIntValue("dbcp-num-tests-per-eviction-run"));
        this.setValidationQuery(WikiDatabase.getConnectionValidationQuery());
        if (Environment.getValue("database-type").equals("org.jamwiki.db.OracleDataHandler")) {
            this.addConnectionProperty("SetBigStringTryClob", "true");
        }
        if (this.url.startsWith("jdbc:hsqldb:mem")) {
            this.addConnectionProperty("shutdown", "true");
        }
        Connection testConnection = null;
        try {
            testConnection = this.getConnection();
        }
        catch (SQLException ex) {
            if (this.connectionPool != null) {
                try {
                    this.connectionPool.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ex;
        }
        finally {
            if (testConnection != null) {
                testConnection.close();
            }
        }
        this.connectionPool.setWhenExhaustedAction((byte)Environment.getIntValue("dbcp-when-exhausted-action"));
    }
}

