/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.model;

import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.utils.Utilities;

public class Interwiki {
    private String interwikiDisplay = null;
    private String interwikiPattern = null;
    private String interwikiPrefix = null;
    private int interwikiType = -1;

    public Interwiki(String interwikiPrefix, String interwikiPattern, String interwikiDisplay) {
        this.interwikiPrefix = interwikiPrefix;
        this.interwikiPattern = interwikiPattern;
        this.interwikiDisplay = interwikiDisplay;
    }

    public String getInterwikiDisplay() {
        return this.interwikiDisplay != null ? this.interwikiDisplay.trim() : null;
    }

    public String getInterwikiPattern() {
        return this.interwikiPattern != null ? this.interwikiPattern.trim() : null;
    }

    public String getInterwikiPrefix() {
        return this.interwikiPrefix != null ? this.interwikiPrefix.trim().toLowerCase() : null;
    }

    public int getInterwikiType() {
        return this.interwikiType;
    }

    public void setInterwikiType(int interwikiType) {
        this.interwikiType = interwikiType;
    }

    public String format(String topicName) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)topicName)) {
            topicName = "";
        }
        Object[] objects = new Object[]{Utilities.encodeAndEscapeTopicName(topicName)};
        return MessageFormat.format(this.getInterwikiPattern(), objects);
    }

    public void validate() throws WikiException {
        if (StringUtils.isBlank((String)this.getInterwikiPrefix()) || this.getInterwikiPrefix().length() > 30 || !this.getInterwikiPrefix().matches("[\\p{L}0-9\\._\\-]+")) {
            throw new WikiException(new WikiMessage("admin.vwiki.error.interwiki.prefix", this.getInterwikiPrefix()));
        }
        if (StringUtils.isBlank((String)this.getInterwikiPattern()) || this.getInterwikiPattern().length() > 200 || this.getInterwikiPattern().indexOf("{0}") == -1) {
            throw new WikiException(new WikiMessage("admin.vwiki.error.interwiki.pattern", this.getInterwikiPattern()));
        }
        try {
            this.format("Test");
        }
        catch (IllegalArgumentException e) {
            throw new WikiException(new WikiMessage("admin.vwiki.error.interwiki.pattern", this.getInterwikiPattern()));
        }
        if (StringUtils.isBlank((String)this.getInterwikiDisplay()) || this.getInterwikiDisplay().length() > 30) {
            throw new WikiException(new WikiMessage("admin.vwiki.error.interwiki.display", this.getInterwikiDisplay()));
        }
    }
}

