/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Cache;
import net.htmlparser.jericho.CharSequenceParseText;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EncodingDetector;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.LoggerDisabled;
import net.htmlparser.jericho.LoggerFactory;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.RowColumnVector;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.SourceFormatter;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StreamedParseText;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;
import net.htmlparser.jericho.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Source
extends Segment
implements Iterable<Segment> {
    private final CharSequence sourceText;
    private String documentSpecifiedEncoding = "";
    private String encoding = "";
    private String encodingSpecificationInfo;
    private String preliminaryEncodingInfo = null;
    private String newLine = "";
    private ParseText parseText = null;
    private OutputDocument parseTextOutputDocument = null;
    Logger logger;
    private RowColumnVector[] rowColumnVectorCacheArray = null;
    final Cache cache;
    boolean useAllTypesCache = true;
    boolean useSpecialTypesCache = true;
    int[] fullSequentialParseData = null;
    Tag[] allTagsArray = null;
    List<Tag> allTags = null;
    List<StartTag> allStartTags = null;
    private List<Element> allElements = null;
    private List<Element> childElements = null;
    private static String lastNewLine = null;
    private static final String UNINITIALISED = "";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    static final String PACKAGE_NAME = Source.class.getPackage().getName();
    @Deprecated
    public static boolean LegacyIteratorCompatabilityMode = false;

    public Source(CharSequence charSequence) {
        super(charSequence.length());
        this.sourceText = ((Object)charSequence).toString();
        this.setLogger(Source.newLogger());
        this.cache = new Cache(this);
    }

    private Source(EncodingDetector encodingDetector) throws IOException {
        this(Source.getString(encodingDetector));
        this.encoding = encodingDetector.getEncoding();
        this.encodingSpecificationInfo = encodingDetector.getEncodingSpecificationInfo();
        this.preliminaryEncodingInfo = encodingDetector.getPreliminaryEncoding() + ": " + encodingDetector.getPreliminaryEncodingSpecificationInfo();
    }

    Source(Reader reader, String string) throws IOException {
        this(Util.getString(reader));
        if (string != null) {
            this.encoding = string;
            this.encodingSpecificationInfo = "InputStreamReader.getEncoding() of constructor argument";
        }
    }

    Source(CharSequence charSequence, StreamedParseText streamedParseText, String string, String string2, String string3) {
        super(streamedParseText.getEnd());
        this.cache = Cache.STREAMED_SOURCE_MARKER;
        this.useAllTypesCache = false;
        this.useSpecialTypesCache = false;
        this.fullSequentialParseData = new int[1];
        if (string != null) {
            this.encoding = string;
        }
        this.encodingSpecificationInfo = string2;
        this.preliminaryEncodingInfo = string3;
        this.sourceText = charSequence;
        this.parseText = streamedParseText;
        this.setLogger(Source.newLogger());
    }

    Source(CharSequence charSequence, boolean bl) {
        super(charSequence.length());
        this.sourceText = charSequence;
        this.cache = null;
        this.useAllTypesCache = false;
        this.useSpecialTypesCache = false;
        this.setLogger(LoggerDisabled.INSTANCE);
    }

    public Source(Reader reader) throws IOException {
        this(reader, reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : null);
    }

    public Source(InputStream inputStream) throws IOException {
        this(new EncodingDetector(inputStream));
    }

    public Source(URL uRL) throws IOException {
        this(new EncodingDetector(uRL.openConnection()));
    }

    public Source(URLConnection uRLConnection) throws IOException {
        this(new EncodingDetector(uRLConnection));
    }

    private String setEncoding(String string, String string2) {
        if (this.encoding == UNINITIALISED) {
            this.encoding = string;
            this.encodingSpecificationInfo = string2;
        }
        return string;
    }

    public String getDocumentSpecifiedEncoding() {
        String string;
        StartTag startTag;
        if (this.documentSpecifiedEncoding != UNINITIALISED) {
            return this.documentSpecifiedEncoding;
        }
        Tag tag = this.getTagAt(0);
        if (tag != null && tag.getTagType() == StartTagType.XML_DECLARATION) {
            this.documentSpecifiedEncoding = ((StartTag)tag).getAttributeValue("encoding");
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, tag.toString());
            }
        }
        if ((startTag = this.getFirstStartTag("http-equiv", "content-type", false)) != null && (string = startTag.getAttributeValue("content")) != null) {
            this.documentSpecifiedEncoding = Source.getCharsetParameterFromHttpHeaderValue(string);
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, startTag.toString());
            }
        }
        return this.setEncoding(null, "No encoding specified in document");
    }

    public String getEncoding() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncodingInfo() {
        return this.preliminaryEncodingInfo;
    }

    public boolean isXML() {
        Tag tag = this.getTagAt(0);
        if (tag != null && tag.getTagType() == StartTagType.XML_DECLARATION) {
            return true;
        }
        Tag tag2 = this.getNextTag(0, StartTagType.DOCTYPE_DECLARATION);
        return tag2 != null && this.getParseText().indexOf("xhtml", tag2.begin, tag2.end) != -1;
    }

    public String getNewLine() {
        if (this.newLine != UNINITIALISED) {
            return this.newLine;
        }
        for (int i = 0; i < this.end; ++i) {
            char c = this.sourceText.charAt(i);
            if (c == '\n') {
                lastNewLine = LF;
                this.newLine = LF;
                return LF;
            }
            if (c != '\r') continue;
            lastNewLine = ++i < this.end && this.sourceText.charAt(i) == '\n' ? CRLF : CR;
            this.newLine = lastNewLine;
            return lastNewLine;
        }
        this.newLine = null;
        return null;
    }

    String getBestGuessNewLine() {
        String string = this.getNewLine();
        if (string != null) {
            return string;
        }
        if (lastNewLine != null) {
            return lastNewLine;
        }
        return Config.NewLine;
    }

    public int getRow(int n) {
        return this.getRowColumnVector(n).getRow();
    }

    public int getColumn(int n) {
        return this.getRowColumnVector(n).getColumn();
    }

    public RowColumnVector getRowColumnVector(int n) {
        if (n > this.end) {
            throw new IndexOutOfBoundsException();
        }
        if (this.rowColumnVectorCacheArray == null) {
            this.rowColumnVectorCacheArray = RowColumnVector.getCacheArray(this);
        }
        return RowColumnVector.get(this.rowColumnVectorCacheArray, n);
    }

    @Override
    public String toString() {
        return ((Object)this.sourceText).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] fullSequentialParse() {
        if (this.allTagsArray != null) {
            return this.allTagsArray;
        }
        if (this.cache.getTagCount() != 0) {
            this.logger.warn("Full sequential parse clearing all tags from cache. Consider calling Source.fullSequentialParse() manually immediately after construction of Source.");
            this.cache.clear();
        }
        boolean bl = this.useAllTypesCache;
        try {
            this.useAllTypesCache = false;
            this.useSpecialTypesCache = false;
            Tag[] tagArray = Tag.parseAll(this, false);
            return tagArray;
        }
        finally {
            this.useAllTypesCache = bl;
            this.useSpecialTypesCache = true;
        }
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.getNodeIterator();
    }

    @Override
    public List<Element> getChildElements() {
        if (this.childElements == null) {
            if (this.length() == 0) {
                this.childElements = Collections.emptyList();
            } else {
                StartTag startTag;
                if (this.allTags == null) {
                    this.fullSequentialParse();
                }
                this.childElements = new ArrayList<Element>();
                int n = 0;
                while ((startTag = this.source.getNextStartTag(n)) != null) {
                    if (startTag.getTagType().isServerTag()) {
                        n = startTag.end;
                        continue;
                    }
                    Element element = startTag.getElement();
                    element.getChildElements(0);
                    if (element.parentElement == Element.NOT_CACHED) {
                        element.parentElement = null;
                        this.childElements.add(element);
                    }
                    n = element.end;
                }
            }
        }
        return this.childElements;
    }

    public SourceFormatter getSourceFormatter() {
        return new SourceFormatter(this);
    }

    @Override
    public List<Tag> getAllTags() {
        if (this.allTags == null) {
            this.fullSequentialParse();
        }
        return this.allTags;
    }

    @Override
    public List<StartTag> getAllStartTags() {
        if (this.allStartTags == null) {
            List<Tag> list = this.getAllTags();
            this.allStartTags = new ArrayList<StartTag>(list.size());
            for (Tag tag : list) {
                if (!(tag instanceof StartTag)) continue;
                this.allStartTags.add((StartTag)tag);
            }
        }
        return this.allStartTags;
    }

    @Override
    public List<Element> getAllElements() {
        if (this.allElements == null) {
            List<StartTag> list = this.getAllStartTags();
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            this.allElements = new ArrayList<Element>(list.size());
            for (StartTag startTag : list) {
                this.allElements.add(startTag.getElement());
            }
        }
        return this.allElements;
    }

    public Element getElementById(String string) {
        return this.getFirstElement("id", string, true);
    }

    public final Tag getTagAt(int n) {
        return Tag.getTagAt(this, n, false);
    }

    public Tag getPreviousTag(int n) {
        return Tag.getPreviousTag(this, n);
    }

    public Tag getPreviousTag(int n, TagType tagType) {
        return Tag.getPreviousTag(this, n, tagType);
    }

    public Tag getNextTag(int n) {
        return Tag.getNextTag(this, n);
    }

    Tag getNextNonServerTag(int n) {
        Tag tag;
        while ((tag = this.getNextTag(n)) != null) {
            if (!tag.getTagType().isServerTag()) {
                return tag;
            }
            n = tag.end;
        }
        return null;
    }

    Tag getPreviousNonServerTag(int n) {
        Tag tag;
        while ((tag = this.getPreviousTag(n - 1)) != null) {
            if (!tag.getTagType().isServerTag()) {
                return tag;
            }
            n = tag.begin - 1;
        }
        return null;
    }

    public Tag getNextTag(int n, TagType tagType) {
        return Tag.getNextTag(this, n, tagType);
    }

    public Tag getEnclosingTag(int n) {
        return this.getEnclosingTag(n, null);
    }

    public Tag getEnclosingTag(int n, TagType tagType) {
        Tag tag = this.getPreviousTag(n, tagType);
        if (tag == null || tag.end <= n) {
            return null;
        }
        return tag;
    }

    public Element getNextElement(int n) {
        StartTag startTag = this.getNextStartTag(n);
        return startTag == null ? null : startTag.getElement();
    }

    public Element getNextElement(int n, String string) {
        StartTag startTag = this.getNextStartTag(n, string);
        return startTag == null ? null : startTag.getElement();
    }

    public Element getNextElement(int n, String string, String string2, boolean bl) {
        StartTag startTag = this.getNextStartTag(n, string, string2, bl);
        return startTag == null ? null : startTag.getElement();
    }

    public Element getNextElement(int n, String string, Pattern pattern) {
        StartTag startTag = this.getNextStartTag(n, string, pattern);
        return startTag == null ? null : startTag.getElement();
    }

    public Element getNextElementByClass(int n, String string) {
        StartTag startTag = this.getNextStartTagByClass(n, string);
        return startTag == null ? null : startTag.getElement();
    }

    public StartTag getPreviousStartTag(int n) {
        return StartTag.getPrevious(this, n);
    }

    public StartTag getPreviousStartTag(int n, StartTagType startTagType) {
        return (StartTag)this.getPreviousTag(n, startTagType);
    }

    public StartTag getPreviousStartTag(int n, String string) {
        return this.getPreviousStartTag(n, string, StartTagType.NORMAL);
    }

    public StartTag getPreviousStartTag(int n, String string, StartTagType startTagType) {
        if (string != null) {
            string = string.toLowerCase();
        }
        return StartTag.getPrevious(this, n, string, startTagType);
    }

    public StartTag getNextStartTag(int n) {
        return StartTag.getNext(this, n);
    }

    public StartTag getNextStartTag(int n, StartTagType startTagType) {
        return (StartTag)this.getNextTag(n, startTagType);
    }

    public StartTag getNextStartTag(int n, String string) {
        return this.getNextStartTag(n, string, StartTagType.NORMAL);
    }

    public StartTag getNextStartTag(int n, String string, StartTagType startTagType) {
        if (string != null) {
            string = string.toLowerCase();
        }
        return StartTag.getNext(this, n, string, startTagType);
    }

    public StartTag getNextStartTag(int n, String string, String string2, boolean bl) {
        return StartTag.getNext(this, n, string, string2, bl);
    }

    public StartTag getNextStartTag(int n, String string, Pattern pattern) {
        return StartTag.getNext(this, n, string, pattern);
    }

    public StartTag getNextStartTagByClass(int n, String string) {
        return this.getNextStartTag(n, "class", Source.getClassPattern(string));
    }

    public EndTag getPreviousEndTag(int n) {
        return EndTag.getPrevious(this, n);
    }

    public EndTag getPreviousEndTag(int n, EndTagType endTagType) {
        return (EndTag)this.getPreviousTag(n, endTagType);
    }

    public EndTag getPreviousEndTag(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        return EndTag.getPrevious(this, n, string.toLowerCase(), EndTagType.NORMAL);
    }

    public EndTag getNextEndTag(int n) {
        return EndTag.getNext(this, n);
    }

    public EndTag getNextEndTag(int n, EndTagType endTagType) {
        return (EndTag)this.getNextTag(n, endTagType);
    }

    public EndTag getNextEndTag(int n, String string) {
        return this.getNextEndTag(n, string, EndTagType.NORMAL);
    }

    public EndTag getNextEndTag(int n, String string, EndTagType endTagType) {
        if (string == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        return EndTag.getNext(this, n, string.toLowerCase(), endTagType);
    }

    public Element getEnclosingElement(int n) {
        return this.getEnclosingElement(n, null);
    }

    public Element getEnclosingElement(int n, String string) {
        int n2 = n;
        if (string != null) {
            string = string.toLowerCase();
        }
        boolean bl = Tag.isXMLName(string);
        StartTag startTag;
        while ((startTag = StartTag.getPrevious(this, n2, string, StartTagType.NORMAL, bl)) != null) {
            Element element = startTag.getElement();
            if (n < element.end) {
                return element;
            }
            n2 = startTag.begin - 1;
        }
        return null;
    }

    public CharacterReference getPreviousCharacterReference(int n) {
        return CharacterReference.getPrevious(this, n);
    }

    public CharacterReference getNextCharacterReference(int n) {
        return CharacterReference.getNext(this, n);
    }

    public int getNameEnd(int n) {
        if (!Tag.isXMLNameStartChar(this.sourceText.charAt(n++))) {
            return -1;
        }
        try {
            while (Tag.isXMLNameChar(this.sourceText.charAt(n))) {
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return n;
    }

    public Attributes parseAttributes(int n, int n2) {
        return this.parseAttributes(n, n2, Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n, int n2, int n3) {
        return Attributes.construct(this, n, n2, n3);
    }

    public void ignoreWhenParsing(int n, int n2) {
        if (this.wasFullSequentialParseCalled()) {
            throw new IllegalStateException("ignoreWhenParsing can not be used after a full sequential parse has been performed");
        }
        if (this.parseTextOutputDocument == null) {
            this.parseTextOutputDocument = new OutputDocument(this.getParseText());
            this.parseText = null;
        }
        this.parseTextOutputDocument.replaceWithSpaces(n, n2);
    }

    public void ignoreWhenParsing(Collection<? extends Segment> collection) {
        for (Segment segment : collection) {
            segment.ignoreWhenParsing();
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : LoggerDisabled.INSTANCE;
    }

    public Logger getLogger() {
        return this.logger != LoggerDisabled.INSTANCE ? this.logger : null;
    }

    public void clearCache() {
        this.cache.clear();
        this.allTagsArray = null;
        this.allTags = null;
        this.allStartTags = null;
        this.allElements = null;
    }

    public String getCacheDebugInfo() {
        return this.cache.toString();
    }

    List<Tag> getParsedTags() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        Iterator<Tag> iterator = this.cache.getTagIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public final ParseText getParseText() {
        if (this.parseText == null) {
            if (this.parseTextOutputDocument != null) {
                this.parseText = new CharSequenceParseText(this.parseTextOutputDocument.toString());
                this.parseTextOutputDocument = null;
            } else {
                this.parseText = new CharSequenceParseText(this.sourceText);
            }
        }
        return this.parseText;
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        return this.sourceText.subSequence(n, n2);
    }

    final String substring(int n, int n2) {
        return ((Object)this.subSequence(n, n2)).toString();
    }

    final String getName(int n, int n2) {
        return this.substring(n, n2).toLowerCase();
    }

    @Override
    public final char charAt(int n) {
        return this.sourceText.charAt(n);
    }

    @Override
    public final int length() {
        return this.sourceText.length();
    }

    boolean wasFullSequentialParseCalled() {
        return this.allTagsArray != null;
    }

    static String getCharsetParameterFromHttpHeaderValue(String string) {
        int n = string.toLowerCase().indexOf("charset=");
        if (n == -1) {
            return null;
        }
        int n2 = n + 8;
        int n3 = string.indexOf(59, n2);
        String string2 = n3 == -1 ? string.substring(n2) : string.substring(n2, n3);
        return string2.trim();
    }

    static Logger newLogger() {
        return LoggerFactory.getLogger(PACKAGE_NAME);
    }

    private static String getString(EncodingDetector encodingDetector) throws IOException {
        try {
            return Util.getString(encodingDetector.openReader());
        }
        catch (IOException iOException) {
            try {
                Logger logger = Source.newLogger();
                if (logger.isInfoEnabled()) {
                    logger.info("IOException constructing encoded source. Encoding: " + encodingDetector.getEncoding() + " - " + encodingDetector.getEncodingSpecificationInfo() + ". PreliminaryEncoding: " + encodingDetector.getPreliminaryEncoding() + " - " + encodingDetector.getPreliminaryEncodingSpecificationInfo());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    final boolean isStreamed() {
        return this.cache == Cache.STREAMED_SOURCE_MARKER;
    }
}

