/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import org.jgroups.Message;

public class Event {
    public static final int MSG = 1;
    public static final int CONNECT = 2;
    public static final int DISCONNECT = 4;
    public static final int VIEW_CHANGE = 6;
    public static final int SET_LOCAL_ADDRESS = 8;
    public static final int SUSPECT = 9;
    public static final int BLOCK = 10;
    public static final int FIND_INITIAL_MBRS = 12;
    public static final int FIND_ALL_VIEWS = 13;
    public static final int MERGE = 14;
    public static final int TMP_VIEW = 15;
    public static final int BECOME_SERVER = 16;
    public static final int GET_APPLSTATE = 17;
    public static final int GET_STATE = 19;
    public static final int GET_STATE_OK = 20;
    public static final int STABLE = 30;
    public static final int GET_DIGEST = 39;
    public static final int SET_DIGEST = 41;
    public static final int OVERWRITE_DIGEST = 42;
    public static final int UNSUSPECT = 51;
    public static final int MERGE_DIGEST = 53;
    public static final int CONFIG = 56;
    public static final int SUSPEND_STABLE = 65;
    public static final int RESUME_STABLE = 66;
    public static final int SUSPEND = 68;
    public static final int RESUME = 70;
    public static final int STATE_TRANSFER_INPUTSTREAM = 71;
    public static final int STATE_TRANSFER_OUTPUTSTREAM = 72;
    public static final int STATE_TRANSFER_INPUTSTREAM_CLOSED = 73;
    public static final int UNBLOCK = 75;
    public static final int CLOSE_BARRIER = 76;
    public static final int OPEN_BARRIER = 77;
    public static final int REBROADCAST = 78;
    public static final int CONNECT_WITH_STATE_TRANSFER = 80;
    public static final int GET_PHYSICAL_ADDRESS = 87;
    public static final int GET_LOGICAL_PHYSICAL_MAPPINGS = 88;
    public static final int SET_PHYSICAL_ADDRESS = 89;
    public static final int REMOVE_ADDRESS = 90;
    public static final int GET_LOCAL_ADDRESS = 91;
    public static final int CONNECT_USE_FLUSH = 92;
    public static final int CONNECT_WITH_STATE_TRANSFER_USE_FLUSH = 93;
    public static final int SUSPEND_BUT_FAIL = 94;
    public static final int LOCK = 95;
    public static final int UNLOCK = 96;
    public static final int UNLOCK_ALL = 97;
    public static final int LOCK_AWAIT = 98;
    public static final int LOCK_SIGNAL = 99;
    public static final int IS_MERGE_IN_PROGRESS = 100;
    public static final int GET_PHYSICAL_ADDRESSES = 102;
    public static final int SITE_UNREACHABLE = 104;
    public static final int FORWARD_TO_COORD = 105;
    public static final int USER_DEFINED = 1000;
    private final int type;
    private final Object arg;
    public static final Event GET_DIGEST_EVT = new Event(39);

    public Event(int type) {
        this.type = type;
        this.arg = null;
    }

    public Event(int type, Object arg) {
        this.type = type;
        this.arg = arg;
    }

    public final int getType() {
        return this.type;
    }

    public Object getArg() {
        return this.arg;
    }

    public static String type2String(int t) {
        switch (t) {
            case 1: {
                return "MSG";
            }
            case 2: {
                return "CONNECT";
            }
            case 4: {
                return "DISCONNECT";
            }
            case 6: {
                return "VIEW_CHANGE";
            }
            case 8: {
                return "SET_LOCAL_ADDRESS";
            }
            case 9: {
                return "SUSPECT";
            }
            case 10: {
                return "BLOCK";
            }
            case 12: {
                return "FIND_INITIAL_MBRS";
            }
            case 13: {
                return "FIND_ALL_VIEWS";
            }
            case 15: {
                return "TMP_VIEW";
            }
            case 16: {
                return "BECOME_SERVER";
            }
            case 17: {
                return "GET_APPLSTATE";
            }
            case 19: {
                return "GET_STATE";
            }
            case 20: {
                return "GET_STATE_OK";
            }
            case 30: {
                return "STABLE";
            }
            case 39: {
                return "GET_DIGEST";
            }
            case 41: {
                return "SET_DIGEST";
            }
            case 42: {
                return "OVERWRITE_DIGEST";
            }
            case 14: {
                return "MERGE";
            }
            case 51: {
                return "UNSUSPECT";
            }
            case 53: {
                return "MERGE_DIGEST";
            }
            case 56: {
                return "CONFIG";
            }
            case 65: {
                return "SUSPEND_STABLE";
            }
            case 66: {
                return "RESUME_STABLE";
            }
            case 68: {
                return "SUSPEND";
            }
            case 94: {
                return "SUSPEND_BUT_FAIL";
            }
            case 70: {
                return "RESUME";
            }
            case 71: {
                return "STATE_TRANSFER_INPUTSTREAM";
            }
            case 72: {
                return "STATE_TRANSFER_OUTPUTSTREAM";
            }
            case 73: {
                return "STATE_TRANSFER_INPUTSTREAM_CLOSED";
            }
            case 75: {
                return "UNBLOCK";
            }
            case 76: {
                return "CLOSE_BARRIER";
            }
            case 77: {
                return "OPEN_BARRIER";
            }
            case 78: {
                return "REBROADCAST";
            }
            case 80: {
                return "CONNECT_WITH_STATE_TRANSFER";
            }
            case 87: {
                return "GET_PHYSICAL_ADDRESS";
            }
            case 88: {
                return "GET_LOGICAL_PHYSICAL_MAPPINGS";
            }
            case 89: {
                return "SET_PHYSICAL_ADDRESS";
            }
            case 90: {
                return "REMOVE_ADDRESS";
            }
            case 91: {
                return "GET_LOCAL_ADDRESS";
            }
            case 92: {
                return "CONNECT_USE_FLUSH";
            }
            case 93: {
                return "CONNECT_WITH_STATE_TRANSFER_USE_FLUSH";
            }
            case 95: {
                return "LOCK";
            }
            case 96: {
                return "UNLOCK";
            }
            case 97: {
                return "UNLOCK_ALL";
            }
            case 98: {
                return "LOCK_AWAIT";
            }
            case 99: {
                return "LOCK_SIGNAL";
            }
            case 100: {
                return "IS_MERGE_IN_PROGRESS";
            }
            case 102: {
                return "GET_PHYSICAL_ADDRESSES";
            }
            case 104: {
                return "SITE_UNREACHABLE";
            }
            case 105: {
                return "FORWARD_TO_COORD";
            }
            case 1000: {
                return "USER_DEFINED";
            }
        }
        return "UNDEFINED(" + t + ")";
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(64);
        ret.append("Event[type=" + Event.type2String(this.type) + ", arg=" + this.arg + ']');
        if (this.type == 1) {
            ret.append(" (headers=").append(((Message)this.arg).printHeaders()).append(")");
        }
        return ret.toString();
    }
}

