/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Arrays;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.util.Digest;

public class MutableDigest
extends Digest {
    protected static final double RESIZE_FACTOR = 1.2;
    protected boolean sealed = false;
    protected int current_index = 0;

    protected MutableDigest(Address[] members, long[] seqnos, int current_index) {
        super(members, seqnos);
        this.current_index = current_index;
    }

    public MutableDigest() {
    }

    public MutableDigest(int size) {
        this.createArrays(size);
    }

    public MutableDigest(Map<Address, long[]> map) {
        super(map);
        this.current_index = map.size();
    }

    public MutableDigest(Digest digest) {
        super(digest);
        this.current_index = digest.size();
    }

    public void add(Address member, long highest_delivered_seqno, long highest_received_seqno) {
        this.add(member, highest_delivered_seqno, highest_received_seqno, true);
    }

    public void add(Address member, long highest_delivered_seqno, long highest_received_seqno, boolean replace) {
        int index;
        if (member == null) {
            return;
        }
        this.checkSealed();
        if (replace && (index = this.find(member)) >= 0) {
            this.seqnos[index * 2] = highest_delivered_seqno;
            this.seqnos[index * 2 + 1] = highest_received_seqno;
            return;
        }
        if (this.current_index >= this.members.length) {
            this.resize();
        }
        this.members[this.current_index] = member;
        this.seqnos[this.current_index * 2] = highest_delivered_seqno;
        this.seqnos[this.current_index * 2 + 1] = highest_received_seqno;
        ++this.current_index;
    }

    public void add(Digest digest) {
        this.add(digest, true);
    }

    public void add(Digest digest, boolean replace) {
        if (digest == null) {
            return;
        }
        this.checkSealed();
        for (Digest.DigestEntry entry : digest) {
            this.add(entry.getMember(), entry.getHighestDeliveredSeqno(), entry.getHighestReceivedSeqno(), replace);
        }
    }

    public void replace(Digest d) {
        if (d == null) {
            return;
        }
        this.clear();
        this.createArrays(d.size());
        this.add(d, false);
    }

    @Override
    public MutableDigest copy() {
        return new MutableDigest(Arrays.copyOf(this.members, this.members.length), Arrays.copyOf(this.seqnos, this.seqnos.length), this.current_index);
    }

    public void merge(Digest digest) {
        if (digest == null) {
            return;
        }
        this.checkSealed();
        for (Digest.DigestEntry entry : digest) {
            this.merge(entry.getMember(), entry.getHighestDeliveredSeqno(), entry.getHighestReceivedSeqno());
        }
    }

    public void merge(Address member, long highest_delivered_seqno, long highest_received_seqno) {
        if (member == null) {
            return;
        }
        this.checkSealed();
        long[] entry = this.get(member);
        if (entry == null) {
            this.add(member, highest_delivered_seqno, highest_received_seqno, false);
        } else {
            this.add(member, Math.max(entry[0], highest_delivered_seqno), Math.max(entry[1], highest_received_seqno));
        }
    }

    public void incrementHighestDeliveredSeqno(Address member) {
        long[] entry = this.get(member);
        if (entry == null) {
            return;
        }
        this.checkSealed();
        long new_highest_delivered = entry[0] + 1L;
        long new_highest_received = Math.max(entry[1], new_highest_delivered);
        this.add(member, new_highest_delivered, new_highest_received, true);
    }

    public void clear() {
        this.checkSealed();
        this.current_index = 0;
    }

    public void setHighestDeliveredAndSeenSeqnos(Address member, long highest_delivered_seqno, long highest_received_seqno) {
        long[] entry = this.get(member);
        if (entry != null) {
            this.checkSealed();
            this.add(member, highest_delivered_seqno, highest_received_seqno, true);
        }
    }

    public void seal() {
        this.sealed = true;
    }

    @Override
    public int size() {
        return this.current_index;
    }

    protected void resize() {
        int new_size = Math.max((int)((double)this.members.length * 1.2), this.members.length + 1);
        this.members = Arrays.copyOf(this.members, new_size);
        this.seqnos = Arrays.copyOf(this.seqnos, new_size * 2);
    }

    protected final void checkSealed() {
        if (this.sealed) {
            throw new IllegalAccessError("instance has been sealed and cannot be modified");
        }
    }
}

