/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.IdentityHashMap;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;

public class QueryByExampleMechanism
extends ExpressionQueryMechanism {
    protected boolean isParsed = false;
    protected Object exampleObject;
    protected QueryByExamplePolicy queryByExamplePolicy;

    public QueryByExampleMechanism(DatabaseQuery query) {
        super(query);
    }

    public QueryByExampleMechanism(DatabaseQuery query, Expression expression) {
        super(query, expression);
    }

    public void buildSelectionCriteria(AbstractSession session) {
        if (this.isParsed() || this.getExampleObject() == null) {
            return;
        }
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.getQuery();
        query.checkDescriptor(session);
        QueryByExamplePolicy policy = this.getQueryByExamplePolicy();
        if (policy == null) {
            policy = new QueryByExamplePolicy();
        }
        if (query.getReferenceClass().isInstance(this.getExampleObject())) {
            Expression exampleExpression = query.getDescriptor().getObjectBuilder().buildExpressionFromExample(this.getExampleObject(), policy, query.getExpressionBuilder(), new IdentityHashMap(), session);
            if (this.getSelectionCriteria() != null) {
                this.setSelectionCriteria(this.getSelectionCriteria().and(exampleExpression));
            } else {
                this.setSelectionCriteria(exampleExpression);
            }
        } else {
            throw QueryException.exampleAndReferenceObjectClassMismatch(this.getExampleObject().getClass(), query.getReferenceClass(), query);
        }
        this.setIsParsed(true);
    }

    public Object getExampleObject() {
        return this.exampleObject;
    }

    public QueryByExamplePolicy getQueryByExamplePolicy() {
        return this.queryByExamplePolicy;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    public boolean isQueryByExampleMechanism() {
        return true;
    }

    public void setExampleObject(Object newExampleObject) {
        this.exampleObject = newExampleObject;
    }

    public void setIsParsed(boolean newIsParsed) {
        this.isParsed = newIsParsed;
    }

    public void setQueryByExamplePolicy(QueryByExamplePolicy queryByExamplePolicy) {
        this.queryByExamplePolicy = queryByExamplePolicy;
    }
}

