/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Setting.Enum;

public class StatusFlagEnum {
    public static final int DIRECT_CONNECTION_ALLOWED = 0;
    public static final int DIRECT_CONNECTION_AUTHORIZATION = 0x10000000;
    public static final int DIRECT_CONNECTION_CONTACT = 0x20000000;
    public static final int SHOW_IP = 131072;
    public static final int WEBAWARE = 196608;
    public static final int BIRTHDAY = 524288;
    private int flag;

    public StatusFlagEnum(int flag, boolean showIp, boolean webAware, boolean birthday) {
        this.flag = flag;
        if (showIp) {
            this.flag |= 0x20000;
        }
        if (webAware) {
            this.flag |= 0x30000;
        }
        if (birthday) {
            this.flag |= 0x80000;
        }
    }

    public StatusFlagEnum(int flag) {
        this.flag = flag;
    }

    public int getFlag() {
        return this.flag;
    }

    public String toString() {
        String ret = "";
        if (this.flag < 0x130000) {
            ret = "Direct connection allowed";
        } else if ((this.flag & 0x10000000) == 0x10000000) {
            ret = "Direct connection authorization";
        } else if ((this.flag & 0x20000000) == 0x20000000) {
            ret = "Direct connection contact";
        }
        if ((this.flag & 0x20000) == 131072) {
            ret = ret + " show ip";
        }
        if ((this.flag & 0x30000) == 196608) {
            ret = ret + " webaware";
        }
        if ((this.flag & 0x80000) == 524288) {
            ret = ret + " birthday";
        }
        return ret;
    }
}

